<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/basehelper.php';

/**
 * 店铺风格相关Helper层实现
 * @author L.iuHu.I
 */
class PW_StyleHelper extends BaseHelper {
	
	/**
	 * 获得全部店铺风格列表
	 * @return array
	 */
	function getStyles() {
		$styleService = $this->getStylesService();
		$styleLists = $styleService->getStyles();
		$styles = $this->getUnUserStyle();
		foreach ($styleLists as $list) {
			if (isset($styles[$list['filename']])) unset($styles[$list['filename']]);
		}
		$styles = (is_array($styles)) ? $styles : array();
		$styleLists = array_merge($styleLists, $styles);
		$result = array();
		foreach ($styleLists as $key => $list) {
			$list['state'] = $this->_checkStylePath($list['filename']);
			$result[$list['filename']] = $list;
		}
		ksort($result);
		return $result;
	}
	
	/**
	 * 添加店铺风格
	 * @param array $fieldDatas
	 * @return boolean
	 */
	function addStyles($fieldDatas) {
		$styleService = $this->getStylesService();
		return $styleService->addStyles($fieldDatas);
	}
	
	/**
	 * 编辑店铺风格
	 * @param array $newstyles
	 * @param array $styles
	 * @return boolean
	 */
	function operateStyles($newstyles, $styles) {
		list($filenames, $titles) = array($newstyles['filename'], $newstyles['title']);
		$styleService = $this->getStylesService();
		if (S::isArray($styles)) {
			foreach ($styles as $styleId => $v) {
				$v['title'] = $v['title'] ? $v['title'] : $v['filename'];
				$styleService->updateStyle(array('title' => $v['title']), $styleId);
			}
		}
		return true;
	}
	
	/**
	 * 获得还未添加到风格表中的风格列表
	 * @return array
	 */
	function getUnUserStyle() {
		$styles = $this->getStylesDirectory();
		if (!$styles) return array();
		$tmp = array();
		foreach ($styles as $style) {
			$t = array();
			$t['styleid'] = 0;
			$t['title'] = $style;
			$t['filename'] = $style;
			$tmp[$style] = $t;
		}
		return $tmp;
	}
	
	/**
	 * 根据风格名称删除风格
	 * @param string $filename
	 * @return array 
	 */
	function deleteStyle($filename) {
		$styleService = $this->getStylesService();
		$style = $styleService->getStyleByFilename($filename);
		if ($style && !$styleService->deleteStyle($style['styleid'])) {return array(false, '操作失败');}
		$styleDirectory = $this->_getStylePath() . '/' . $filename;
		if (is_dir($styleDirectory)) {
			@rmdir($styleDirectory);
		}
		return array(false, '操作成功');
	}
	
	/**
	 * 停用店铺风格店铺风格
	 * @param string $filename
	 * @return boolean
	 */
	function stopStyle($filename) {
		if (!$filename) return $this->_addError('非法操作');
		$styleService = $this->getStylesService();
		$style = $styleService->getStyleByFilename($filename);
		if ($style && !$styleService->deleteStyle($style['styleid'])) return $this->_addError('停用操作失败');
		return true;
	}
	
	/**
	 * 启用店铺风格
	 * @param string $filename
	 * @return boolean
	 */
	function startStyle($filename, $title) {
		if (!$filename) return $this->_addError('非法操作');
		$fieldDatas = array(array('title' => $title, 'filename' => $filename));
		$styleService = $this->getStylesService();
		return $styleService->addStyles($fieldDatas);
	}
	
	/**
	 * 从风格文件夹目录中获得所有风格样式
	 * @return array
	 */
	function getStylesDirectory() {
		$stylePath = $this->_getStylePath();
		$dirs = array();
		if (!is_dir($stylePath)) {return array();}
		$dh = opendir($stylePath);
		if (!$dh) return array();
		while (($file = readdir($dh)) !== false) {
			if ($file == '.' || $file == '..' || strpos($file, '.') === 0) continue;
			$dirs[] = $file;
		}
		closedir($dh);
		return $dirs;
	}
	
	/**
	 * 检查风格路径的合法性
	 * @param string $filename
	 * @return string
	 */
	function _checkStylePath($filename) {
		$stylePath = $this->_getStylePath() . '/' . $filename;
		if (!is_dir($stylePath)) return '风格目录不存在';
		if (!is_dir($stylePath . '/images')) return '/images不存在';
		if (!file_exists($stylePath . '/images/style.css')) return 'style.css不存在';
		return '正常';
	}
	
	/**
	 * 获得风格文件夹路径
	 * @return string
	 */
	function _getStylePath() {
		return MODE . '/themes';
	}
}