<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/basehelper.php';

/**
 * 店铺区域Helper层实现
 * @author L.iuHu.I
 */
class PW_AreasHelper extends BaseHelper {
	
	/**
	 * 获得全部区域
	 * @return array
	 */
	function getAreas() {
		$areaService = $this->getAreasService();
		return $areaService->getAreas();
	}
	
	/**
	 * 获取全部区域不经过缓存
	 * @return array
	 */
	function getAreasNoCache() {
		$areaService = $this->getAreasService();
		return $areaService->getAreasNoCache();
	}
	
	/**
	 * 添加区域
	 * @param array $presence
	 * @param array $sort
	 * @param array $name
	 * @return boolean
	 */
	function addAreas($presence, $sort, $name) {
		$areaService = $this->getAreasService();
		if (!S::isArray($sort) || !S::isArray($name) || !S::isArray($presence)) return $this->_addError('非法请求！');
		$tmp = array();
		foreach ($sort as $k => $v) {
			($name[$k]) && $tmp[] = array('sort' => intval($v), 'name' => $name[$k]);
		}
		$areaService->addAreas($tmp);
		foreach ($presence as $areaId => $area) {
			$areaId = intval($areaId);
			$areaService->updateArea(array('sort' => intval($area['sort']), 'name' => trim($area['name'])), $areaId);
		}
		return true;
	}
	
	/**
	 * 根据区域ID删除一条区域数据
	 * @param int $areaId
	 * @return boolean
	 */
	function deleteArea($areaId) {
		$areaId = intval($areaId);
		if ($areaId < 1) return $this->_addError('非法请求');
		$dianpuService = $this->getDianpuService();
		if (count($dianpuService->search(array('areaid' => array($areaId, 'eq')), 0, 1))) return $this->_addError('该地区下已经存在店铺，不允许删除！');
		$areaService = $this->getAreasService();
		if (!$areaService->deleteArea($areaId)) return $this->_addError('删除失败');
		return true;
	}
}