<?php
!defined('P_W') && exit('Forbidden');
/**
 * 店铺风格管理DB层实现
 * @author L.iuHu.I
 */
class PW_Dianpu_StylesDB extends BaseDB {
	var $_tableName = 'pw_dianpu_styles';
	var $_primaryKey = 'styleid';
	
	/**
	 * 添加店铺风格数据
	 * @param array $fieldData
	 * @return int
	 */
	function insert($fieldData) {
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_insert($fieldData);
	}
	
	/**
	 * 根据店铺ID更新店铺风格
	 * @param array $fieldData
	 * @param int $id
	 * @return int
	 */
	function update($fieldData, $id) {
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_update($fieldData, $id);
	}
	
	/**
	 * 根据店铺风格ID删除店铺风格
	 * @param int $id
	 * @return int
	 */
	function delete($id) {
		return $this->_delete($id);
	}
	
	/**
	 * 根据店铺风格ID获得一个店铺风格
	 * @param int $id
	 * @return array
	 */
	function get($id) {
		return $this->_get($id);
	}
	
	/**
	 * 获得店铺风格列表总数
	 * @return int
	 */
	function count() {
		return $this->_count();
	}
	
	/**
	 * 获得店铺风格列表
	 * @return array
	 */
	function gets() {
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据店铺风格ID获得店铺风格列表
	 * @param array $ids
	 * @return array
	 */
	function getsByIds($ids) {
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE styleid in(" . $this->_getImplodeString($ids) . ")");
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 添加店铺风格
	 * @param array $fieldDatas
	 * @return int
	 */
	function addStyles($fieldDatas) {
		$this->_db->update("INSERT INTO " . $this->_tableName . " (title,filename,createdtime) VALUES  " . pwSqlMulti($fieldDatas, FALSE));
		return $this->_db->insert_id();
	}
	
	/**
	 * 根据文件名称获得店铺风格
	 * @param string $filename
	 * @return array
	 */
	function getByFileName($filename) {
		$filename = trim($filename);
		return $this->_db->get_one("SELECT * FROM " . $this->_tableName . " WHERE filename=" . $this->_addSlashes($filename));
	}
	
	/**
	 * 获得店铺风格数据表结构
	 * @return array 
	 */
	function getStruct() {
		return array('styleid', 'title', 'filename', 'status', 'createdtime');
	}
}