<?php
!defined('P_W') && exit('Forbidden');
/**
 * 产品点击率附表
 * @author liuh
 */
class PW_Dianpu_ProducthitsDB extends BaseDB {
	var $_tableName = 'pw_dianpu_producthits';
	var $_primaryKey = 'id';
	
	/**
	 * 添加商品点击率
	 * @param array $fieldData
	 * @return int
	 */
	function insert($fieldData) {
		return $this->_insert($fieldData);
	}
	
	/**
	 * 根据商品ID更新商品点击率
	 * @param array $fieldData
	 * @param int $id
	 * @return int
	 */
	function update($fieldData, $id) {
		return $this->_update($fieldData, $id);
	}
	
	/**
	 * 根据商品ID删除商品点击率
	 * @param int $id
	 * @return int
	 */
	function delete($id) {
		return $this->_delete($id);
	}
	
	/**
	 * 根据商品ID获得商品数据
	 * @param int $id
	 * @return array
	 */
	function get($id) {
		return $this->_get($id);
	}
	
	/**
	 * 获得商品点击率数
	 * @return int
	 */
	function count() {
		return $this->_count();
	}
	
	/**
	 * 根据商品ID更新商品点击率
	 * @param int $id
	 * @return array
	 */
	function updateHits($id) {
		$this->_db->update("UPDATE " . $this->_tableName . " SET hits = hits + 1 WHERE id =" . $this->_addSlashes($id));
		return $this->_db->affected_rows();
	}
	
	/**
	 * 获得商品点击率列表
	 * @param int $start (开始位置)
	 * @param int $offset (查询数量)
	 * @return array 
	 */
	function gets($start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		if ($offset < 1) {
			return false;
		}
		$query = $this->_db->query("SELECT id FROM " . $this->_tableName . " ORDER BY hits DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 获得商品点击率表数据结构信息
	 * @return array()
	 */
	function getStruct() {
		return array('id', 'hits');
	}
}