<?php
!defined('P_W') && exit('Forbidden');
/**
 * 店铺商品图片表DB层实现
 * @author liuh
 */
class PW_Dianpu_PhotosDB extends BaseDB {
	var $_tableName = 'pw_dianpu_photos';
	var $_primaryKey = 'photoid';
	
	/**
	 * 添加店铺商品图片
	 * @param array $fieldData
	 * @return int
	 */
	function insert($fieldData) {
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_insert($fieldData);
	}
	
	/**
	 * 根据照片ID更新店铺商品图片
	 * @param array $fieldData
	 * @param int $id
	 * @return int
	 */
	function update($fieldData, $id) {
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_update($fieldData, $id);
	}
	
	/**
	 * 根据照片ID删除店铺商品图片
	 * @param int $id
	 * @return int
	 */
	function delete($id) {
		return $this->_delete($id);
	}
	
	/**
	 * 根据照片ID获得商品图片信息
	 * @param int $id
	 * @return array
	 */
	function get($id) {
		return $this->_get($id);
	}
	
	/**
	 * 获得商品图片总数
	 * @return int
	 */
	function count() {
		return $this->_count();
	}
	
	/**
	 * 批量添加商品图片
	 * @param array $fieldDatas
	 * @return int
	 */
	function addPhotos($fieldDatas) {
		$this->_db->update("INSERT INTO " . $this->_tableName . " (belongid,objectid,typeid,filename,path,createdtime) VALUES  " . pwSqlMulti($fieldDatas, FALSE));
		return $this->_db->insert_id();
	}
	
	/**
	 * 根据商品图片ID和商品ID删除商品图片
	 * @param int $photoId
	 * @param int $belongId
	 * @return int
	 */
	function deleteByPhotoIdAndBelongId($photoId, $belongId) {
		$photoId = intval($photoId);
		$belongId = intval($belongId);
		if ($photoId < 1 || $belongId < 1) {
			return false;
		}
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE photoid= " . $this->_addSlashes($photoId) . " AND belongid = " . $this->_addSlashes($belongId));
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据商品ID获得商品图片ID
	 * @param int $objectid
	 * @param int $start
	 * @param int $offset
	 * @return Array
	 */
	function getsByObjectId($objectid, $start, $offset) {
		$objectid = intval($objectid);
		$start = intval($start);
		$offset = intval($offset);
		if ($objectid < 1 || $offset < 1) {
			return false;
		}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid) . " ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据图片ID批量获取商品图片信息
	 * @param array $photoIds
	 * @return array
	 */
	function getPhotosByIds($photoIds) {
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE photoid IN ( " . $this->_getImplodeString($photoIds) . " )");
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据商品ID获得当前商品上传图片数
	 * @param int $objectid
	 * @return int
	 */
	function countByObjectId($objectid) {
		$objectid = intval($objectid);
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid));
		return $result['total'];
	}
	
	/**
	 * 获得店铺商品图片表数据结构信息
	 * @return array()
	 */
	function getStruct() {
		return array('photoid', 'objectid', 'belongid', 'typeid', 'filename', 'path', 'createdtime');
	}

}