<?php
!defined('M_P') && exit('Forbidden');
/**
 * 用户评论二级评论回复表DB实现
 * @author xiaoxia.xuxx
 */
class PW_Dianpu_CommentReplysDB extends BaseDB {
	var $_tableName = 'pw_dianpu_commentreplys';
	var $_primaryKey = 'commentid';
	
	/**
	 * 插入二级评论的信息
	 * @param array $fieldData 待插入的评论信息
	 * @return integer 返回插入的ID
	 */
	function insert($fieldData) {
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_insert($fieldData);
	}
	
	/**
	 * 从后台根据评论ID删除评论信息
	 * @param array $commentid  评论的ID列表
	 * @return integer 返回删除影响到的记录数
	 */
	function delForAdmin($commentid) {
		if (!$commentid) return false;
		return $this->_delete($commentid);
	}
	
	/**
	 * 从后台根据评论ID列表批量删除多个评论信息
	 * (目前只实现到三级的级联删除)
	 * @param array $commentid 评论ID列表
	 * @return integer 返回删除的影响记录数
	 */
	function delsForAdmin($commentid) {
		if (!$commentid) return false;
		if (!S::isArray($commentid)) $commentid = array($commentid);
		$_sql = "DELETE FROM " . $this->_tableName . " WHERE commentid IN (" . $this->_getImplodeString($commentid) . ") OR parentid IN (" . $this->_getImplodeString($commentid) . ")";
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 管理员根据rootID删除多个评论信息
	 * @param integer $rootid 根级评论ID
	 * @return integer 返回删除的影响记录数
	 */
	function deletesByRootIDForAdmin($rootid) {
		if (!$rootid) return false;
		if (!S::isArray($rootid)) $rootid = array($rootid);
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE rootid IN (" . $this->_getImplodeString($rootid) . ")");
		return $this->_db->affected_rows();
	}
	
	/**
	 * 前台删除二级评论信息,需要传入被删除的评论所在的店铺信息及被删除的评论ID
	 * @param array $commentid  评论的ID列表
	 * @param integer $objectid 店铺ID（或者是对象ID）
	 * @return integer 返回删除影响到的记录数
	 */
	function delete($commentid, $objectid) {
		if (!$commentid || !$objectid) return false;
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE commentid = " . $this->_addSlashes($commentid) . " AND objectid= " . $this->_addSlashes($objectid));
		return $this->_db->affected_rows();
	}
	
	/**
	 * 批量删除多个评论信息  (目前只实现到三级的级联删除),需要传入被删除的评论所在的店铺ID及被删除的评论ID列表
	 * @param array $commentid 评论ID列表
	 * @param integer $objectid 店铺ID（或者对象ID）
	 * @return integer 返回删除的影响记录数
	 */
	function deletes($commentid, $objectid) {
		if (!$commentid || !$objectid) return false;
		if (!S::isArray($commentid)) $commentid = array($commentid);
		$_sql = "DELETE FROM " . $this->_tableName . " WHERE commentid IN (" . $this->_getImplodeString($commentid) . ") OR parentid IN (" . $this->_getImplodeString($commentid) . ") AND objectid=" . $this->_addSlashes($objectid);
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 前台根据rootID删除多个评论信息,需要传入被删除的评论所在的店铺信息及根级评论ID
	 * @param integer $rootid 根级评论ID
	 * @param integer $objectid 店铺ID (或者是对象ID）
	 * @return integer 返回删除的影响记录数
	 */
	function deletesByRootID($rootid, $objectid) {
		if (!$rootid || !$objectid) return false;
		if (!S::isArray($rootid)) $rootid = array($rootid);
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE rootid IN (" . $this->_getImplodeString($rootid) . ") AND objectid=" . $this->_addSlashes($objectid));
		return $this->_db->affected_rows();
	}
	
	/**
	 * 通过评论ID获得该条评论的根级评论ID
	 * @param integer $commentid 评论ID
	 * @return array array('rootid) 返回根级评论ID
	 */
	function getRootidByCommentid($commentid) {
		if (!$commentid) return false;
		return $this->_db->get_one("SELECT rootid FROM " . $this->_tableName . ' WHERE commentid = ' . $this->_addSlashes($commentid));
	}
	
	/**
	 * 根据根级评论ID和父级评论ID获得旗下所有的子级评论ID
	 * 为了完全删除其级下的所有相关评论，需要先查找出所有相关的评论ID
	 * 此处为确认所有被删除ID中根级的ID列表
	 * @param integer $rootid 根级评论的ID
	 * @param integer $parentid 父级评论的ID
	 * @return mixed boolean (false:操作失败) | array array(array(commentid,parentid),array(commentid,parentid),...) 返回符合条件的ID数组
	 */
	function getCommentidByRootid($rootid, $parentid = 0) {
		if (!$rootid) return false;
		$_where = '';
		if (intval($parentid) != 0) $_where .= ' AND parentid = ' . $this->_addSlashes($parentid);
		$query = $this->_db->query("SELECT commentid,parentid FROM " . $this->_tableName . ' WHERE rootid IN ( ' . $this->_getImplodeString($rootid) . ')' . $_where);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据父级评论ID获得该父级评论下的所有子级评论
	 * 当删除多条评论的时候，三级评论的ID根据父类的ID来获得(适用于三级评论的删除）
	 * @param integer $parentid
	 * @return mixed boolean (false: 操作失败) | array array(array(commentid, rootid),array(commentid, rootid)...) 返回符合条件的数组列表
	 */
	function getCommentidByParentid($parentid) {
		if (!$parentid) return false;
		$query = $this->_db->query("SELECT commentid,rootid FROM " . $this->_tableName . ' WHERE parentid IN ( ' . $this->_getImplodeString($parentid) . ')');
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 获得的是pw_dianpu_commentreplys的数据库表结构
	 * @return array 返回数据库表的数据结构
	 */
	function getStruct() {
		return array('commentid', 'parentid', 'rootid', 'postdate', 'objectid');
	}
}
?>