<?php
!defined('P_W') && exit('Forbidden');
/**
 * 商家导航-区域管理表
 * @author liuhui@2010-09-30
 */
class PW_Dianpu_areasDB extends BaseDB {
	var $_tableName = 'pw_dianpu_areas';
	var $_primaryKey = 'areaid';
	
	/**
	 * 执行地区的插入数据库操作
	 * @param array $fieldData('字段'=>'值')
	 * @return integer 插入的ID值
	 */
	function insert($fieldData) {
		return $this->_insert($fieldData);
	}
	
	/**
	 * 执行地区的更新操作
	 * @param array $fieldData
	 * @param integer $id 
	 * @return integer 
	 */
	function update($fieldData, $id) {
		return $this->_update($fieldData, $id);
	}
	
	/**
	 * 执行地区的删除操作
	 * @param integer $id
	 * @return integer
	 */
	function delete($id) {
		return $this->_delete($id);
	}
	
	/**
	 * 执行地区的查询操作，返回一条
	 * @param integer $id
	 * @return array
	 */
	function get($id) {
		return $this->_get($id);
	}
	
	/**
	 * 执行计算总值的操作
	 * @return integer
	 */
	function count() {
		return $this->_count();
	}
	
	/**
	 * 获得地区列表，根据排序字段排序
	 * @return array
	 */
	function gets() {
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " ORDER BY sort ASC");
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 批量添加地区
	 * @param array $fieldDatas
	 * @return integer 返回最后的ID值
	 */
	function addAreas($fieldDatas) {
		$this->_db->update("INSERT INTO " . $this->_tableName . " (name,sort,createdtime) VALUES  " . pwSqlMulti($fieldDatas, FALSE));
		return $this->_db->insert_id();
	}
	
	/**
	 * 根据地区的ID获得地区列表
	 * @param array $ids
	 * @return array
	 */
	function getsByIds($ids) {
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE areaid in(" . $this->_getImplodeString($ids) . ") ORDER BY sort ASC");
		return $this->_getAllResultFromQuery($query);
	}
	
}