var DP = {
	showMessageId : "showmessage",
	baseUrl : "",

	$ : function(id) {
		return document.getElementById(id);
	},

	/* ajax post submit */
	post : function(url, data, callback, sCallback, fCallback, isTips) {
		var _this = this;
		ajax.send(url, data, function() {
			callback ? callback() : 0;
			isTips ? _this._showMessage(ajax.request.responseText, sCallback,
					fCallback) : 0;
		});
	},

	/* private show message include success and fail */
	_showMessage : function(txt, sCallback, fCallback) {
		if (!txt || txt.indexOf('{') == '-1')
			return false;
		var r = JSONParse(txt);
		if (r.bool) {
			this.showSuccessTips(r.message);
			sCallback ? sCallback() : 0;
		} else {
			this.showFailTips(r.message);
			fCallback ? fCallback() : 0;
		}
	},

	showSuccessTips : function(message, otherid) {
		if (!message)
			return false;
		var mdiv = otherid ? this.$(otherid) : this.$(this.showMessageId);
		mdiv.innerHTML = message;
		mdiv.className = "rightTip mb10"; // 修改
		mdiv.style.display = '';
		return this;
	},

	showFailTips : function(message, otherid) {
		if (!message)
			return false;
		alert(DP.showFailTips.caller);
		var mdiv = otherid ? this.$(otherid) : this.$(this.showMessageId);
		mdiv.innerHTML = message;
		mdiv.className = "wrongTip mb10"; // 修改
		mdiv.style.display = '';
		return this;
	},

	fadeTips : function(otherid) {
		clearTimeout(this.timer);
		var mdiv = otherid ? this.$(otherid) : this.$(this.showMessageId);
		this.timer = setTimeout(function() {
			mdiv.style.display = 'none';
		}, 3000);
	},

	/* ajax get */
	get : function(url, data, id) {
		sendmsg(url, data, id);
	},

	/* show dialog */
	tips : function(type, message, autohide, callback) {
		showDialog(type, message, autohide, callback);
	},

	/* check All */
	CheckAll : function(name, self) {
		var ischeck = self.checked;
		var otherInputs = document.getElementsByName(name);
		var l = otherInputs.length;
		for ( var i = 0; i < l; i++)
			otherInputs[i].checked = ischeck;
	},

	/* 显示隐藏管理面板 */
	showManagePane : function(ifshow, pid) {
		var mObj = getObj(pid);
		if (!mObj)
			return false;
		if (ifshow == '0' || ifshow == false || ifshow == '' || ifshow == null
				|| ifshow == 'undefined') {
			mObj.style.display = 'none';
		} else {
			mObj.style.display = '';
		}
	},

	/* 改变店铺组权限状态 */
	chengeDianpuGroups : function(value) {
		if (!value) {
			DP.tips('error', '请选择店铺组！');
			return false;
		}
		var url = DP.baseUrl + value;
		DP.post(url, '', function() {
			if (ajax.request.responseText == null)
				DP.tips('error', '请选择店铺组！');
			var groupinfo = JSONParse(ajax.request.responseText);
			DP.showManagePane(groupinfo['configinfo']['qq'], 'dianpu_qq');
			DP.showManagePane(groupinfo['configinfo']['wangwang'],
					'dianpu_wangwang');
			DP.showManagePane(groupinfo['configinfo']['uploadlogo'],
					'dianpu_logo');
		});
	},

	/* 注册店铺组事件 */
	setDianpuGroupsEvent : function() {
		var gObj = getObj('dianpu_groups');
		if (!gObj)
			return false;
		gObj.onchange = function() {
			DP.chengeDianpuGroups(this.value)
		};
	},

	isClicked : function(form) {
		var clicks = form.getElementsByTagName('input');
		for ( var i = 0; i < clicks.length; i++) {
			if (clicks[i].type == "checkbox" && clicks[i].checked == true) {
				return true;
			}
		}
		return false;
	},

	unClick : function(form) {
		var clicks = form.getElementsByTagName('input');
		for ( var i = 0; i < clicks.length; i++) {
			if (clicks[i].type == "checkbox") {
				clicks[i].checked = false;
			}
		}
	}
};

var VALIDATOR = {
	message : "",
	result : true,

	init : function(form) {
		this.result = true;
		this._hideError(form);
	},

	init_2 : function(form, vid) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		this.result = true;
		var errorObjs = obj.parentNode.getElementsByTagName('span');
		for ( var i = 0; i < errorObjs.length; i++) {
			if (errorObjs[i].className == "wrongTip") {
				errorObjs[i].parentNode.removeChild(errorObjs[i]);
			}
		}
	},

	uploadsize : function(/* input id */vid, /* input title */showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		var maxUploadSize = 2000000;
		var path = obj.value.Trim();
		var filesize = 0;
		if (obj.files) {
			if (obj.files[0])
				filesize = obj.files[0].fileSize;
		} else if (window.navigator.userAgent.indexOf("MSIE 6") > 0
				&& !window.XMLHttpRequest) {
			var img = new Image();
			img.dynsrc = path;
			filesize = img.fileSize;
		}
		if (filesize && filesize > maxUploadSize) {
			this.message = '\'' + obj.title + '\'大小不能超过2000kb';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	isRequired : function(/* input id */vid, /* input title */showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		obj.value = obj.value.Trim();
		if (obj.value == null || obj.value == '' || obj.value == 'undefined') {
			this.message = '请填写\'' + obj.title + '\'后再提交';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	/* 匹配任意的字母（除换行回车之外） */
	isLetter : function(/* input id */vid, /* input title */showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		var patrn = new RegExp('^(.)+$');
		if (obj.value != '' && !patrn.exec(obj.value)) {
			this.message = '请填写正确的\'' + obj.title + '\'后再提交, 只允许输入字母/数字/汉字！';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	/* 匹配价格 */
	isPrice : function(/* input id */vid, /* input title */showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		var patrn = new RegExp('^[1-9]{1}[0-9]{0,10}(\.[0-9]+)*$');
		if (obj.value != '' && !patrn.exec(obj.value)) {
			this.message = '请填写正确的\'' + obj.title + '\'后再提交';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	/* 匹配长度（字节为单位） */
	isLength : function(/* input id */vid, /* min */min, /* max */max,
			showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		var byteLength = getByteLength(obj.value);
		if (obj.value != '' && (byteLength < min || byteLength > max)) {
			this.message = '请填写正确的\'' + obj.title + '\'后再提交,(' + min + '~'
					+ max + '个字节)';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	/* 是否是数字串只允许0-9 */
	isInt : function(/* input id */vid, /* input title */showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		var patrn = new RegExp('^[0-9]+$');
		if (obj.value != '' && !patrn.exec(obj.value)) {
			this.message = '请填写正确的\'' + obj.title + '\'后再提交,只能输入数字！';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	/* 校验手机 （含有数字和 + 号和-号 ） */
	isPhone : function(/* input id */vid, /* input title */showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		var patrn = /^[\d\+\-]+$/;
		if (obj.value != '' && !patrn.test(obj.value)) {
			this.message = '请填写正确的\'' + obj.title + '\'后再提交，只能输入数字/符号(+、-)！';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	/* checked是否被选择 */
	isCheck : function(/* input id */vid, /* input title */showTip) {
		var obj = getObj(vid);
		if (!obj)
			return false;
		if (!obj.checked) {
			this.message = '请先\'' + obj.title + '\'后再提交';
			this._showError(obj, showTip);
			return true;
		}
		return false;
	},

	_hideError : function(form) {
		var errorObjs = form.getElementsByTagName('span');
		for ( var i = 0; i < errorObjs.length; i++) {
			if (errorObjs[i].className == "wrongTip") {
				errorObjs[i].parentNode.removeChild(errorObjs[i]);
			}
		}
	},

	_showError : function(obj, showTip) {
		this.result = false;
		if (!obj)
			return false;
		if (showTip) {
			DP.tips('error', this.message);
		} else {
			this._errorTips(obj);
		}
	},

	_errorTips : function(obj) {
		var errorObjs = obj.parentNode.getElementsByTagName('span');
		for ( var i = 0; i < errorObjs.length; i++) {
			if (errorObjs[i].className == "wrongTip")
				return false;
		}
		var error = document.createElement('span');
		error.className = "wrongTip";
		error.style.padding = "3px 10px 3px 24px";
		error.id = obj.id + "_wrongTip";
		error.innerHTML = this.message;
		if (obj) {
			obj.style.marginRight = "2px";
			obj.parentNode.appendChild(error);
			// obj.focus();
		}
	}
};

String.prototype.Trim = function() {
	return this.replace(/(^\s*)|(\s*$)/g, "");
}

/* 获得输入的参数字符串的字节长度 */
function getByteLength(str) {
	var i, sum;
	sum = 0;
	for (i = 0; i < str.length; i++) {
		if ((str.charCodeAt(i) >= 0) && (str.charCodeAt(i) <= 255)) {
			sum = sum + 1;
		} else {
			sum = sum + 2;
		}
	}
	return sum;
}

/* 判断是否安装了QQ软件 */
function checkQQInstall(qq) {
	var url = "http://wpa.qq.com/msgrd?v=3&uin=" + qq
			+ "&site=PHPWIND&menu=yes";
	var link = "http://im.qq.com/";
	try {
		if (window.ActiveXObject) { // IE 版本
			var xmlhttp = new ActiveXObject("TimwpDll.TimwpCheck");
			var n = xmlhttp.GetVersion();
			if (n >= 2.1) {
				window.targer = "_blank";
				window.open(url);
			} else {// 没有安装QQ
				showDialog('confirm',
						"友情提示：<br/>您的机子没有安装QQ或者QQ版本过低，请下载或跟新为更高版本！", 5,
						function() {
							window.target = "_blank";
							window.open(link);
						});
			}
		} else {
			window.targer = "_blank";
			window.open(url);
		}
	} catch (e) {
		showDialog('confirm',
				"友情提示：<br/>请您访问http://im.qq.com/下载新版的QQ/TM以支持与店主在线交流！", 5,
				function() {
					window.target = "_top";
					window.open(link);
				});
	}
}
