/*
 @ TableName: 店铺商家表 pw_dianpu_shangjia
 @ Created By wuq@2010-08-23
 @ Engine: MyISAM（可选）
 @ Primary Key:shangjiaid
 @ Fields: shangjiaid 主键ID
 @ Fields: uid 店主ID
 @ Fields: username 店主
 @ Fields: company 公司名称
 @ Fields: delegate 法人代表名称
 @ Fields：delegatephone 法人代表联系电话
 @ Fields: companyaddress 公司地址
 @ Fields：companyphone 公司电话
 @ Fields：companyfax 公司传真
 @ Fields：companyzipcode 公司邮编地址
 @ Fields：createtime 创建时间 
 * */
DROP TABLE IF EXISTS `pw_dianpu_shangjia`;
CREATE TABLE `pw_dianpu_shangjia` (
	`shangjiaid` mediumint(8) unsigned NOT NULL auto_increment,
	`uid` int (10) unsigned NOT NULL default 0,
	`username` varchar (15) NOT NULL default '',
	`company` varchar (100) NOT NULL default '',
	`delegate` varchar (15) NOT NULL default '',
	`delegatephone` varchar (30) NOT NULL default '',
	`companyaddress` varchar (100) NOT NULL default '',
	`companyphone` varchar (30) NOT NULL default '',
	`companyfax` varchar (30) NOT NULL default '',
	`companyzipcode` varchar (10) NOT NULL default '0',
	`createtime` int (10) NOT NULL default 0,
	PRIMARY KEY (`shangjiaid`)
)ENGINE = MYISAM; 

/*
 @ TableName: 店铺表 pw_dianpu_dianpubase
 @ Created By wuq@2010-08-23
 @ Engine: MyISAM
 @ Primary Key: dianpuid
 @ Fields：dianpuid 主键ID
 @ Fields：shangjiaid 商家外键
 @ Fields：title 店铺名称
 @ Fields: state 店铺状态
 @ Fields：ifcheck 是否经过验证
 @ Fields：checkway 验证方式
 @ Fields: checktime 验证时间
 @ Fields：address 店铺地址
 @ Fields: qq QQ号码
 @ Fields: msn MSN号码
 @ Fields: wangwang 旺旺号
 @ Fields: email email地址
 @ Fields：phone 店铺电话
 @ Fields：map_x 店铺地图X坐标
 @ Fields：map_y 店铺地图Y坐标
 @ Fields：map_z 店铺地图缩放级别
 @ Fields：logo 店铺LOGO
 @ Fields：bulletin 店铺公告信息
 @ Fields: recommendlevel 店铺推荐级别
 @ Fields: ifattach 是否有附件
 @ Fields：createtime 店铺创建时间
 @ Fields：modifytime 店铺修改时间
 @ Fields：overtime 店铺过期时间
 @ Index: idx_state  状态索引
 @ Index: idx_createtime 创建时间索引
 @ Index: idx_modifytime 修改时间索引
 * */
DROP TABLE IF EXISTS `pw_dianpu_dianpubase`;
CREATE TABLE `pw_dianpu_dianpubase` (
	`dianpuid` int (10) unsigned NOT NULL auto_increment,
	`shangjiaid` mediumint (8) unsigned NOT NULL default 0,
	`title` varchar (30) NOT NULL default '',
	`state` tinyint (3) NOT NULL default 0,
	`ifcheck` tinyint (3) unsigned NOT NULL default 0,
	`checkway` varchar (30) NOT NULL default '',
	`checktime` int (10) NOT NULL default 0,
	`address` varchar (255) NOT NULL default '',
	`qq` varchar (20) NOT NULL default '',
	`msn` varchar (100) NOT NULL default '',
	`wangwang` varchar (100) NOT NULL default '',
	`email` varchar (100) NOT NULL default '',
	`phone`	varchar (20) NOT NULL default '',
	`map_x` varchar (20) NOT NULL default '',
	`map_y` varchar (20) NOT NULL default '',
	`map_z` tinyint (1) NOT NULL default 13,
	`logo` varchar (255) NOT NULL default '',
	`bulletin` text NOT NULL,
	`recommendlevel` tinyint (3) NOT NULL default 0,
	`ifattach` tinyint (3) NOT NULL default 0,
	`createtime` int (11) NOT NULL default 0,
	`modifytime` int (11) NOT NULL default 0,
	`overtime` int (11) NOT NULL default 0,
	PRIMARY KEY (`dianpuid`),
	INDEX `idx_state` (`state`),
	INDEX `idx_createtime` (`createtime`),
	INDEX `idx_modifytime` (`modifytime`)
)ENGINE = MYISAM;

/*
 @ TableName: 店铺扩展信息表  pw_dianpu_dianpuextend
 @ Created By wuq@2010-08-23
 @ Engine: MyISAM 
 @ Fields: dianpuid 店铺ID
 @ Fields: uid 店主ID
 @ Fields: username 店主名字
 @ Fields: url 店铺网址
 @ Fields: areaid 地区ID
 @ Fields: categoryid 分类ID
 @ Fields: operator 经营者
 @ Fields: operatorphone 经营者电话
 @ Fields: groupid 店铺组ID
 @ Fields: businfo 店铺公交信息
 @ Fields: tempstyle 店铺风格
 @ Fields: contentorder 店铺说明分页
 @ index: idx_dianpuid 店铺ID
 * */
DROP TABLE IF EXISTS `pw_dianpu_dianpuextend`;
CREATE TABLE `pw_dianpu_dianpuextend`(
	`dianpuid` int (10) unsigned NOT NULL DEFAULT 0,
	`uid` int (10) unsigned NOT NULL DEFAULT 0,
	`username` varchar (15) NOT NULL DEFAULT '',
	`url` varchar (255) NOT NULL DEFAULT '',
	`areaid` mediumint (8) unsigned NOT NULL DEFAULT 0,
	`categoryid` smallint (6) unsigned NOT NULL DEFAULT 0,
	`operator` varchar (15) NOT NULL DEFAULT '',
	`operatorphone` varchar (20) NOT NULL DEFAULT 0,
	`groupid` tinyint (3) unsigned NOT NULL DEFAULT 0,
	`businfo` varchar (255) NOT NULL DEFAULT '',
	`tempstyle` varchar (10) NOT NULL DEFAULT '',
	`contentorder` text NOT NULL,
	KEY idx_dianpuid (`dianpuid`)
)ENGINE = MYISAM;

/*
 @ TableName: 店铺索引表  pw_dianpu_dianpuindex
 @ Created By wuq@2010-08-23
 @ Engine: MyISAM
 @ Fields: dianpuid 店铺ID
 @ Fields: title 店铺名称
 @ Fields: state 店铺状态(0,关闭，1开启）
 @ Fields: areaid 店铺地区ID
 @ Fields: categoryid 店铺分类ID
 @ Fields: parentid 店铺行业ID
 @ Fields: groupid 店铺组ID
 @ Fields：ifcheck 是否认证
 @ Fields：checkway 认证方式
 @ Fields：recommendlevel 推荐级别（0，1，2，3，4）0为未推荐
 @ Fields：modifytime 店铺修改时间
 @ Fields：hit 点击率
 @ Index: idx_dianpuid 店铺ID
 @ Index: idx_normal_areaid  地区及推荐级别查询
 @ Index: idx_normal_parentid 行业及地区及推荐级别查询
 @ Index: idx_normal_categoryid 分类及地区及推荐级别查询
 * */
DROP TABLE IF EXISTS `pw_dianpu_dianpuindex`;
CREATE TABLE `pw_dianpu_dianpuindex`(
	`dianpuid` int (10) unsigned NOT NULL,
	`title` varchar (30) NOT NULL default '',
	`state` tinyint (3) NOT NULL default 0,
	`areaid` mediumint (8) unsigned NOT NULL default 0,
	`categoryid` int (10) unsigned NOT NULL default 0,
	`parentid` int (10) unsigned NOT NULL default 0,
	`groupid` smallint (6) unsigned NOT NULL default 0,
	`ifcheck` tinyint (3) unsigned NOT NULL default 0,
	`checkway` varchar (30) NOT NULL default '',
	`recommendlevel` tinyint (3) NOT NULL default 0,
	`modifytime` int (11) NOT NULL default 0,
	`hit` int (10) NOT NULL default 0,
	KEY idx_dianpuid (`dianpuid`),
	KEY idx_normal_categoryid (categoryid,areaid,recommendlevel),
	KEY idx_normal_parentid (parentid,areaid,recommendlevel),
	KEY idx_normal_areaid (areaid,recommendlevel)
)ENGINE = MYISAM;

/*
 @ TableName: 店铺说明信息表  pw_dianpu_dianpucontent
 @ Created By wuq@2010-08-23
 @ Engine: MyISAM
 @ Primary Key: contentid
 @ Fields：contentid 主键PK
 @ Fields：dianpuid 店铺ID外键
 @ Fields：sort 店铺内容排序号
 @ Fields：titles 店铺说明标题
 @ Fields：contents 店铺说明内容 
 @ Index: idx_dianpuid_sort 店铺排序字段排序
 * */
DROP TABLE IF EXISTS `pw_dianpu_dianpucontent`;
CREATE TABLE `pw_dianpu_dianpucontent`(
	`contentid` int (11) unsigned NOT NULL AUTO_INCREMENT,
	`dianpuid` int (10) unsigned NOT NULL DEFAULT 0,
	`sort` tinyint (3) unsigned NOT NULL DEFAULT 0,
	`titles` text NOT NULL,
	`contents` text NOT NULL,
	PRIMARY KEY (`contentid`),
	INDEX `idx_dianpuid_sort` (`dianpuid`)
)ENGINE = MYISAM;

/*
 @ TableName: 店铺组表  pw_dianpu_groups
 @ Created By wuq@2010-08-23
 @ Engine: MyISAM
 @ Primary Key: groupid
 @ Fields：groupid 店铺组主键OK
 @ Fields：title 店铺组标题
 @ Fields：state 店铺组状态
 @ Fields: styles 店铺组的风格
 @ Fields：createtime 创建时间 
 @ Fields：configinfo 店铺组配置信息
 * */
DROP TABLE IF EXISTS `pw_dianpu_groups`;
CREATE TABLE `pw_dianpu_groups`(
	`groupid` tinyint (3) unsigned NOT NULL auto_increment,
	`title` varchar (50) NOT NULL default '',
	`state` tinyint (3) NOT NULL default 0,
	`styles` text NOT NULL,
	`createtime` int (10) NOT NULL default 0,
	`configinfo` text NOT NULL,
	PRIMARY KEY (`groupid`)
)ENGINE = MYISAM;

REPLACE INTO pw_dianpu_groups (`groupid`,`title`,`state`,`styles`,`createtime`,`configinfo`) VALUES 
('1','普通','1','a:1:{i:0;s:1:"1";}',UNIX_TIMESTAMP(),'a:8:{s:10:"uploadlogo";s:1:"0";s:8:"comments";s:1:"0";s:10:"dianpushow";s:1:"0";s:11:"productshow";s:1:"0";s:8:"wangwang";s:1:"0";s:2:"qq";s:1:"0";s:10:"maxproduct";s:2:"10";s:10:"maxexplain";s:1:"1";}'),
('2','VIP','1','a:2:{i:0;s:1:"1";i:1;s:1:"2";}',UNIX_TIMESTAMP(),'a:8:{s:10:"uploadlogo";s:1:"1";s:8:"comments";s:1:"1";s:10:"dianpushow";s:1:"1";s:11:"productshow";s:1:"1";s:8:"wangwang";s:1:"1";s:2:"qq";s:1:"1";s:10:"maxproduct";s:2:"50";s:10:"maxexplain";s:1:"5";}');

/*
 @ TableName: 店铺推荐  pw_dianpu_recommends
 @ Created By wuq@2010-08-23
 @ Engine: MyISAM
 @ Primary Key: recommendid
 @ Fields：recommendid 店铺组主键OK
 @ Fields：objid 类型ID
 @ Fields: objtype 推荐类型（0 店铺推荐；1 商品推荐）
 @ Fields：createtime 店铺创建时间
 @ Fields：levels 创建推荐级别 
 @ Fields：overtime 店铺超时时间
 @ Index: idx_dianpuid_level 店铺的级别
 * */
DROP TABLE IF EXISTS `pw_dianpu_recommends`;
CREATE TABLE `pw_dianpu_recommends`(
	`recommendid` int (10) unsigned NOT NULL auto_increment,
	`objid` int (10) unsigned NOT NULL default 0,
	`objtype` tinyint (3) unsigned NOT NULL default 0,
	`createtime` int (11) NOT NULL default 0,
	`levels` tinyint (3) NOT NULL default 0,
	`overtime` int (11) NOT NULL default 0,
	PRIMARY KEY (`recommendid`),
	KEY `idx_dianpuid_level` (objid, levels)
)ENGINE = MYISAM;


/**
@TableName:用户评论内容表 pw_dianpu_commentcontents
@Created by xiaoxia.xu@2010-08-24
@Engine:MyISAM
@Primary Key: commentid
@Fields commentid 主键id 
@Fields title 评论标题
@Fields content 评论内容
@Fields objectid 店铺ID
@Fields typeid 评论的ID (如果是店铺评论，则为0，如果是商品评论则选自商品ID)
@Fields uid 发表评论的用户ID
@Fields username 发表评论的用户名字
@Fields postdate 发表评论的日期时间戳
@Fields isanswer 记录该条评论的状态，如果是0,为用户评论，如果是1则是店长回复
@Fields state 记录该条评论是否已被回复，为0则没有被回复，为1则为已回复
@Index idx_objectid_postdate 根级店铺下评论时间
**/
DROP TABLE IF EXISTS `pw_dianpu_commentcontents`;
CREATE TABLE `pw_dianpu_commentcontents` (
	`commentid` int(10) unsigned NOT NULL auto_increment,
	`title` varchar(50) NOT NULL default '',
	`content` text NOT NULL,
	`objectid` int(10) UNSIGNED NOT NULL default 0,
	`typeid` int(10) UNSIGNED NOT NULL default 0,
	`uid` int(10) UNSIGNED NOT NULL default 0,
	`username` varchar(15) NOT NULL default '',
	`postdate` int(10) UNSIGNED NOT NULL default 0,
	`state` tinyint(3) NOT NULL default 0,
	`isanswer` tinyint(3) NOT NULL default 0,
	PRIMARY KEY ( `commentid` ),
	KEY `idx_objectid_postdate` (`objectid`,`postdate`)
)ENGINE = MYISAM;


/**
@TableName : 用户评论基本查询表（保存所有一级的评论查询数据）pw_dianpu_comments
@Created by xiaoxia.xu@2010-08-24
@Engine:MyISAM
@Fields commentdid  评论表中的ID
@Fields objectid 店铺ID
@Fields typeid 评论的ID (如果是店铺评论，则为0，如果是商品评论则选自商品ID)
@Fields postdate 评论递交的时间
@Index: idx_objectid_postdate 店铺下的评论按照递交时间
@Index: idx_commentid 评论ID
**/
DROP TABLE IF EXISTS `pw_dianpu_comments`;
CREATE TABLE `pw_dianpu_comments` (
	`commentid` int(10) UNSIGNED NOT NULL default 0,
	`objectid` int(10) UNSIGNED NOT NULL default 0,
	`typeid` int(10) UNSIGNED NOT NULL default 0,
	`postdate` int(10) UNSIGNED NOT NULL default 0,
	KEY `idx_commentid` (`commentid`),
	KEY `idx_objectid_postdate` (`objectid`,`postdate`)
)ENGINE=MYISAM;

/**
@TableName 用户评论查询信息表（保存所有用户的二级以上的评论及店主的回复）pw_dianpu_commentreplys
@Created by xiaoxia.xu@2010-08-24
@Engine:MyISAM
@Fields commentid 评论的ID
@Fields parentid 父类评论的ID
@Fields rootid 根级评论ID
@Fields objectid 店铺ID
@Fields postdate 评论时间
@Index idx_rootid_postdate 根级评论的提交时间排序
@Index idx_parentid_postdate 父级评论的递交时间排序
**/
DROP TABLE IF EXISTS `pw_dianpu_commentreplys`;
CREATE TABLE `pw_dianpu_commentreplys` (
	`commentid` int(10) UNSIGNED NOT NULL default 0,
	`parentid` int(10) UNSIGNED NOT NULL default 0,
	`rootid` int(10) UNSIGNED NOT NULL default 0,
	`objectid` int(10) UNSIGNED NOT NULL default 0,
	`postdate` int(10) UNSIGNED NOT NULL default 0,
	KEY `idx_parentid_postdate` (`parentid`,`postdate`),
	KEY `idx_rootid_postdate` (`rootid`,`postdate`)
)ENGINE=MYISAM;

/*
@TableName:商家导航商品表 pw_dianpu_products
@Created By zhangjuzheng@2010-6-23
@Engine:MyISAM
@Primary Key:productid
@Fields productid 主键ID
@Fields objectid 店铺ID
@Fields title 商品名称
@Fields description 商品描述
@Fields recommend 是否推荐
@Fields market_price 市场价
@Fields member_price 会员价
@Fields shelf 是否上/下架
@Fields photoid 默认图片
@Fields createdtime 创建时间
@Fields modifiedtime 更新时间
@Fields hits 店铺点击率
@Index:idx_objectid_createdtime  根椐店铺与创建时间排序商品 
*/
DROP TABLE IF EXISTS `pw_dianpu_products`;
CREATE TABLE `pw_dianpu_products`(
	`productid` int(10) unsigned NOT NULL auto_increment,
	`objectid` int(10) unsigned NOT NULL default 0,
	`title` varchar(255) NOT NULL default '',
	`description` text NOT NULL,
	`recommend` tinyint(3) NOT NULL default 0,
	`market_price` varchar(30) NOT NULL default '',
	`member_price` varchar(30) NOT NULL default '',
	`shelf` tinyint(3) NOT NULL default 0,
	`photoid` int(10) unsigned NOT NULL default 0,
	`createdtime` int(10) NOT NULL default 0,
	`modifiedtime` int(10) NOT NULL default 0,
	`hits` int(10) NOT NULL default 0,
	PRIMARY KEY (`productid`),
	KEY `idx_objectid_createdtime` (`objectid`,`createdtime`)
)ENGINE=MYISAM;

/*
@TableName:商家导航图片表 pw_dianpu_photos
@Created By zhangjuzheng@2010-6-23
@Engine:MyISAM
@Primary Key:photoid
@Fields photoid 主键ID
@Fields objectid 对象ID(如:商品)
@Fields belongid 所属ID(如:店铺)
@Fields typeid 图片类型
@Fields filename 图片名称
@Fields path 图片路径
@Fields createdtime 创建时间
@Index:idx_typeid_objectid_createdtime  根椐图片类型与元素ID获取图片 
*/
DROP TABLE IF EXISTS `pw_dianpu_photos`;
CREATE TABLE `pw_dianpu_photos`(
	`photoid` int(10) unsigned NOT NULL auto_increment,
	`objectid` int(10) NOT NULL default 0,
	`belongid` int(10) NOT NULL default 0,
	`typeid` tinyint(3) NOT NULL default 0,
	`filename` varchar(100) NOT NULL default '',
	`path` varchar(255) NOT NULL default '',
	`createdtime` int(10) NOT NULL default 0,
	PRIMARY KEY (`photoid`),
	KEY `idx_typeid_objectid_createdtime` (`typeid`,`objectid`,`createdtime`)
)ENGINE=MYISAM;

/*
@TableName:店铺行业分类表 pw_dianpu_categorys
@Created By zhangjuzheng@2010-6-23
@Engine:MyISAM
@Primary Key:categoryid
@Fields categoryid 主键ID
@Fields parentid 父分类ID
@Fields name 分类名称
@Fields sort 排序
@Fields createdtime 创建时间
@Index:idx_parentid_sort  根椐父对象ID获取分类并按自定义排序
*/
DROP TABLE IF EXISTS `pw_dianpu_categories`;
CREATE TABLE `pw_dianpu_categories`(
	`categoryid` int(10) unsigned NOT NULL auto_increment,
	`parentid` int(10) unsigned NOT NULL default 0,
	`name` varchar(20) NOT NULL default '',
	`sort` tinyint(3) NOT NULL default 0,
	`createdtime` int(10) NOT NULL default 0,
	PRIMARY KEY (`categoryid`),
	KEY `idx_parentid_sort` (`parentid`,`sort`)
)ENGINE=MYISAM;
/*
@插入默认数据
*/
REPLACE INTO pw_dianpu_categories (`categoryid`, `name`,`createdtime`) VALUES 
('1','休闲娱乐', UNIX_TIMESTAMP()),
('2','餐饮美食', UNIX_TIMESTAMP()),
('3','旅游酒店', UNIX_TIMESTAMP()),
('4','便民服务', UNIX_TIMESTAMP()),
('5','美容保健', UNIX_TIMESTAMP()),
('6','装修公司', UNIX_TIMESTAMP()),
('7','购物服务', UNIX_TIMESTAMP()),
('8','咨询中介', UNIX_TIMESTAMP()),
('9','房产家居', UNIX_TIMESTAMP()),
('10','教育培训', UNIX_TIMESTAMP()),
('11','交通物流', UNIX_TIMESTAMP()),
('12','车辆服务', UNIX_TIMESTAMP());
REPLACE INTO pw_dianpu_categories (`categoryid`, `parentid`, `name`, `createdtime`) VALUES 
('13', '1', '酒吧', UNIX_TIMESTAMP()),
('14', '2', '中餐馆', UNIX_TIMESTAMP()),
('15', '3', '旅行社', UNIX_TIMESTAMP()),
('16', '4', '搬家', UNIX_TIMESTAMP()),
('17', '5', '美发', UNIX_TIMESTAMP()),
('18', '6', '现代风格', UNIX_TIMESTAMP()),
('19', '7', '通讯数码', UNIX_TIMESTAMP()),
('20', '8', '婚介', UNIX_TIMESTAMP()),
('21', '9', '房产经纪', UNIX_TIMESTAMP()),
('22', '10', '学前教育', UNIX_TIMESTAMP()),
('23', '11', '快递', UNIX_TIMESTAMP()),
('24', '12', '租车', UNIX_TIMESTAMP());

/*
@TableName:商家导航地区表 pw_dianpu_areas
@Created By zhangjuzheng@2010-6-23
@Engine:MyISAM
@Primary Key:areaid
@Fields areaid 主键ID
@Fields name 地区名称ID
@Fields sort 排序
@Fields createdtime 创建时间
@Index:idx_sort  根椐排序获取
*/
DROP TABLE IF EXISTS `pw_dianpu_areas`;
CREATE TABLE `pw_dianpu_areas`(
	`areaid` int(10) unsigned NOT NULL auto_increment,
	`name` varchar(20) NOT NULL default '',
	`sort` tinyint(3) NOT NULL default 0,
	`createdtime` int(10) NOT NULL default 0,
	PRIMARY KEY (`areaid`),
	KEY `idx_sort` (`sort`)
)ENGINE=MYISAM;

/*
@插入默认数据
*/
REPLACE INTO pw_dianpu_areas (`areaid`, `name`,`createdtime`) VALUES 
('1','西湖区', UNIX_TIMESTAMP()),
('2','下城区', UNIX_TIMESTAMP()),
('3','萧山区', UNIX_TIMESTAMP()),
('4','江干区', UNIX_TIMESTAMP()),
('5','上城区', UNIX_TIMESTAMP()),
('6','拱墅区', UNIX_TIMESTAMP()),
('7','余杭区', UNIX_TIMESTAMP()),
('8','滨江区', UNIX_TIMESTAMP());

/*
@TableName:商家导航风格表 pw_dianpu_styles
@Created By zhangjuzheng@2010-9-1
@Engine:MyISAM
@Primary Key:styleid
@Fields styleid 主键ID
@Fields title 风格自定义名称
@Fields filename 风格文件
@Fields status 风格状态
@Fields createdtime 创建时间
@Index:idx_filename  根椐排序获取
*/
DROP TABLE IF EXISTS `pw_dianpu_styles`;
CREATE TABLE `pw_dianpu_styles`(
	`styleid` smallint(6) unsigned NOT NULL auto_increment,
	`title` varchar(10) NOT NULL default '',
	`filename` varchar(10) NOT NULL default '',
	`status` tinyint(3) NOT NULL default 0,
	`createdtime` int(10) NOT NULL default 0,
	PRIMARY KEY (`styleid`),
	KEY `idx_filename` (`filename`)
)ENGINE=MYISAM;

/*
@TableName:商家导航产品点击统计表 pw_dianpu_producthits
@Created By zhangjuzheng@2010-9-8
@Engine:MyISAM
@Primary Key:id
@Fields id 主键ID
@Fields hits 点击次数
@Index idx_hits 根据点击率
*/
DROP TABLE IF EXISTS `pw_dianpu_producthits`;
CREATE TABLE `pw_dianpu_producthits`(
	`id` int(10) unsigned NOT NULL ,
	`hits` int(10) NOT NULL default 0,
	PRIMARY KEY (`id`),
	KEY `idx_hits` (`hits`)
)ENGINE=MYISAM;

/*
@TableName:商家导航产品点击统计表 pw_dianpu_dianpuhits
@Created By wuq@2010-9-25
@Engine:MyISAM
@Primary Key:id
@Fields id 主键ID
@Fields hits 点击次数
@Index idx_hits 根据点击率
*/
DROP TABLE IF EXISTS `pw_dianpu_dianpuhits`;
CREATE TABLE `pw_dianpu_dianpuhits`(
	`id` int(10) unsigned NOT NULL ,
	`hits` int(10) NOT NULL default 0,
	PRIMARY KEY (`id`),
	KEY `idx_hits` (`hits`)
)ENGINE=MYISAM;

/**
 * 商家导航站点设置
 */
REPLACE INTO pw_hack (`hk_name`, `vtype`, `hk_value`,`decrip`)
VALUES ('dianpu_cancomment','string','1','是否能发表评论'),
('dianpu_listnum','string',15,'前太列表默认显示的数量'),
('dianpu_mapcity','string','杭州','地域设置'),
('dianpu_mapkey','string','','MAPABC KEY 设置'),
('dianpu_starremark','string','0','是否开启星级点评'),
('dianpu_recommendLevel','array','a:3:{i:3;s:4:"三钻";i:4;s:4:"四钻";i:5;s:4:"五钻";}','推荐默认数据'),
('dianpu_sitename','string','商家导航','导航名字'),
('dianpu_checkway','array','a:3:{s:6:"mobile";s:8:"电话认证";s:6:"verify";s:8:"工商认证";s:3:"vip";s:3:"VIP";}','认证默认类型');


/**
 * 插入新的广告位
*/
/*
 * @商家导航
 */
INSERT INTO `pw_advert` (`type`, `uid`, `ckey`, `stime`, `etime`, `ifshow`, `orderby`, `descrip`, `config`) VALUES 
(0, 0, 'Mode.Dianpu.Index.Header', 0, 0, 1, 0, '商家导航首页头部广告位~	~商家导航首页头部广告位', 'a:1:{s:7:"display";s:4:"rand";}'),
(0, 0, 'Mode.Dianpu.Index.Right1', 0, 0, 1, 0, '商家导航首页右1~	~商家导航首页右1', 'a:1:{s:7:"display";s:4:"rand";}'),
(0, 0, 'Mode.Dianpu.Index.Right2', 0, 0, 1, 0, '商家导航首页右2~	~商家导航首页右边上面开始第2个', 'a:1:{s:7:"display";s:4:"rand";}'),
(0, 0, 'Mode.Dianpu.Index.Center1', 0, 0, 1, 0, '商家导航首页中1~ ~商家导航首页中间的广告位', 'a:1:{s:7:"display";s:4:"rand";}'),
(0, 0, 'Mode.Dianpu.List.Right1', 0, 0, 1, 0, '商家导航列表页右边下角~	~商家导航列表页右边下角处的广告', 'a:1:{s:7:"display";s:4:"rand";}'),
(0, 0, 'Mode.Dianpu.Proinfo.Right1', 0, 0, 1, 0, '商家导航商品内容页右下角~	~商家导航商品内容页右下角', 'a:1:{s:7:"display";s:4:"rand";}'),
(0, 0, 'Mode.Dianpu.Info.Right1', 0, 0, 1, 0, '商家导航店铺内容页右下角~	~商家导航店铺信息内容页右下角', 'a:1:{s:7:"display";s:4:"rand";}');
