<?php
/**
 * 基础字段验证方法
 * @author papa0924@gmail.com
 * 2010-09-22
 */
class BaseModule {
	var $_error = false;
	var $_message = array();
	
	/**
	 * 格式化商品的价格
	 * 用四舍五入的方式，保留两位有效数字
	 * @access private
	 * @param string $field 需要格式化的值
	 * @return float float(0.00) 
	 */
	function _formatPrice($field) {
		$field = floatval($field);
		$_p = (strpos($field, '.') === false) ? 0 : 2;
		return number_format($field, $_p, '.', ' ');
	}
	
	/**
	 * 验证过期时间是否正确
	 * @access private
	 * @param string $field 需要验证的值
	 * @param string $message 出错的时候显示的信息
	 * @return void 
	 */
	function _validateOvertime($field, $message) {
		global $timestamp;
		$message = $message ? $message : '过期时间不能小于当前时间';
		if ($field <= $timestamp) $this->_addError($message);
	}
	
	/**
	 * 过滤一系列动作及实现
	 * @access private
	 * @param string $content  需要过滤的值
	 * @return string  返回过滤后的值
	 */
	function _filterConvert($content) {
		$_filterUitil = L::loadClass('FilterUtil', 'filter');
		/* @var $_filterUitil PW_FilterUtil */
		return $_filterUitil->convert($content);
	}
	
	/**
	 * 验证输入字段信息中是否包含敏感词
	 * @access private
	 * @param string $field  需要验证的值
	 * @param string $message   验证出错显示的信息
	 * @return void 
	 */
	function _filterWordsfb($field, $message = '内容中') {
		$_wordsfb = L::loadClass('FilterUtil', 'filter');
		/* @var $_wordsfb PW_FilterUtil */
		if (($banword = $_wordsfb->comprise($field, false)) !== false) $this->_addError('警告：“' . $message . '”中含有非法词语 \'<font color=red>' . $banword . '</font>\'！');
	}
	
	/**
	 * 验证字段是不是只包含英文或者数字
	 * @access private
	 * @param string $field  需要验证的值
	 * @param string $message  验证出错显示的信息
	 * @return void 
	 */
	function _validationIntAndLetter($field, $message = '') {
		if (!preg_match('/^[a-zA-Z0-9]+$/', $field)) $this->_addError($message);
	}
	
	/**
	 * 验证字段是不是整型
	 * @access private
	 * @param string $field  需要验证的值
	 * @param string $message 验证出错显示的信息
	 * @return void 
	 */
	function _validationFieldInt($field, $message = '') {
		if (!is_numeric($field)) $this->_addError($message);
	}
	
	/**
	 * 验证字段是否是正确的email格式
	 * @access private
	 * @param string $field  需要验证的值
	 * @param string $message 验证出错显示的信息
	 * @return void 
	 */
	function _validationFieldEmail($field, $message = '') {
		$validator = L::loadClass('validator', 'utility/validate');
		/* @var $validator PW_Validator */
		if (!$validator->validate($field, 'email')) $this->_addError($message);
	}
	
	/**
	 * 验证字段不能为空
	 * @access private
	 * @param string $field  需要验证的值
	 * @param string $message  验证出错显示的信息
	 * @return void 
	 */
	function _validationRequired($field, $message = '') {
		if (empty($field)) $this->_addError($message);
	}
	
	/**
	 * 验证字段长度
	 * @access private
	 * @param string $field  需要验证的值
	 * @param integer $min   允许字符串的最小长度（字节为单位）
	 * @param integer $max   允许字符串的最大长度（字节为单位）
	 * @param string $message 验证出错显示的信息
	 * @return void 
	 */
	function _validationFieldLenght($field, $min = 0, $max = 0, $message = '') {
		if ($min) if (strlen($field) < intval($min)) $this->_addError($message);
		if ($max) if (strlen($field) > intval($max)) $this->_addError($message);
	}
	
	/**
	 * 注册需要显示的信息
	 * @access private
	 * @param string $message  需要注册的信息
	 * @return void 
	 */
	function _addError($message) {
		$this->_error = true;
		$this->_message[] = $message;
		Error::addError($message);
	}
	
	/**
	 * 返回错误信息注册标志
	 * @return boolean 是否有错误被注册
	 */
	function get_error() {
		return $this->_error;
	}
	
	/**
	 * 返回错误信息
	 * @return string 注册的错误信息
	 */
	function getMessage() {
		return $this->_message;
	}
}
?>