<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/managecontroller.php';

class imanageController extends manageController {
	var $_dianpuHelper;
	
	function _before() {
		parent::_before();
		$this->_dianpuHelper = DP::loadClass('dianpuhelper', 'helper');
		$this->_viewer->baseUrl = BASEURL . '&c=' . $this->_controller;
		return true;
	}
	
	function run() {
		//根据用户ID获得用户信息
		$userService = L::loadClass('userservice', 'user');
		$windusename = $this->_getGlobal('winduid');
		$dianpu_uid = $this->_dianpu->uid;
		$dianpu_uname = $this->_dianpu->username;
		$userInfo = $userService->get($dianpu_uid, true, true);
		//获得上次登录时间
		$lastVist = get_date($userInfo['lastvisit']);
		//获得组信息
		$groupdb = 'group_' . $userInfo['memberid'];//获得会员组信息		
		$windGroup = L::config('gp_grouptitle', $groupdb, 'groupdb');
		$groupName = L::config('dianpuGroups','dianpu_groups');
		$this->_viewer->groupname = $groupName[$this->_dianpu->groupid]['title'];//店铺组名
		$this->_viewer->dianpuadmingroup = $windGroup;//获得店主用户组级别
		$this->_viewer->dianpuadminname = $dianpu_uname;//店铺 店主的名字
		$this->_viewer->dianpuadminlastvist = $lastVist;//上次登录时间
		$this->_viewer->dianpuinfo = $this->_dianpu;//店铺的基本信息
		$this->_viewer->dianpuadminid = $dianpu_uid;//店铺的店主的ID
		$this->_viewer->imanage = 'current';
		$productService = DP::loadClass('productsservice', 'service');
		$this->_viewer->onshelfnum = $productService->countByObjectIdAndShelfs($this->_dianpu->dianpuid, array(1));//上架的商品数量
		$this->_viewer->downshelfnum = $productService->countByObjectIdAndShelfs($this->_dianpu->dianpuid, array(0));//下架的商品数量
	}
	
	/**
	 * 店铺认证信息页面
	 */
	function identify() {
		list($step) = $this->_gp(array('step'));
		if($this->_isPost() && $step == 2) {
			list($id) = $this->_gp(array('dianpuid'));
			$params = array();
			list($params['title'], $params['areaid'], $params['categoryid'],$params['parentid'], $params['operator'], $params['operatorphone']) = $this->_gp(array(
				'title', 'areaid', 'childid','categoryid', 'operator', 'operatorphone'));
			list($params['shangjiaid'], $params['company'], $params['delegate'], $params['delegatephone'], $params['companyaddress'], $params['companyphone'], $params['companyfax'], $params['companyzipcode']) = $this->_gp(array(
				'shangjiaid', 'company', 'delegate', 'delegatephone', 'companyaddress', 'companyphone', 'companyfax', 'companyzipcode'));
			if ($this->_dianpuHelper->editDianpu($params, $id))
			     $refreshUrl = $this->_viewer->baseUrl . '&a=identify&dianpuid=' . $id;
			     refreshto($refreshUrl, "编辑店铺成功！");
		}
		$toolsHelper = DP::loadClass('toolshelper','helper');
		$this->_viewer->parentCategorySelectHtml = $toolsHelper->createCategoryForAjax($this->_dianpu->parentid, $this->_dianpu->categoryid);
		//$this->_viewer->childCategorySelectHtml = $toolsHelper->createCategoryForAjax($this->_dianpu->parentid, $this->_dianpu->categoryid, false);
		$this->_viewer->categoryid = $this->_dianpu->categoryid;
		$this->_viewer->areaSelectHtml = $toolsHelper->createAreaLink($this->_dianpu->areaid, true);
		$this->_viewer->dianpuinfo = $this->_dianpu;
		$this->_viewer->shangjia = $this->_dianpuHelper->getShangjia($this->_dianpu->shangjiaid);
		$this->_viewer->amanage = 'current';
	}
}