<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/admincontroller.php';
class DianpuController extends AdminController {
	var $_productHelper;
	var $_dianpuHelper;
	var $_groupHelper;
	var $_perpage = 20;
	
	function _before() {
		parent::_before();
		$this->_productHelper = DP::loadClass('producthelper', 'helper');
		$this->_dianpuHelper = DP::loadClass('dianpuhelper', 'helper');
		$this->_groupHelper = DP::loadClass('groupshelper', 'helper');
		$this->_viewer->baseUrl = $this->_getGlobal('basename');
		$this->_viewer->indexUrl = BASEURL;
		return true;
	}
	
	function _after() {
		$this->_viewer->action = $this->_action;
		parent::_after();
	}
	
	/**
	 * 店铺列表
	 */
	function run() {
		list($keyword, $type, $areaid, $categoryid, $page) = $this->_gp(array('act_title', 'type', 'areaid', 'childid', 
			'page'));
		$type = ($type) ? $type : 'dianpu';
		list($parentid) = $this->_gp(array('categoryid'));
		list($this->_viewer->dianpus, $this->_viewer->paper) = $this->_dianpuHelper->getDianpuList($keyword, $type, $areaid, $parentid, $categoryid, $page, $this->_perpage);
		$this->_viewer->keyword = $keyword;
		$this->_viewer->checked[$type] = "checked='checked'";
		$toolsHelper = DP::loadClass('toolshelper', 'helper');
		$this->_viewer->parentCategorySelectHtml = $toolsHelper->createCategoryForAjax($parentid, $categoryid);
		$this->_viewer->categoryid = $categoryid;
		$this->_viewer->areaSelectHtml = $toolsHelper->createAreaLink($areaid, true);
		$this->_viewer->current['dianpu'] = 'current';
	}
	
	function getgroupinfo() {
		list($gid) = $this->_gp(array('gid'));
		echo pwJsonEncode($this->_dianpuHelper->getDianpuGroups($gid, 'array'));
		$this->_setLayoutFile('ajax');
		$this->_setLayoutType('ajax');
	}
	
	/**
	 * 店铺关闭开启
	 */
	function statedianpu() {
		list($dianpus, $state) = $this->_gp(array('dianpus', 'state'));
		if (!$dianpus) {
			echo "error";
			exit();
		}
		list($result, $message) = $this->_dianpuHelper->stateDianpu($dianpus, $state);
		$this->_setLayoutFile('ajax');
		$this->_setLayoutType('ajax');
		exit();
	}
	
	/**
	 * 实现店铺添加编辑
	 */
	function add() {
		list($step, $dianpuid) = $this->_gp(array('step', 'dianpuid'));
		list($this->_viewer->filetype, $this->_viewer->filetypeinfo) = $this->_dianpuHelper->getUploadFileType();
		$this->_viewer->db_appsdb = $this->_getGlobal('db_appsdb');
		if (empty($step)) {
			$toolsHelper = DP::loadClass('toolshelper', 'helper');
			$this->_viewer->parentCategorySelectHtml = $toolsHelper->createCategoryForAjax();
			$this->_viewer->areaSelectHtml = $toolsHelper->createAreaLink('', true);
			$this->_viewer->recommendLevel = $this->_dianpuHelper->getDianpuRecommendLevel();
			$this->_viewer->groupsSelectHtml = $this->_dianpuHelper->getDianpuGroups();
			$this->_viewer->checkWaySelectHtml = $this->_dianpuHelper->getDianpuCheckWay();
			$this->_viewer->current['add'] = 'current';
		} else {
			list($params) = $this->_gp(array('params'));
			list($params['bulletin']) = $this->_gp(array('bulletin'), false);
			list($params['groupid'], $params['areaid'], $params['parentid'], $params['categoryid'], $params['checkway'], $params['recommendlevel']) = $this->_gp(array(
				'groupid', 'areaid', 'categoryid', 'childid', 'checkway', 'recommendlevel'));
			if (!$dianpuid) {
				$params['state'] = '1';
				$params['ifcheck'] = '1';
				if ($dianpuid = $this->_dianpuHelper->addDianpu($params)) Error::showError("添加店铺成功！", $this->_getGlobal('basename') . '&action=edit&id=' . $dianpuid);
			} else {
				$dianpu = $this->_dianpuHelper->getDianpuInfo($dianpuid);
				$params['contentorder'] = $dianpu->contentorder;
				if ($this->_dianpuHelper->editDianpu($params, $dianpuid)) Error::showError("编辑店铺成功！", $this->_getGlobal('basename') . '&action=edit&id=' . $dianpuid);
			}
			Error::checkError('javascript:history.go(-1);');
		}
	}
	
	/**
	 * 编辑店铺入口
	 */
	function edit() {
		list($id) = $this->_gp(array('id'));
		list($this->_viewer->filetype, $this->_viewer->filetypeinfo) = $this->_dianpuHelper->getUploadFileType();
		$this->_viewer->db_appsdb = $this->_getGlobal('db_appsdb');
		if (!$dianpu = $this->_dianpuHelper->getDianpuInfo($id)) Error::checkError($this->_getGlobal('basename'));
		$this->_viewer->recommendLevel = $this->_dianpuHelper->getDianpuRecommendLevel($dianpu->recommendlevel);
		$this->_viewer->dianpuinfo = $dianpu;
		$this->_viewer->current['dianpu'] = 'current';
		$toolsHelper = DP::loadClass('toolshelper', 'helper');
		$this->_viewer->parentCategorySelectHtml = $toolsHelper->createCategoryForAjax($dianpu->parentid, $dianpu->categoryid);
		$this->_viewer->categoryid = $dianpu->categoryid;
		$this->_viewer->areaSelectHtml = $toolsHelper->createAreaLink($dianpu->areaid, true);
		$this->_viewer->groupsSelectHtml = $this->_dianpuHelper->getDianpuGroups($dianpu->groupid);
		$this->_viewer->checkWaySelectHtml = $this->_dianpuHelper->getDianpuCheckWay($dianpu->checkway);
		$this->_viewer->countexplain = $dianpu->contentorder ? count($dianpu->contentorder) : 0;
		$this->_setTemplate($this->_controller . '.add');
	}
	
	/**
	 * 添加编辑店铺内容
	 */
	function addcontent() {
		list($dianpuid, $step, $contentid) = $this->_gp(array('dianpuid', 'step', 'contentid'));
		$this->_viewer->dianpuinfo = $dianpu = $this->_dianpuHelper->getDianpuInfo($dianpuid);
		if (empty($step)) {
			$this->_viewer->dianpuid = $dianpuid;
			if ($contentid) $this->_viewer->dianpuContent = $this->_dianpuHelper->getDianpuContent($contentid);
		} else {
			list($params['titles']) = $this->_gp(array('titles'));
			list($params['atc_content']) = $this->_gp(array('atc_content'), false);
			$params['dianpuid'] = $dianpuid;
			$params['contentid'] = $contentid;
			$params['contentorder'] = $dianpu->contentorder;
			if ($contentid) {
				if ($this->_dianpuHelper->editContents($params)) Error::showError('编辑店铺内容成功！', $this->_viewer->baseUrl . '&action=edit&id=' . $dianpuid . '&');
			} else {
				if ($this->_dianpuHelper->addContents($params)) Error::showError('添加店铺内容成功！', $this->_viewer->baseUrl . '&action=edit&id=' . $dianpuid . '&');
			}
			Error::checkError('javascript:history.go(-1);');
		}
	}
	
	/**
	 * 删除一个店铺分页
	 */
	function deletepage() {
		list($contentid, $dianpuid) = $this->_gp(array('contentid', 'dianpuid'));
		if ($this->_dianpuHelper->deletePage($dianpuid, $contentid)) echo "success";
		ajax_footer();
	}
	
	/**
	 * 删除店铺logo
	 */
	function deletelogo() {
		list($id) = $this->_gp(array('id'));
		if ($this->_dianpuHelper->deleteLogo($id)) Error::showError("编辑店铺成功！", $this->_getGlobal('basename') . '&action=edit&id=' . $id);
		Error::checkError('javascript:history.go(-1);');
	}
	
	function export() {
		$this->_dianpuHelper->export();
		exit();
	}
	
	/**
	 * 店铺导入
	 */
	function import() {
		list($import) = $this->_gp(array('import'));
		if ($import) {
			$this->_viewer->import = $import;
			$this->_viewer->dianpuList = $this->_dianpuHelper->import();
			if (empty($this->_viewer->dianpuList)) $this->_viewer->message = '没有需要导入的店铺数据';
		}
	}
	
	/**
	 * 商品管理-主页
	 */
	function manageproduct() {
		list($objectid, $page) = $this->_gp(array('objectid', 'page'));
		if ($total = $this->_productHelper->countProducts()) {
			$page = ($page > 0) ? intval($page) : 1;
			$this->_viewer->products = $this->_productHelper->getProducts($page, $this->_perpage);
			$this->_viewer->pager = numofpage($total, $page, ceil($total / $this->_perpage), $this->_productHelper->_buildAdminURL('manageproduct') . '&');
		}
		$this->_viewer->checked[2] = 'checked="checked"';
		$this->_viewer->current['manageproduct'] = 'current';
	}
	/**
	 * 商品管理-搜索商品
	 */
	function searchproduct() {
		list($step, $type, $keyword, $page) = $this->_gp(array('step', 'type', 'act_title', 'page'));
		if ($step == 2) {
			$page = ($page > 0) ? intval($page) : 1;
			$this->_viewer->keyword = $keyword;
			$this->_viewer->checked[$type] = 'checked="checked"';
			list($total, $this->_viewer->products) = $this->_productHelper->searchProducts($keyword, $type, $page, $this->_perpage);
			$this->_viewer->total = $total;
			$this->_viewer->pager = numofpage($total, $page, ceil($total / $this->_perpage), $this->_productHelper->_buildAdminURL('searchproduct') . '&type=' . $type . '&step=2&act_title=' . stripslashes($keyword) . '&');
		}
		$this->_viewer->current['manageproduct'] = 'current';
		$this->_setTemplate($this->_productHelper->_buildTemplate($this->_controller, 'manageproduct'));
	}
	/**
	 * 商品管理-批量删除商品
	 */
	function deleteproducts() {
		list($step, $products) = $this->_gp(array('step', 'products'));
		if ($this->_isPost() && $step == 2) {
			list($bool, $message) = $this->_productHelper->deletesForAdmin($products);
			Error::showError($message, $this->_productHelper->_buildAdminURL('manageproduct'));
		}
		$this->_viewer->current['manageproduct'] = 'current';
		$this->_setTemplate($this->_productHelper->_buildTemplate($this->_controller, 'manageproduct'));
	}
	/**
	 * 商品管理-删除单个商品
	 */
	function deleteproduct() {
		list($productId, $dianpuid) = $this->_gp(array('productid', 'dianpuid'));
		if (!$productId) {
			Error::showError('请选择需要删除的商品', $this->_productHelper->_buildAdminURL('manageproduct'));
		}
		list($bool, $message) = $this->_productHelper->deleteProducts(array($productId), $dianpuid);
		Error::showError($message, $this->_productHelper->_buildAdminURL('manageproduct'));
	}
	/**
	 * 开通审核-主页
	 */
	function verify() {
		list($page) = $this->_gp(array('page'));
		$page = ($page > 0) ? intval($page) : 1;
		list($this->_viewer->dianpus, $this->_viewer->pager) = $this->_dianpuHelper->getUnVerifyDianpus($page, $this->_perpage);
		$this->_viewer->checked['dianpu'] = 'checked="checked"';
		$this->_viewer->current['verify'] = 'current';
	}
	
	/**
	 * 开通审核-批量审核
	 */
	function batchverify() {
		list($step, $doing, $dianpus) = $this->_gp(array('step', 'doing', 'dianpus'));
		if (!$step) return;
		if ($this->_dianpuHelper->batchVerify($doing, $dianpus)) Error::showError('操作成功', $this->_productHelper->_buildAdminURL('verify'));
		Error::checkError($this->_productHelper->_buildAdminURL('verify'));
	}
	
	/**
	 * 开通审核-删除店铺
	 */
	function deletedianpu() {
		list($step, $dianpuid) = $this->_gp(array('step', 'dianpuid'));
		if ($this->_dianpuHelper->deleteDianpus(array($dianpuid))) Error::showError('删除操作成功', $this->_productHelper->_buildAdminURL('verify'));
		Error::checkError($this->_productHelper->_buildAdminURL('verify'));
	}
	
	/**
	 * 开通审核-开启/关闭店铺
	 */
	function stateverify() {
		list($dianpus, $ifcheck) = $this->_gp(array('dianpus', 'ifcheck'));
		if (!$dianpus) Error::showError("请选择需要删除的店铺", $this->_getGlobal('basename'));
		if ($this->_dianpuHelper->checkDianpu($dianpus, $ifcheck)) Error::showError('操作成功', $this->_productHelper->_buildAdminURL('verify'));
		Error::checkError($this->_productHelper->_buildAdminURL('verify'));
	}
	
	/**
	 * 开通审核-搜索店铺
	 */
	function searchverify() {
		list($step, $keyword, $type, $page) = $this->_gp(array('step', 'act_title', 'type', 'page'));
		if ($step == 2) {
			$page = ($page > 0) ? intval($page) : 1;
			$this->_viewer->keyword = $keyword;
			$this->_viewer->checked[$type] = 'checked="checked"';
			list($this->_viewer->dianpus, $this->_viewer->pager) = $this->_dianpuHelper->searchForVerify($keyword, $type, $page, $this->_perpage);
		}
		$this->_viewer->current['verify'] = 'current';
		$this->_setTemplate($this->_productHelper->_buildTemplate($this->_controller, 'verify'));
	}
	
	/**
	 * 店铺组列表
	 */
	function groups() {
		list($page) = $this->_gp(array('page'));
		list($this->_viewer->groups, $this->_viewer->pages, $this->_viewer->start) = $this->_groupHelper->getGroupsList($page, $this->_perpage);
		$this->_viewer->current['group'] = 'current';
	}
	
	function addgroups() {
		list($step, $groupid) = $this->_gp(array('step', 'groupid'));
		if (!$step) {
			$this->_viewer->styles = $this->_groupHelper->getAllStyles($this->_groupHelper->getStylesList(), array());
			$this->_viewer->config = $this->_groupHelper->getDefaultGroupConfig();
			$this->_viewer->configs = $this->_groupHelper->getDianpuGroupsConfig($this->_viewer->config);
			$this->_viewer->current['group'] = 'current';
			return;
		}
		list($title, $config, $style, $defaultStyle) = $this->_gp(array('title', 'config', 'style', 'defaultStyle'));
		if ($this->_groupHelper->insertGroup($title, $config, $style, $defaultStyle, $groupid)) Error::showError('操作成功！', $this->_getGlobal('basename') . '&action=groups');
		Error::checkError('javascript:history.go(-1);');
	}
	
	function editgroups() {
		list($gid) = $this->_gp(array('gid'));
		if (!$group = $this->_groupHelper->getGroupInfo($gid)) Error::checkError($this->_getGlobal('basename') . '&action=groups');
		$this->_viewer->configs = $this->_groupHelper->getDianpuGroupsConfig($group['configinfo']);
		$this->_viewer->group = $group;
		$this->_viewer->config = $group['configinfo'];
		$this->_viewer->styles = $this->_groupHelper->getAllStyles($this->_groupHelper->getStylesList(), $group['styles']);
		$this->_viewer->current['group'] = 'current';
		$this->_setTemplate($this->_controller . '.addgroups');
	}
	
	function delgroups() {
		list($gid) = $this->_gp(array('gid'));
		if ($this->_groupHelper->delete($gid)) Error::showError('删除店铺组操作成功！', $this->_getGlobal('basename') . '&action=groups');
		Error::checkError($this->_getGlobal('basename') . '&action=groups');
	}
}
?>