<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/admincontroller.php';
class ConfigController extends AdminController {
	var $_categoriesHelper;
	var $_styleHelper;
	
	function _before() {
		parent::_before();
		$this->_viewer->baseUrl = $this->_getGlobal('basename');
		$this->_categoriesHelper = DP::loadClass('categorieshelper', 'helper');
		$this->_areasHelper = DP::loadClass('areashelper', 'helper');
		$this->_styleHelper = $this->_getStyleHelper();
		return true;
	}
	
	/**
	 * 站点设置信息显示
	 */
	function run() {
		$_configService = DP::loadClass('configservice', 'service');
		$config = $_configService->getConfigInfo();
		$this->_viewer->canComment[$config['cancomment']] = "checked='checked'"; //店铺是否可以评论
		$this->_viewer->starRemark[$config['starremark']] = "checked='checked'"; //店铺的星级评定
		$this->_viewer->mapcity = $config['mapcity'];
		$this->_viewer->mapkey = $config['mapkey'];
		$this->_viewer->listNum = $config['listnum']; //店铺显示的条数
		$this->_viewer->current['baseinfo'] = 'current';
	}
	
	/**
	 * 更新站点设置
	 */
	function updateconfig() {
		$_configService = DP::loadClass('configservice', 'service');
		$config = array();
		list($p, $config['cancomment'], $config['listnum'], $config['starremark'], $config['mapcity'], $config['mapkey']) = $this->_gp(array(
			'p', 'canComment', 'listNum', 'starRemark', 'mapcity', 'mapkey'));
		if ($p != 'stepConfig' || !$this->_isPost()) Error::showError("非法操作", $this->_getGlobal('basename') . '&action=run');
		if ($_configService->updateConfig($config)) Error::showError('站点配置成功', $this->_getGlobal('basename') . '&action=run');
		Error::checkError('javascript:history.go(-1);');
	}
	
	/**
	 * 行业管理-主页
	 */
	function managecategory() {
		list($this->_viewer->categories) = $this->_categoriesHelper->getCategoriesNoCache();
		$this->_viewer->stats = $this->_categoriesHelper->statDianpyCountByCategory();
		$this->_viewer->current['category'] = 'current';
	}
	/**
	 * 行业管理-增加行业
	 */
	function addcategory() {
		list($categories, $parent, $child) = $this->_gp(array('categories', 'parent', 'child'));
		list($bool, $message) = $this->_categoriesHelper->addCategories($categories, $parent, $child);
		Error::checkError($this->_categoriesHelper->_buildAdminURL('managecategory'));
	}
	/**
	 * 行业管理-删除行业
	 */
	function removecategory() {
		list($categoryId) = $this->_gp(array('categoryid'));
		list($bool, $message) = $this->_categoriesHelper->deleteCategory($categoryId);
		Error::showError($message, $this->_categoriesHelper->_buildAdminURL('managecategory'));
	}
	/**
	 * 行业管理-转移行业
	 */
	function movecategory() {
		list($step, $categoryId, $source, $target, $sourcechild, $targetchild) = $this->_gp(array('step', 'categoryid', 
			'source', 'target', 'sourcechild', 'targetchild'));
		if ($step == 2 && $this->_isPost()) {
			list($bool, $message) = $this->_categoriesHelper->moveCategory($source, $target, $sourcechild, $targetchild);
			Error::showError($message, $this->_categoriesHelper->_buildAdminURL('managecategory'));
		}
		$category = $this->_categoriesHelper->getCategory($categoryId);
		$defaultCategoryId = $this->_categoriesHelper->getDefaultParentCategory();
		$this->_viewer->sourceOption = $this->_categoriesHelper->getParentOption($category['parentid']);
		$this->_viewer->sorcechildOption = $this->_categoriesHelper->getChildOption($category['parentid'], $category['categoryid']);
		$this->_viewer->targetOption = $this->_categoriesHelper->getParentOption($defaultCategoryId);
		$this->_viewer->targetchildOption = $this->_categoriesHelper->getChildOption($defaultCategoryId);
		$this->_viewer->baseUrl = EncodeUrl($this->_viewer->baseUrl . '&action=movecategory');
		$this->_setLayoutType('ajax');
		$this->_setLayoutFile('ajax');
	}
	/**
	 * 行业管理-下拉联动
	 */
	function linkchild() {
		list($categoryId) = $this->_gp(array('categoryid'));
		echo $this->_categoriesHelper->getChildOption($categoryId);
		ajax_footer();
	}
	/**
	 * 地区管理-主页
	 */
	function managearea() {
		$this->_viewer->areas = $this->_areasHelper->getAreasNoCache();
		$this->_viewer->current['area'] = 'current';
	}
	/**
	 * 地区管理-增加地区
	 */
	function addarea() {
		list($step, $sort, $name, $presence) = $this->_gp(array('step', 'sort', 'name', 'presence'));
		if ($step == 2) {
			if ($this->_areasHelper->addAreas($presence, $sort, $name)) Error::showError('添加区域成功', $this->_categoriesHelper->_buildAdminURL('managearea'));
			Error::checkError($this->_categoriesHelper->_buildAdminURL('managearea'));
		}
	}
	/**
	 * 地区管理-删除地区
	 */
	function deletearea() {
		list($step, $areaId) = $this->_gp(array('step', 'areaid'));
		if ($this->_areasHelper->deleteArea($areaId)) Error::showError('删除区域成功', $this->_categoriesHelper->_buildAdminURL('managearea'));
		Error::checkError($this->_categoriesHelper->_buildAdminURL('managearea'));
	}
	/**
	 * 风格管理-主页
	 */
	function managestyle() {
		$this->_viewer->styles = $this->_styleHelper->getStyles();
		$this->_viewer->current['style'] = 'current';
	}
	/**
	 * 风格管理-增加风格
	 */
	function addstyle() {
		list($step, $newstyles, $styles) = $this->_gp(array('step', 'newstyles', 'styles'));
		if ($this->_isPost() && $step == 2) {
			$this->_styleHelper->operateStyles($newstyles, $styles);
		}
		Error::showError('操作成功', $this->_categoriesHelper->_buildAdminURL('managestyle'));
	}
	/**
	 * 风格管理-删除风格
	 */
	function deletestyle() {
		list($filename) = $this->_gp(array('filename'));
		list($bool, $message) = $this->_styleHelper->deleteStyle($filename);
		Error::showError($message, $this->_categoriesHelper->_buildAdminURL('managestyle'));
	}
	
	/**
	 * 风格管理-停用风格（将某个风格删除）
	 */
	function stopstyle() {
		list($filename) = $this->_gp(array('filename'));
		if ($this->_styleHelper->stopStyle($filename)) Error::showError('操作成功', $this->_categoriesHelper->_buildAdminURL('managestyle'));
		Error::checkError($this->_categoriesHelper->_buildAdminURL('managestyle'));
	}
	
	/**
	 * 风格管理 -启用风格（将某个风格添加）
	 */
	function startstyle() {
		list($filename, $title) = $this->_gp(array('filename', 'title'));
		if ($this->_styleHelper->startStyle($filename, $title)) Error::showError('操作成功', $this->_categoriesHelper->_buildAdminURL('managestyle'));
		Error::checkError($this->_categoriesHelper->_buildAdminURL('managestyle'));
	}
	
	/**
	 * @return PW_StyleHelper
	 */
	function _getStyleHelper() {
		return DP::loadClass('stylehelper', 'helper');
	}

}