<?php
!defined('P_W') && exit('Forbidden');
require_once (R_P . 'lib/base/systemdata.php');
require_once (R_P . 'require/bbscode.php');

/**
 * 店铺商品数据多数据调用实现
 * @author qiong
 *
 */
class PW_ProductSource extends SystemData {
	var $_lang = array('member_price' => '会员价格', 'market_price' => '市场价格');
	
	/**
	 * @param array $config
	 * @param int $num
	 * @return array
	 */
	function getSourceData($config, $num) {
		$config = $this->_initConfig($config);
		$_tmp = $this->_getData($config['product'], $num);
		foreach ($_tmp as $key => $value) {
			$_tmp[$key] = $this->_cookData($value);
		}
		return $_tmp;
	}
	
	/**(non-PHPdoc)
	 * @see lib/base/SystemData#getSourceConfig()
	 */
	function getSourceConfig() {
		return array(
			'product' => array('name' => '商品数据', 'type' => 'select', 
				'value' => array('hot' => '热门商品', 'recommend' => '推荐商品')));
	}
	
	/**
	 * @access private
	 * @param string $type
	 * @param int $num
	 * @return array
	 */
	function _getData($type, $num) {
		if (!$type) $type = 'hot';
		switch ($type) {
			case 'hot':
				return $this->_getHotProduct($num);
			case 'recommend':
				return $this->_getRecommendProducts($num);
			default:
				return array();
		}
	}
	
	/**
	 * @param array $config
	 * @return array
	 */
	function _initConfig($config) {
		$temp = array();
		$temp['product'] = isset($config['product']) ? $config['product'] : '';
		return $temp;
	}
	
	function _getHotProduct($num) {
		$productService = $this->_getProductService();
		return $productService->getProductsWithHits(1, $num);
	}
	
	/**
	 * 获得店铺推荐商品
	 * @param int $num
	 * @return array
	 */
	function _getRecommendProducts($num) {
		$productService = $this->_getProductService();
		return $productService->getProductsWithRecommend(1, $num);
	}
	
	/**
	 * 格式化输出结果
	 * @param array $data
	 * @return array
	 */
	function _cookData($data) {
		global $db_bbsurl, $db_windpost;
		$data['url'] = $data['url'] ? $data['url'] : $db_bbsurl . '/index.php?m=dianpu&c=product&a=detail&id=' . $data['objectid'] . '&productid=' . $data['productid'];
		$data['title'] = convert($data['title'], $db_windpost);
		$data['descrip'] = convert($data['description'], $db_windpost);
		$data['member_price'] = $data['member_price'];
		$data['market_price'] = $data['market_price'];
		$data['image'] = $data['photopath'];
		return $data;
	}
	
	/**
	 * @return PW_ProductsService
	 */
	function _getProductService() {
		return DP::loadClass('productsservice', 'service');
	}

}

?>