<?php
!defined('M_P') && exit('Forbidden');
/**
 * 风格服务层
 * @author L.IuHu.I@2010/8/26
 *
 */
class PW_StylesService {
	
	/**
	 * 风格DAO服务对象
	 * @access private
	 * @var PW_Dianpu_StylesDB
	 */
	var $_stylesDao;
	
	/**
	 * 当前时间戳
	 * @access private
	 * @var string
	 */
	var $_timestamp;
	
	/**
	 * 构造函数，（兼容PHP4）
	 */
	function PW_StylesService() {
		$this->__construct();
	}
	
	/**
	 * 构造函数,（兼容PHP5）
	 */
	function __construct() {
		global $timestamp;
		$this->_stylesDao = $this->_getStylesDao();
		$this->_timestamp = $timestamp;
	}
	
	/**
	 * 增加风格
	 * @param array $fieldData array('字段' => '值') 需要插入的风格
	 * @return boolean 返回添加的结果
	 */
	function addStyle($fieldData) {
		if (!S::isArray($fieldData)) return false;
		$this->_stylesDao->insert($fieldData);
		$this->updateDianpuStyleCache();
		return true;
	}
	
	/**
	 * 批量增加风格
	 * @param array $fieldDatas array(array('字段' => '值'),...) 需要插入的批量风格列表
	 * @return boolean 返回批量处理结果
	 */
	function addStyles($fieldDatas) {
		if (!S::isArray($fieldDatas)) return false;
		$fields = array();
		foreach ($fieldDatas as $v) {
			$tmp = array();
			$tmp['title'] = $v['title'] ? $v['title'] : $v['filename'];
			$tmp['filename'] = $v['filename'];
			$tmp['createdtime'] = $this->_timestamp;
			$fields[] = $tmp;
		}
		$this->_stylesDao->addStyles($fields);
		$this->updateDianpuStyleCache();
		return true;
	}
	
	/**
	 * 根据风格ID更新风格
	 * @param array $fieldData  新的风格信息
	 * @param integer $styleId 需要更新的风格ID
	 * @return boolean 返回更新结果
	 */
	function updateStyle($fieldData, $styleId) {
		$styleId = intval($styleId);
		if (!S::isArray($fieldData) || $styleId < 0) return false;
		$this->_stylesDao->update($fieldData, $styleId);
		$this->updateDianpuStyleCache();
		return true;
	}
	
	/**
	 * 根据风格ID从数据库中获取风格信息
	 * @param integer $styleId 风格ID
	 * @return mixed boolean (false:操作失败) | array array('字段' => '值') 返回风格信息
	 */
	function getStyle($styleId) {
		$styleId = intval($styleId);
		if ($styleId < 0) return false;
		return $this->_stylesDao->get($styleId);
	}
	
	/**
	 * 获取多个风格
	 * @return array array('styleid' => array('字段' => '值'),...)返回风格信息列表
	 */
	function getStyles() {
		$styles = $this->_getStyleCache();
		if (!$styles) $styles = $this->_stylesDao->gets();
		$tmp = array();
		foreach ($styles as $v) {
			$v['preview'] = 'mode/dianpu/themes/' . $v['filename'] . '/images/preview.jpg';
			$tmp[$v['styleid']] = $v;
		}
		return $tmp;
	}
	
	/**
	 * 根椐IDs获取风格
	 * @param array $ids 需要获取的风格ID列表
	 * @return mixed boolean (false:操作失败) | array array('styleid' => array('字段' => '值'),...)返回风格列表
	 */
	function getStylesByIds($ids) {
		if (!S::isArray($ids)) return false;
		$result = $this->_stylesDao->getsByIds($ids);
		if (!$result) return false;
		$tmp = array();
		foreach ($result as $v) {
			$v['preview'] = 'mode/dianpu/themes/' . $v['filename'] . '/images/preview.jpg';
			$tmp[$v['styleid']] = $v;
		}
		return $tmp;
	}
	
	/**
	 * 根据风格ID删除风格
	 * @param integer $styleId 需要删除的风格ID
	 * @return boolean 返回删除的结果
	 */
	function deleteStyle($styleId) {
		$styleId = intval($styleId);
		if ($styleId < 0) return false;
		if (!$this->_stylesDao->delete($styleId)) return false;
		$this->updateDianpuStyleCache();
		return true;
	}
	
	/**
	 * 根椐文件名获取风格
	 * @param string $filename 文件名
	 * @return mixed boolean (false:操作失败) | array array('字段' => '值') 返回的风格信息
	 */
	function getStyleByFilename($filename) {
		$filename = trim($filename);
		if ($filename == '') return false;
		return $this->_stylesDao->getByFileName($filename);
	}
	
	/**
	 * 根椐风格ID从缓存文件中获取风格
	 * @param integer $styleid
	 * @return array 返回风格信息
	 */
	function getStyleById($styleid = '') {
		$styles = L::config('styles', 'dianpu_styles');
		return $styleid ? $styles[$styleid] : $styles;
	}
	
	/**
	 * 更新店铺风格缓存
	 * @return void
	 */
	function updateDianpuStyleCache() {
		$data = $this->_stylesDao->gets();
		$_tmp = array();
		foreach ($data as $key => $value) {
			$value['preview'] = 'mode/dianpu/themes/' . $value['filename'] . '/images/preview.jpg';
			$_tmp[$value['styleid']] = $value;
		}
		$this->_updateCache($_tmp);
	}
	
	/**
	 * 获得风格缓存信息
	 * @access private
	 * @return array 返回缓存文件中的风格信息
	 */
	function _getStyleCache() {
		$_cachefile = D_P . "data/bbscache/dianpu_styles.php";
		if (file_exists($_cachefile)) return L::config('styles', 'dianpu_styles');
		return array();
	}
	
	/**
	 * 根据传入的风格信息列表更新风格缓存文件
	 * @param array $data 待更新的风格信息
	 * @return void 
	 */
	function _updateCache($data) {
		$_cachefile = D_P . "data/bbscache/dianpu_styles.php";
		writeover($_cachefile, "<?php\r\n\$styles=" . pw_var_export($data) . "\r\n?>");
	}
	
	/**
	 * 获取商品DAO服务
	 * @return PW_Dianpu_StylesDB 
	 */
	function _getStylesDao() {
		return DP::loadDB("dianpu_styles");
	}

}