<?php
!defined('M_P') && exit('Forbidden');
/**
 * 商品点击率服务层
 * @author L.IuHu.I@2010/9/8
 *
 */
class PW_ProducthitsService {
	
	/**
	 * 商品点击率DAO服务
	 * @access private
	 * @var PW_Dianpu_ProducthitsDB
	 */
	var $_producthitsDao;
	
	/**
	 * 构造函数，（兼容PHP4）
	 */
	function PW_ProducthitsService() {
		$this->__construct();
	}
	
	/**
	 * 构造函数，（兼容PHP5）
	 */
	function __construct() {
		$this->_producthitsDao = $this->_getProducthitsDao();
	}
	
	/**
	 * 更新商品点击率 / 每隔51次 更新一次
	 * @param integer $productId 商品的ID
	 * @param integer $objId 店铺ID
	 * @return integer 返回受影响的行数
	 */
	function updateProductHits($productId, $objId = '') {
		$productId = intval($productId);
		$phits = $this->_producthitsDao->get($productId);
		if (!$phits) return $this->_producthitsDao->insert(array('id' => $productId, 'hits' => 1));
		if ($phits['hits'] && ($phits['hits'] % 51) === 0) {
			$productService = $this->_getProductService();
			$productService->updateProduct(array('hits'=>$phits['hits']) , $productId , $objId);
		}
		return $this->_producthitsDao->updateHits($productId);
	}
	
	/**
	 * 根据点击率获得商品ID列表
	 * @param integer $start 开始搜索的位置
	 * @param integer $offset 搜索的条数
	 * @return mixed boolean (false:操作失败) | array array(array('id' => '值'),...)返回商品列表
	 */
	function getProductByHits($start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		return $this->_producthitsDao->gets($start, $offset);
	}
	
	/**
	 * 获得商品的服务对象
	 * @access private
	 * @return PW_ProductsService 
	 */
	function _getProductService() {
		return DP::loadClass('productsservice', 'service');
	}
	
	/**
	 * 获取商品点击率DAO服务
	 * @access private
	 * @return PW_Dianpu_ProducthitsDB 
	 */
	function _getProducthitsDao() {
		return DP::loadDB("dianpu_producthits");
	}

}