<?php
!defined('M_P') && exit('Forbidden');
/**
 * 商品图片服务层
 * @author L.IuHu.I@2010/8/24
 *
 */
class PW_PhotosService {
	
	/**
	 * 商品图片DAO服务对象
	 * @access private
	 * @var PW_Dianpu_PhotosDB
	 */
	var $_photosDao;
	
	/**
	 * 构造函数（兼容PHP4）
	 */
	function PW_PhotosService() {
		$this->__construct();
	}
	
	/**
	 * 构造函数（兼容PHP5）
	 */
	function __construct() {
		$this->_photosDao = $this->_getPhotosDao();
	}
	
	/**
	 * 添加商品图片
	 * @param array $fieldData 添加的商品图片的数据
	 * @return integer 返回插入的ID
	 */
	function addPhoto($fieldData){
		if (!S::isArray($fieldData)) return false;
		return $this->_photosDao->insert($fieldData);
	}
	
	/**
	 * 根据商品ID获得图片
	 * @param integer $objectid   商品（或对象）ID
	 * @param integer $page       图片搜索的页数（当前需要搜索的页数）
	 * @param integer $perpage    图片搜索的条数（分页中每页显示的条数）
	 * @return mixed boolean (false:操作失败) | array  array(array('字段' => '值'),...)返回商品图片列表 
	 */
	function getPhotosByObjectId($objectid, $page = 1, $perpage = 20){
		$objectid = intval($objectid);
		if ($objectid < 1) return false;
		list($start, $perpage) = $this->_filterPage($page, $perpage);
		return $this->_photosDao->getsByObjectId($objectid, $start, $perpage);
	}
	
	/**
	 * 根据商品图片ID删除商品图片
	 * @param integer $photoId 需要删除的商品图片ID
	 * @return mixed boolean (false:操作失败) | integer 返回受影响的行数
	 */
	function deletePhoto($photoId){
		$photoId = intval($photoId);
		if ($photoId < 1) return false;
		return $this->_photosDao->delete($photoId);
	}
	
	/**
	 * 根据商品图片ID和图片所属店铺ID删除图片
	 * @param integer $photoId 商品图片ID
	 * @param integer $belongId 所属店铺ID
	 * @return mixed boolean (false:操作失败) | integer 返回受影响的行数
	 */
	function deleteByPhotoIdAndBelongId($photoId, $belongId){
		$photoId = intval($photoId);
		$belongId = intval($belongId);
		if ($photoId < 1 || $belongId < 1 ) return false;
		return $this->_photosDao->deleteByPhotoIdAndBelongId($photoId, $belongId);
	}
	
	/**
	 * 根据商品图片ID获得商品图片信息
	 * @param integer $photoId 商品图片ID
	 * @return mixed boolean (false:操作失败) | array array('字段' => '值')返回该商品图片的信息
	 */
	function getPhoto($photoId){
		$photoId = intval($photoId);
		if ($photoId < 1) return false;
		return $this->_photosDao->get($photoId);
	}
	
	/**
	 * 根据商品图片ID列表获得商品图片信息列表
	 * @param array $photoIds 商品图片ID列表
	 * @return array array('photoid'=>array('字段' => '值'),...) 返回所有符合的商品图片信息列表
	 */
	function getPhotosByIds($photoIds){
		if (!S::isArray($photoIds)) return array();
		$result =  $this->_photosDao->getPhotosByIds($photoIds);
		if (!$result) return array();
		$tmp = array();
		foreach ($result as $p) {
			$tmp[$p['photoid']] = $p;
		}
		return $tmp;
	}
	
	/**
	 * 批量添加商品图片
	 * @param array $fieldDatas array(array('字段' => '值'),...) 等待添加的商品图片信息
	 * @return mixed boolean (false:操作失败) | integer 返回插入的ID
	 */
	function addPhotos($fieldDatas){
		if (!S::isArray($fieldDatas)) return false;
		$fields = array();
		foreach ($fieldDatas as $v) {
			$tmp = array();
			$tmp['belongid'] = intval($v['belongid']);
			$tmp['objectid'] = intval($v['objectid']);
			$tmp['typeid'] = intval($v['typeid']);
			$tmp['filename'] = trim($v['filename']);
			$tmp['path'] = trim($v['path']);
			$tmp['createdtime'] = $v['createdtime'];
			$fields[] = $tmp;
		}
		return $this->_photosDao->addPhotos($fields);
	}
	
	/**
	 * 过滤查询分页的页码数和需要查询的条数
	 * @access private
	 * @param integer $page 需要查询的页码
	 * @param integer $perpage 需要查询的条数
	 * @return array array(start,//查询的开始位置<br/> 
	 * 					    perpage,//查询的条数<br/> 
	 * 					    page //被查询的页码<br/>)
	 */
	function _filterPage($page, $perpage) {
		$page = intval($page);
		$page = ($page) ? $page : 1;
		$start = ($page - 1) * $perpage;
		$start = intval($start);
		$perpage = intval($perpage);
		return array($start,$perpage,$page);
	}
	
	/**
	 * 获取商品图片DAO服务
	 * @access private
	 * @return PW_Dianpu_PhotosDB 
	 */
	function _getPhotosDao() {
		return DP::loadDB("dianpu_photos");
	}

}