<?php
!defined('M_P') && exit('Forbidden');
/**
 * 店铺点击率服务层
 * @author qiong
 * 
 */
class pw_dianpuhitsservice {
	
	/**
	 * 更新店铺点击率
	 * @param integer $dianpuid 需要更新的店铺ID
	 * @return integer 返回受影响的行数
	 */
	function updateDianpuHits($dianpuid) {
		$dianpuHitsDB = $this->_getDianpuHitsDB();
		$dianpuHits = $dianpuHitsDB->getHits($dianpuid);
		if (!$dianpuHits) return $dianpuHitsDB->insert(array('id' => $dianpuid , 'hits' => '1'));
		if ($dianpuHits['hits'] && ($dianpuHits['hits']%3) === 0) {
			$_dianpuService = $this->_getDianpuService();
			$_dianpuService->updateDianpuHits($dianpuid, $dianpuHits['hits']);
		}
		return $dianpuHitsDB->update($dianpuid);
	}
	
	/**
	 * 获得店铺service
	 * @access private
	 * @return PW_DianpuService 
	 */
	function _getDianpuService() {
		return DP::loadClass('dianpuservice' , 'service');
	}
	
	/**
	 * 获得店铺点击率的DAO
	 * @access private
	 * @return PW_Dianpu_DianpuhitsDB 
	 */
	function _getDianpuHitsDB() {
		return DP::loadDB('Dianpu_Dianpuhits');
	}
}
?>