<?php
!defined('P_W') && exit('Forbidden');

/**
 * 导入店铺信息的csv文件服务层
 * @author yishuo
 */
class PW_CSVService {
	
	/**
	 * 读取文件名
	 * @access private
	 * @var string
	 */
	var $_filename;
	
	/**
	 * 打开文件的句柄
	 * @access private
	 * @var resource
	 */
	var $_fp = NULL;
	
	/**
	 * 上传CSV文件
	 * 
	 * @access private
	 * @return boolean 记录上传是否成功
	 */
	function _uploadCsv() {
		$csvupload = DP::loadClass('csvupload');
		if (PwUpload::getUploadNum()) {
			PwUpload::upload($csvupload);
			$this->_filename = $csvupload->pathname;
			return true;
		}
		return false;
	}
	
	/**
	 * 从导入的文件中获取数据信息列表
	 * @return array  array(array('字段' => '值')...)
	 */
	function getDataList() {
		global $db_charset;
		if (!$this->_uploadCsv()) return array();
		if (!$this->_isCsv()) return array();
		$this->_open();
		$filesize = filesize($this->_filename);
		$_result = array();
		$_col = 0;
		L::loadClass('Chinese', 'utility/lang', false);
		$chs = new Chinese('gbk', $db_charset);
		while (($data = fgets($this->_fp, $filesize)) !== false) {
			if ($_col >= 100) break;
			$data = explode(',', $this->_filterInputData($data));
			if ($_col > 0 && $data) {
				if (!$data[0] && !$data[1] && !$data[2] && !$data[3]) continue;
				$_formator['username'] = $chs->Convert($data[0]);
				$_formator['title'] = $chs->Convert($data[1]);
				$_formator['operator'] = $chs->Convert($data[2]);
				$_formator['operatorphone'] = $chs->Convert($data[3]);
				$_formator['company'] = $chs->Convert($data[4]);
				$_formator['delegate'] = $chs->Convert($data[5]);
				$_formator['delegatephone'] = $chs->Convert($data[6]);
				$_formator['companyaddress'] = $chs->Convert($data[7]);
				$_formator['companyfax'] = $chs->Convert($data[8]);
				$_formator['companyphone'] = $chs->Convert($data[9]);
				$_formator['companyzipcode'] = $chs->Convert($data[10]);
				$_result[] = $_formator;
			}
			$_col++;
		}
		$this->_close();
		$this->_del();
		return $_result;
	}
	
	/**
	 * 过滤一行的数据
	 * 过滤空格，制表符\t，并进行字符转换
	 * @access private
	 * @param string $data 需要过滤的数据
	 * @return string 输出过滤后的数据
	 */
	function _filterInputData($data) {
		$data = str_replace(array("\t", ' '), '', $data);
		return S::escapeChar($data, 0, true);
	}
	
	/**
	 * 判断导入的文件是否是CSV文件
	 * @access private
	 * @return boolean 判断的结果
	 */
	function _isCsv() {
		if (!$this->_filename || !is_file($this->_filename)) return false;
		$ext = strtolower(substr(strrchr($this->_filename, '.'), 1));
		if (!in_array($ext, array('csv'))) return false;
		return true;
	}
	
	/**
	 * 打开导入的文件
	 * @access private
	 * @param string $method 打开方式 默认为只读
	 * @return void
	 */
	function _open($method = 'r') {
		if (!is_resource($this->_fp)) {
			$this->_fp = fopen($this->_filename, $method);
		}
	}
	
	/**
	 * 关闭打开的文件
	 * @access private
	 * @return void
	 */
	function _close() {
		if (is_resource($this->_fp)) {
			fclose($this->_fp);
			$this->_fp = NULL;
		}
	}
	
	/**
	 * 删除文件
	 * @access private
	 * @return void
	 */
	function _del() {
		if ($this->_filename && is_file($this->_filename)) {
			P_unlink($this->_filename);
		}
	}
}
?>