<?php
!defined('M_P') && exit('Forbidden');
/**
 * 地区服务层
 * @author L.IuHu.I@2010/8/26
 *
 */
class PW_AreasService {
	
	/**
	 * 保存地区的DAO服务对象
	 * @access private
	 * @var PW_Dianpu_areasDB
	 */
	var $_areasDao;
	
	/**
	 * 构造函数(兼容PHP4)
	 */
	function PW_AreasService() {
		$this->__construct();
	}
	
	/**
	 * 构造函数（兼容PHP5）
	 */
	function __construct() {
		global $timestamp;
		$this->_areasDao = $this->_getAreasDao();
		$this->_timestamp = $timestamp;
	}
	
	/**
	 * 添加地区
	 * @param array $fieldData array('字段'=>'值')
	 * @return integer 插入的ID
	 */
	function addArea($fieldData) {
		if (!S::isArray($fieldData)) return false;
		if (!$this->_cleanParam($fieldData)) return false;
		$result = $this->_areasDao->insert($fieldData);
		if ($result) $this->refreshAreaCache();
		return $result;
	}
	
	/**
	 * 批量添加地区
	 * @param array $fieldDatas array(array('字段'=>'值'),...)
	 * @return integer 最后插入的ID
	 */
	function addAreas($fieldDatas) {
		if (!S::isArray($fieldDatas)) return false;
		if (!$this->_filterParams($fieldDatas)) return false;
		$fields = array();
		foreach ($fieldDatas as $v) {
			$tmp = array();
			$tmp['name'] = $v['name'];
			$tmp['sort'] = intval($v['sort']);
			$tmp['createdtime'] = $this->_timestamp;
			$fields[] = $tmp;
			unset($tmp);
		}
		$result = $this->_areasDao->addAreas($fields);
		if ($result) $this->refreshAreaCache();
		return $result;
	}
	
	/**
	 * 更新地区
	 * @param array $fieldData array('字段'=>'值') 需要跟新的字段内容信息
	 * @param integer $areaId 更新的地区ID
	 * @return integer 受影响的行数
	 */
	function updateArea($fieldData, $areaId) {
		$areaId = intval($areaId);
		if (!S::isArray($fieldData) || $areaId < 0) return false;
		if (!$this->_cleanParam($fieldData)) return false;
		$result = $this->_areasDao->update($fieldData, $areaId);
		if ($result) $this->refreshAreaCache();
		return $result;
	}
	
	/**
	 * 根据地区ID获得地区信息
	 * @param integer $areaId 地区ID
	 * @return mixed boolean (false:失败) | array ('字段'=>'值')
	 */
	function getArea($areaId) {
		$areaId = intval($areaId);
		if ($areaId < 0) return false;
		$areas = $this->getAreas();
		if (!$areas) return $this->_areasDao->get($areaId);
		foreach ($areas as $area) {
			if ($area['areaid'] == $areaId) return $area;
		}
	}
	
	/**
	 * 从缓存文件中获得地区列表
	 * @return array array(array('字段'=>'值')...)
	 */
	function getAreas() {
		$dianpu_area_cache = L::config($dianpu_area_cache, 'dianpu_area_cache');
		if (!$dianpu_area_cache) $soruceAreas = $this->refreshAreaCache();
		return ($dianpu_area_cache) ? $dianpu_area_cache['dianpu_area_cache'] : $soruceAreas;
	}
	
	/**
	 * 刷新地区列表的缓存文件
	 * @return array array(array('字段'=>'值')...)
	 */
	function refreshAreaCache() {
		$areas = $this->getAreasNoCache();
		if (S::isArray($areas)) {
			writeover(D_P . 'data/bbscache/dianpu_area_cache.php', "<?php\r\n\$dianpu_area_cache=" . pw_var_export($areas) . ";\r\n?>");
		}
		return $areas;
	}
	
	/**
	 * 从数据库中获得地区列表
	 * @return array array(array('字段'=>'值')...)
	 */
	function getAreasNoCache() {
		return $this->_areasDao->gets();
	}
	
	/**
	 * 通过地区ID获得其所有地区列表
	 * @param array $ids array(id1,id2...); 地区ID列表
	 * @return mixed boolean (false:失败) | array('areaid'=>'areaname'...)
	 */
	function getAreasByIds($ids) {
		if (!S::isArray($ids)) return false;
		$result = $this->_getAreas($ids);
		if (!$result) return false;
		$tmp = array();
		foreach ($result as $v) {
			$tmp[$v['areaid']] = $v['name'];
		}
		return $tmp;
	}
	
	/**
	 * 从数据库或者缓存文件中获得地区列表
	 * @access private
	 * @param array array('areaid'...) 查询的地区ID列表
	 * @return array array(array('字段'=>'值')...)
	 */
	function _getAreas($ids) {
		$areas = $this->getAreas();
		if (!$areas) return $this->_areasDao->getsByIds($ids);
		$result = array();
		foreach ($areas as $area) {
			if (in_array($area['areaid'], $ids)) $result[] = $area;
		}
		return $result;
	}
	
	/**
	 * 根据地区ID删除地区
	 * @param integer $areaId 地区的ID
	 * @return mixed boolean (false:操作失败) | integer 返回受影响的行数
	 */
	function deleteArea($areaId) {
		$areaId = intval($areaId);
		if ($areaId < 0) return false;
		$result = $this->_areasDao->delete($areaId);
		if ($result) $this->refreshAreaCache();
		return $result;
	}
	
	/**
	 * 对输入的参数进行过滤（批量的输入）
	 * @access private
	 * @param array $params array(array('字段' => '值')...)
	 * @return array array(array('字段' => '值')
	 */
	function _filterParams($params) {
		$temp = array();
		foreach ($params as $key => $one) {
			$_tmp = $this->_cleanParam($one);
			if (!$_tmp) return $temp;
			$temp[$key] = $_tmp;
		}
		return $temp;
	}
	
	/**
	 * 对输入的参数进行过滤（单条的输入）
	 * @access private
	 * @param array $param array('字段' => '值')
	 * @return mixed boolean (false: 失败) | array array('字段' => '值')
	 */
	function _cleanParam($param) {
		if (!$param['name']) {
			Error::addError('请输入地区！');
			return false;
		}
		if (strlen($param['name']) > 20) {
			Error::addError('地区"<font color="red">' . $param['name'] . '</font>"输入错误，长度不能超过20个字节！');
			return false;
		}
		return $param;
	}
	
	/**
	 * 获取地区DAO服务
	 * @access private
	 * @return PW_Dianpu_areasDB 
	 */
	function _getAreasDao() {
		return DP::loadDB("dianpu_areas");
	}
}