<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/basemodule.php';
/**
 * 店铺业务模型实现
 * @author papa0924@gmail.com
 */
class PW_DianpuModule extends BaseModule {
	
	var $dianpuid = null;
	var $state = null;
	var $contents = null;
	var $titles = null;
	var $uid = null;
	var $username = null;
	var $url = null;
	var $operator = null;
	var $operatorphone = null;
	var $groupid = null;
	var $group = null;
	var $businfo = null;
	var $tempstyle = null;
	var $title = null;
	var $checktime = null;
	var $address = null;
	var $qq = null;
	var $msn = null;
	var $wangwang = null;
	var $email = null;
	var $phone = null;
	var $areanumber = null;
	var $map_x = null;
	var $map_y = null;
	var $map_z = null;
	var $logo = null;
	var $bulletin = null;
	var $ifattach = null;
	var $createtime = null;
	var $modifytime = null;
	var $overtime = null;
	var $shangjiaid = null;
	var $company = null;
	var $delegate = null;
	var $delegatephone = null;
	var $companyaddress = null;
	var $companyphone = null;
	var $companyfax = null;
	var $companyzipcode = null;
	var $contentorder = null;
	var $areaid = null;
	var $area = null;
	var $categoryid = null;
	var $category = null;
	var $parentid = null;
	var $parent = null;
	var $ifcheck = null;
	var $checkway = null;
	var $recommendlevel = null;
	var $hit = null;
	var $checkwayhtml = null;
	
	/**
	 * 按指定的排序数字顺序获得店铺说明tab页标题
	 * @return array array(contentid => array(), ...)
	 */
	function getPageTitles() {
		if (!$this->contentorder) return array();
		$_tmp = $_result = array();
		foreach ($this->contentorder as $key => $value) {
			$_tmp[$key] = (int) $value['o'];
		}
		asort($_tmp);
		foreach ($_tmp as $key => $value) {
			$_result[$key] = $this->contentorder[$key];
		}
		return $_result;
	}
	
	/**
	 * 设置店铺ID
	 * @param integer $dianpuid 需要设置的店铺ID
	 * @return void 
	 */
	function setDianpuid($dianpuid) {
		$this->dianpuid = $dianpuid;
	}
	
	/**
	 * 设置店铺的状态
	 * @param integer $state 店铺状态(1为开启状态，默认为0：关闭）
	 * @return void 
	 */
	function setState($state) {
		$this->state = $state;
	}
	
	/**
	 * 设置店铺的说明
	 * @param string $contents 店铺说明
	 * @return void 
	 */
	function setContents($contents) {
		$this->_filterWordsfb($contents, '店铺说明');
		$this->contents = $this->_filterContent($contents);
	}
	
	/**
	 * 设置店铺的店主论坛ID
	 * @param integer $uid 店主论坛ID
	 * @return void 
	 */
	function setUid($uid) {
		$this->uid = $uid;
	}
	
	/**
	 * 设置店铺的店主用户名
	 * @param string $username 店主的用户名
	 * @return void 
	 */
	function setUsername($username) {
		$this->_validationRequired($username, '用户名不能为空');
		$this->_filterWordsfb($username, '店主');
		$userService = L::loadClass('userservice', 'user');
		/* @var $userService PW_UserService */
		if (!$userid = $userService->getUserIdByUserName($username)) {
			$this->_addError("用户不存在");
		}
		$this->setUid($userid);
		$this->username = $username;
	}
	
	/**
	 * 设置店铺的网址
	 * @param string $url 店铺的网址
	 * @return void 
	 */
	function setUrl($url) {
		$this->_validationIntAndLetter($url, '店铺网址只支持英文和数字');
		$this->_filterWordsfb($url, '店铺网址');
		$this->url = $url;
	}
	
	/**
	 * 设置店铺的经营者名字
	 * @param string $operator 店铺经营者名字
	 * @return void 
	 */
	function setOperator($operator) {
		$this->_validationRequired($operator, '店铺经营者不能为空');
		$this->_filterWordsfb($operator, '店铺经营者');
		$this->_validationFieldLenght($operator, 0, 15, '店铺经营者姓名长度不能大于15个字节');
		$this->operator = $operator;
	}
	
	/**
	 * 设置店铺的经营者电话号码
	 * @param string $operatorphone 店铺经营者电话号码
	 * @return void 
	 */
	function setOperatorphone($operatorphone) {
		$this->_validationRequired($operatorphone, '店铺经营者电话不能为空');
		$this->_filterWordsfb($operatorphone, '店铺经营者电话');
		$this->_validationFieldLenght($operatorphone, 0, 30, '店铺经营者电话长度不能大于30个字节');
		$this->operatorphone = $operatorphone;
	}
	
	/**
	 * 设置店铺的店铺组ID
	 * @param integer $groupid 店铺组ID
	 * @return void 
	 */
	function setGroupid($groupid) {
		$this->_validationRequired($groupid, '请选择店铺组');
		$this->groupid = $groupid;
	}
	
	/**
	 * 设置店铺的公交信息
	 * @param string $businfo 店铺公交路线
	 * @return void 
	 */
	function setBusinfo($businfo) {
		if ($businfo) {
			$this->_validationFieldLenght($businfo, 0, 255, '店铺公交线路长度不能大于255个字节');
			$this->_filterWordsfb($businfo, '店铺公交路线');
		}
		$this->businfo = $businfo;
	}
	
	/**
	 * 设置店铺的风格
	 * @param string $tempstyle 风格
	 * @return void 
	 */
	function setTempstyle($tempstyle) {
		$this->tempstyle = $tempstyle;
	}
	
	/**
	 * 设置店铺的名称
	 * @param string $title 店铺名称
	 * @return void 
	 */
	function setTitle($title) {
		$this->_validationRequired($title, '店铺名称不能为空');
		$this->_filterWordsfb($title, '店铺名称');
		$this->_validationFieldLenght($title, 0, 30, '店铺名称长度不能大于30个字节');
		$this->title = trim($title);
	}
	
	/**
	 * 设置店铺的认证时间
	 * @param string $checktime 认证时间
	 * @return void 
	 */
	function setChecktime($checktime) {
		$this->checktime = $checktime;
	}
	
	/**
	 * 设置店铺的实体地址
	 * @param string $address 店铺实体地址
	 * @return void 
	 */
	function setAddress($address) {
		$this->_validationRequired($address, '实体店地址不能为空');
		$this->_filterWordsfb($address, '实体店地址');
		$this->_validationFieldLenght($address, 0, 255, '实体店地址长度不能大于255个字节');
		$this->address = trim($address);
	}
	
	/**
	 * 设置店铺的电话号码
	 * @param string $phone 店铺电话号码
	 * @return void 
	 */
	function setPhone($phone) {
		$this->_validationRequired($phone, '店铺电话号码不能为空');
		$this->_validationFieldLenght($phone, 5, 11, '电话号码在长度为5-11位');
		$this->_filterWordsfb($phone, '店铺电话号码');
		$this->phone = trim($phone);
	}
	
	/**
	 * 设置店铺的电话区号
	 * @param integer $areanumber 店铺的电话区号
	 * @return void 
	 */
	function setAreanumber($areanumber) {
		$this->_validationRequired($areanumber, '店铺电话区号不能为空');
		$this->_validationFieldInt($areanumber, '请填写正确的店铺电话区号！');
		$this->_validationFieldLenght($areanumber, 2, 4, '电话区号在长度为2-4位');
		$this->_filterWordsfb($areanumber, '店铺电话区号');
		$this->areanumber = trim($areanumber);
	}
	
	/**
	 * 设置店铺的地图X轴值
	 * @param string $map_x 店铺地图X轴值
	 * @return void 
	 */
	function setMap_x($map_x) {
		$this->map_x = $map_x;
	}
	
	/**
	 * 设置店铺的地图Y轴值
	 * @param string $map_y 店铺地图Y轴值
	 * @return void 
	 */
	function setMap_y($map_y) {
		$this->map_y = $map_y;
	}
	
	/**
	 * 设置店铺的地图Z轴值
	 * @param string $map_z 店铺地图Z轴值
	 * @return void 
	 */
	function setMap_z($map_z) {
		$this->map_z = $map_z;
	}
	
	/**
	 * 设置店铺的LOGO
	 * @param string $logo 店铺Logo
	 * @return void 
	 */
	function setLogo($logo) {
		$this->logo = $logo;
	}
	
	/**
	 * 设置店铺的公告
	 * @param string $bulletin 店铺的公告
	 * @return void 
	 */
	function setBulletin($bulletin) {
		if ($bulletin) {
			$this->_validationFieldLenght($bulletin, 0, 1000, '店铺公告长度不能超过1000个字节');
			$this->_filterWordsfb($bulletin, '店铺公告');
		}		
		$this->bulletin = $bulletin;
	}
	
	/**
	 * 设置店铺的创建时间
	 * @param string $createtime 店铺的创建时间
	 * @return void 
	 */
	function setCreatetime($createtime) {
		$this->createtime = $createtime;
	}
	
	/**
	 * 设置店铺的修改时间
	 * @param string $modifytime 店铺的修改时间
	 * @return void 
	 */
	function setModifytime($modifytime) {
		$this->modifytime = $modifytime;
	}
	
	/**
	 * 设置店铺的过期时间
	 * @param string $overtime 店铺的过期时间
	 * @return void 
	 */
	function setOvertime($overtime) {
		if ($overtime) $this->_validateOvertime(PwStrtoTime($overtime));
		$this->overtime = $overtime;
	}
	
	/**
	 * 设置店铺的地区ID
	 * @param integer $areaid 店铺地区ID
	 * @return void 
	 */
	function setAreaid($areaid) {
		$this->_validationRequired($areaid, '请选择店铺所在地区');
		$this->areaid = $areaid;
	}
	
	/**
	 * 设置店铺的地区名字
	 * @param string $area 店铺地区
	 * @return void 
	 */
	function setArea($area) {
		$this->area = $area;
	}
	
	/**
	 * 设置店铺的行业ID
	 * @param integer $parentid 店铺行业ID
	 * @return void 
	 */
	function setParentid($parentid) {
		$this->parentid = $parentid;
	}
	
	/**
	 * 设置店铺的行业名称
	 * @param string $parent 店铺行业
	 * @return void 
	 */
	function setParent($parent) {
		$this->parent = $parent;
	}
	
	/**
	 * 设置店铺的分类ID
	 * @param integer $categoryid 店铺分类ID
	 * @return void 
	 */
	function setCategoryid($categoryid) {
		$this->_validationRequired($categoryid, '请选择一个行业类型');
		$this->categoryid = $categoryid;
	}
	
	/**
	 * 设置店铺分类名称
	 * @param string $category 店铺分类
	 * @return void 
	 */
	function setCategory($category) {
		$this->category = $category;
	}
	
	/**
	 * 设置店铺的是否被认证(1:为被认证）
	 * @param integer $ifcheck 店铺被认证状态
	 * @return void 
	 */
	function setIfcheck($ifcheck) {
		$this->ifcheck = $ifcheck;
	}
	
	/**
	 * 设置店铺组的认证方式
	 * @param string $checkway 认证的方式
	 * @return void 
	 */
	function setCheckway($checkway) {
		$this->checkway = $checkway;
	}
	
	/**
	 * 设置显示的店铺的认证方式
	 * @param string $checkwayhtml 认证方式的显示
	 * @return void 
	 */
	function setCheckwayhtml($checkwayhtml) {
		$this->checkwayhtml = $checkwayhtml;
	}
	
	/**
	 * 设置店铺推荐级别
	 * @param string $recommendlevel 店铺的推荐级别
	 * @return void 
	 */
	function setRecommendlevel($recommendlevel) {
		$this->recommendlevel = $recommendlevel;
	}
	
	/**
	 * 设置店铺点击率
	 * @param integer $hit 店铺的点击率
	 * @return void 
	 */
	function setHit($hit) {
		$this->hit = $hit;
	}
	
	/**
	 * 设置店铺说明标题
	 * @param string $titles 店铺说明的标题
	 * @return void 
	 */
	function setTitles($titles) {
		$this->_validationRequired($titles, '店铺说明标题不能为空');
		$this->_validationFieldLenght($titles, 0, 20, '店铺说明的长度不能超过20个字节');
		$this->_filterWordsfb($titles, '店铺说明标题');
		$this->titles = trim($titles);
	}
	
	/**
	 * 设置店铺的说明
	 * @param array $contentorder ('contentid' => array(),..) 店铺的说明
	 * @return void 
	 */
	function setContentorder($contentorder) {
		$this->contentorder = $contentorder;
	}
	
	/**
	 * 设置店铺的联系QQ
	 * @param string $qq 店铺的联系QQ
	 * @return void 
	 */
	function setQq($qq) {
		if ($qq) {
			$this->_validationFieldInt($qq, '请正确填写QQ号！');
			$this->_validationFieldLenght($qq, 5, 15, '填写的QQ长度应该在5-15位之间');
			$this->_filterWordsfb($qq, 'QQ');
		}
		$this->qq = $qq;
	}
	
	/**
	 * 设置店铺的联系MSN
	 * @param string $msn 店铺联系MSN
	 * @return void 
	 */
	function setMsn($msn) {
		if ($msn) {
			$this->_validationFieldEmail($msn, '填写的MSN格式错误');
			$this->_validationFieldLenght($msn, 0, 100, '填写的MSN长度不能大于100个字节');
			$this->_filterWordsfb($msn, 'MSN');
		}		
		$this->msn = $msn;
	}
	
	/**
	 * 设置店铺的联系旺旺
	 * @param string $wangwang 店铺联系旺旺
	 * @return void 
	 */
	function setWangwang($wangwang) {
		if ($wangwang) {
			$this->_validationFieldLenght($wangwang, 0, 100, '填写的旺旺帐号长度在不能大于100个字节');
			$this->_filterWordsfb($wangwang, '旺旺');
		}
		$this->wangwang = $wangwang;
	}
	
	/**
	 * 设置店铺的联系Email
	 * @param string $email 店铺的联系Email
	 * @return void 
	 */
	function setEmail($email) {
		if ($email) {
			$this->_validationFieldEmail($email, '填写的Email格式错误');
			$this->_validationFieldLenght($email, 0, 100, '填写的Email长度不能大于100个字节');
			$this->_filterWordsfb($email, 'Email');
		}		
		$this->email = $email;
	}

	/**
	 * 设置店铺商家ID
	 * @param integer $shangjiaid 店铺商家ID
	 * @return void 
	 */
	function setShangjiaid($shangjiaid) {
		$this->shangjiaid = $shangjiaid;
	}
	
	/**
	 * 设置店铺的商家公司名称
	 * @param string $company 店铺商家公司名称
	 * @return void 
	 */
	function setCompany($company) {
		if ($company) {
			$this->_validationFieldLenght($company, 0, 100, '公司名称不能超过100个字节');
			$this->_filterWordsfb($company, '公司名称');
		}		
		$this->company = trim($company);
	}
	
	/**
	 * 设置店铺的商家公司法人名字
	 * @param string $delegate 店铺商家公司法人名字
	 * @return void 
	 */
	function setDelegate($delegate) {
		if ($delegate) {
			$this->_validationFieldLenght($delegate, 0, 15, '法人代表不能超过15个字节');
			$this->_filterWordsfb($delegate, '法人代表');
		}		
		$this->delegate = trim($delegate);
	}
	
	/**
	 * 设置店铺的商家公司法人手机
	 * @param string $delegatephone  店铺商家公司法人手机
	 * @return void 
	 */
	function setDelegatephone($delegatephone) {
		if ($delegatephone) {
			$this->_validationFieldLenght($delegatephone, 0, 30, '请正确填写法人手机号码！');
			$this->_filterWordsfb($delegatephone, '法人手机号码');
		}		
		$this->delegatephone = trim($delegatephone);
	}
	
	/**
	 * 设置店铺的公司地址
	 * @param string $companyaddress 店铺公司地址
	 * @return void 
	 */
	function setCompanyaddress($companyaddress) {
		if ($companyaddress) {
			$this->_validationFieldLenght($companyaddress, 0, 100, '公司地址长度不能超过100个字节');
			$this->_filterWordsfb($companyaddress, '公司地址');
		}		
		$this->companyaddress = trim($companyaddress);
	}
	
	/**
	 * 设置店铺的公司电话
	 * @param string $companyphone 店铺的商家公司电话
	 * @return void 
	 */
	function setCompanyphone($companyphone) {
		if ($companyphone) {
			$this->_validationFieldLenght($companyphone, 0, 30, '请填写正确的公司电话号码');
			$this->_filterWordsfb($companyphone, '公司电话号码');
		}		
		$this->companyphone = trim($companyphone);
	}
	
	/**
	 * 设置店铺的商家公司的传真
	 * @param string $companyfax 店铺的商家公司传真
	 * @return void 
	 */
	function setCompanyfax($companyfax) {
		if ($companyfax) {
			$this->_validationFieldLenght($companyfax, 0, 30, '请填写正确的传真号码');
			$this->_filterWordsfb($companyfax, '传真号码');
		}		
		$this->companyfax = trim($companyfax);
	}
	
	/**
	 * 设置店铺的商家公司的邮编
	 * @param string $companyzipcode 店铺的商家公司邮编
	 * @return void 
	 */
	function setCompanyzipcode($companyzipcode) {
		if ($companyzipcode) {
			$this->_validationFieldInt($companyzipcode, '邮编必须为数字');
			$this->_validationFieldLenght($companyzipcode, 6, 8, '邮编的长度为6-8');
			$this->_filterWordsfb($companyzipcode, '邮编');
		}
		$this->companyzipcode = trim($companyzipcode);
	}
	
	/**
	 * 过滤店铺内容
	 * @access private
	 * @param string $content 需要过滤的值
	 * @return string  过滤之后的值
	 */
	function _filterContent($content) {
		$content = $this->_filterConvert($content);
		foreach (array('wmv', 'rm', 'flash') as $key => $value) {
			if (strpos(",{$GLOBALS['_G']['media']},", ",$value,") === false) {
				$content = preg_replace("/(\[$value=([0-9]{1,3}\,[0-9]{1,3}\,)?)1(\].+?\[\/$value\])/is", "\${1}0\\3", $content);
			}
		}
		$content = preg_replace(array("/<script.*>.*<\/script>/is", "/<(([^\"']|\"[^\"]*\"|'[^']*')*?)>/eis", 
			"/javascript/i"), array("", "\$this->_jscv('\\1')", "java script"), str_replace('.', '&#46;', $content));
		return $content;
	}
}
?>