<?php
/**
 * 文件描述：帮助类
 * 主要提供地区、行业的下拉列表的组装输出
 * @author qiong.wuq
 * @author xiaoxia.xuxx
 * date 2010-09-20
 */
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/basehelper.php';
/**
 * 帮助类，主要给商家入驻提供下拉列表组装输出
 * @method public createCategoryForAjax() 创建行业分类的下拉列表
 * @method public createAreaLink() 创建地区列表的下拉列表
 * @method private _getParentList()
 *
 */
class PW_ToolsHelper extends BaseHelper {
	/**
	 * 创建行业分类的下拉列表
	 * @author xiaoxia.xuxx
	 * @param int $parentId 需要返回的行业分类的的父类ID，并且此如果返回的是父类列表则此ID将会设置为默认
	 * @param int $childId  需要返回的行业分类列表的子类ID，并且此如果返回的是子类列表则此ID将会设置为默认
	 * @param boolean $isParent 设置返回的类表是父类的列表还是子类的列表
	 * @param boolean $isEmpty  设置返回的列表中是否需要设置缺省选项值
	 * @return string 返回构造好的下拉列表框
	 */
	function createCategoryForAjax($parentId = '', $childId = '', $isParent = true, $isEmpty = true) {
		$categoriesService = $this->getCategoriesService();
		$categories = $categoriesService->getCategories();
		if (!$categories) {return false;}
		$_outputCategories = $_allHtml = '';
		if ($isParent) {
			$mode = $this->_getGlobal('m');
			$url = "'index.php?m=$mode&c=checkin&a=categorychildlist'";
			$_outputCategories = $this->_getParentList($categories, $parentId);
			$_allHtml = $this->_buildSelect($_outputCategories, 'categoryid', 'categoryid', $parentId, $isEmpty, 'onchange="tools.getChildCategory(' . $url . ', this);"', 'select_wa mr5');
		} else {
			$_outputCategories = $this->_getChildListByParentid($categories, $parentId);
			$_allHtml = $this->_buildSelect($_outputCategories, 'childid', 'childid', $childId, $isEmpty);
		}
		return trim($_allHtml);
	}

	/**
	 * 获得行业分类中的所有父类
	 * @author xiaoxia.xuxx
	 * @param array $categories  所有的行业分类数组
	 * @return array array("id" => "value") 返回符合条件的分类数组
	 */
	function _getParentList($categories) {
		if (!$categories) {return false;}
		$parent = array();
		foreach ($categories as $key => $category) {
			($category['parentid'] == 0) && $parent[$category['categoryid']] = $category['name'];
		}
		unset($categories);
		return $parent;
	}

	/**
	 * 获得行业分类中的某个父类的子类
	 * @author xiaoxia.xuxx
	 * @param array $categories  行业分类数组
	 * @param integer $parentId    需要获得子类分类数组的父类ID
	 * @return array array("id" => "value") 返回符合条件的分类数组
	 */
	function _getChildListByParentid($categories, $parentId) {
		if (!$categories || !$parentId) {return false;}
		$childList = array();
		foreach ($categories as $key => $category) {
			($category['parentid'] == $parentId) &&  $childList[$category['categoryid']] = $category['name'];
		}
		unset($categories);
		return $childList;
	}

	/**
	 * 创建区域下拉表单
	 * @author qiong.wuq
	 * @param int $areaId 地区ID
	 * @param boolean $isEmpty 是否需要默认值，true为需要
	 * @return string 组装好的下拉列表
	 */
	function createAreaLink($areaId = '',$isEmpty = false){
		$areaService = $this->getAreasService();
		$areas =  $areaService->getAreas();
		if(!$areas) return '';
		$tmp = array();
		foreach($areas as $a){
			$tmp[$a['areaid']] = $a['name'];
		}
		return $this->_buildSelect($tmp,'areaid','areaid',$areaId,$isEmpty);
	}

   /**
	* 组装下拉框
	* @author qiong.wuq
	* @param array $arrays 需要组装的数组
	* @param string $name 组装出来的select的name
	* @param string $id 组装出来的select 的ID
	* @param string $select 默认的选中项
	* @param boolean $isEmpty 是否给出缺省选项值
	* @param string $event 组装出来的select的响应事件
	* @param string $class 组装出来到select的css样式表
	* @return string 组装好的下拉列表
	*/
	function _buildSelect($arrays, $name, $id, $select = '', $isEmpty = false,$event = '',$class = 'select_wa') {
		if (!is_array($arrays)) return '';
		if($name == 'childid') {
			$_default = "分类";
		}elseif($name == 'areaid') {
			$_default = "地区";
		}else{
			$_default = "行业";
		}
		$html = '<select title="' . $_default . '" name="' . $name . '" id="' . $id . '" class="'.$class.'" '.$event.'>';
		($isEmpty == true) && $html .= '<option value="">' . '请选择' .$_default . '</option>';
		foreach ($arrays as $k => $v) {
			$selected = ($select == $k && $select != null) ? 'selected="selected"' : "";
			$html .= '<option value="' . $k . '" ' . $selected . '>' . $v . '</option>';
		}
		$html .= '</select>';
		return $html;
	}
}