<?php
!defined('M_P') && exit('Forbidden');
require_once MODE . '/base/basehelper.php';

/**
 * 店铺Helper层实现
 * @author qiong
 */
class PW_DianpuHelper extends BaseHelper {
	
	/**
	 * 店铺列表实现
	 * @param string $title 店铺搜索的关键字
	 * @param integer $type 店铺搜索类型 owner为店主，dianpu为店铺名称
	 * @param integer $areaid 店铺地区ID
	 * @param integer $categoryid 店铺分类ID
	 * @param integer $page 店铺分页页数
	 * @param integer $perpage 店铺分页每页显示的条数
	 * @return array 返回店铺信息列表
	 */
	function getDianpuList($title, $type, $areaid, $parentid, $categoryid, $page, $perpage = 20) {
		$_dianpuService = $this->getDianpuService();
		$_dianpus = array();
		$pageUrl = $this->_getGlobal('basename') . "&act_title=" . urlencode(stripslashes($title)) . '&areaid=' . $areaid . '&categoryid=' . $parentid . '&childid=' . $categoryid . '&type=' . trim($type);
		$owner = "";
		if ($type == 'owner') {
			$owner = $title;
			$title = "";
		}
		if (($count = $_dianpuService->getCount($title, $owner, $areaid, $categoryid, $parentid)) > 0) {
			list($page, $start) = $this->_validationPage($page, $count, $perpage);
			$_dianpus = $_dianpuService->searchForAdmin($title, $owner, $areaid, $categoryid, $parentid, $start, $perpage);
			$_pages = numofpage($count, $page, ceil($count / $perpage), $pageUrl . '&');
		}
		return array($this->_buildDianpu($_dianpus), $_pages);
	}
	
	/**
	 * 后台开通审核搜索
	 * @param $title
	 * @param $type
	 * @param $page
	 * @param $perpage
	 */
	function searchForVerify($title, $type, $page, $perpage = 20) {
		$_dianpuService = $this->getDianpuService();
		$_dianpus = array();
		$pageUrl = $this->_getGlobal('basename') . '&act_title=' . urlencode(stripslashes($title)) . '&action=searchverify&step=2&type=' . urlencode(trim($type));
		$owner = "";
		if ($type == 'owner') {
			$owner = $title;
			$title = "";
		}
		if (($count = $_dianpuService->getCountByVerify($title, $owner)) > 0) {
			list($page, $start) = $this->_validationPage($page, $count, $perpage);
			$_dianpus = $_dianpuService->searchForVerify($title, $owner, $start, $perpage);
			$_pages = numofpage($count, $page, ceil($count / $perpage), $pageUrl . '&');
		}
		return array($this->_buildDianpu($_dianpus), $_pages);
	}
	
	/**
	 * 前台店铺搜索
	 * @modified xiaoxia.xuxx@2010-09-25 
	 * @modified reason: 前台店铺列表页分页不正确，原因丢失categoryid的值
	 * @param integer $areaid 地区ID
	 * @param integer $parentid 行业ID
	 * @param integer $categoryid 分类ID
	 * @param intger $checkway 认证方式
	 * @param string $orderby 排序方式
	 * @param string $title 店铺的标题
	 * @param string $baseUrl 翻页的URL
	 * @param integer $page 需要翻页的页数
	 * @param integer $perpage 每页显示的条数
	 * @return array(dianpulist, pager) 返回
	 **/
	function searchForDianpu($areaid = '', $parentid = '', $categoryid = '', $checkway = '', $orderby = '', $title = '', $baseUrl, $page, $perpage = 20) {
		$areaid = intval($areaid);
		$parentid = (intval($parentid) > 0) ? intval($parentid) : 0;
		$categoryid = (intval($categoryid) > 0) ? intval($categoryid) : 0;
		$page = intval($page);
		$childid = ($categoryid == 0) ? $parentid : $categoryid; //将parentid和categoryid统一为categoryid输出，如果categoryid为0，标示筛选所有parentid行业下的所有分类中的店铺，分页传递的时候只要传递categoryid一个值
		$checkWayStr = (S::isArray($checkway)) ? implode('|', $checkway) : ''; //构造认证筛选条件的翻页参数
		$pageurl = $baseUrl . '&categoryid=' . $childid . '&areaid=' . $areaid . '&verify=' . $checkWayStr . '&orderby=' . $orderby . '&atc_title=' . urlencode(stripslashes($title)) . '&'; //构造分页url
		$orderby = ($orderby == 1) ? 'recommendlevel' : 'hit'; //获得查询参数
		$checkway = $this->_getCheckWay($checkway); //获得查询参数 
		$_dianpuService = $this->getDianpuService();
		$count = $_dianpuService->getCountForList($areaid, $parentid, $categoryid, $checkway, addslashes($title), $orderby);
		if ($count) {
			list($page, $start) = $this->_validationPage($page, $count, $perpage);
			$_dianpus = $_dianpuService->searchForList($areaid, $parentid, $categoryid, $checkway, addslashes($title), $orderby, '', $start, $perpage);
			$_pages = numofpage($count, $page, ceil($count / $perpage), $pageurl);
		}
		return array($this->_buildDianpu($_dianpus), $_pages);
	}
	
	/**
	 * 获得店铺的认证方式
	 * @access private 
	 * @param array $checkway 认证方式
	 */
	function _getCheckWay($checkway) {
		if (!S::isArray($checkway)) return array();
		$maps = array(1 => 'vip', 2 => 'verify', 3 => 'mobile');
		$tmp = array();
		foreach ($checkway as $c) {
			isset($maps[$c]) && $tmp[] = $maps[$c];
		}
		return $tmp;
	}
	
	/**
	 * 店铺状态改变
	 * @param array $ids
	 * @param int $state
	 * @return array
	 */
	function stateDianpu($ids, $state) {
		if (empty($ids)) return array(false, "请选择要操作的店铺！");
		if (!is_array($ids)) $ids = array($ids);
		$result = $this->getDianpuService()->closeDianpuMulit($ids, $state);
		if ($result) return array(true, "操作成功");
		return array(false, "操作失败！");
	}
	
	/**
	 * 添加店铺实现
	 * @param array $params
	 * array('username','groupid','title','areaid',
	 * 'categoryid','address','phone','logo',
	 * 'businfo','bulletin')
	 * @return array
	 */
	function addDianpu($params) {
		$service = $this->getDianpuService();
		$dianpu = $this->_setDianpu($params);
		if (count($service->searchForAdmin('', $dianpu->username, '', '', '', 0, 1))) {
			Error::addError("该店主已经存在店铺！");
			return false;
		}
		if ($dianpu->url && count($service->search(array('url' => array($dianpu->url, 'eq'))))) {
			Error::addError("输入的店铺网址已经存在！");
			return false;
		}
		if ($service->searchForAdmin($dianpu->title, '', '', '', '', 0, 1)) {
			Error::addError("输入的店铺名称已经存在！");
			return false;
		}
		$dianpu->setCreatetime($this->_getGlobal('timestamp'));
		if ($dianpu->get_error()) return false;
		$did = $service->insertDianpu($dianpu);
		if ($did && $this->setDianpuLogo($did)) return $did;
		Error::addError("添加店铺失败");
		return false;
	}
	
	/**
	 * 编辑店铺实现
	 * @param array $params
	 * array('username','groupid','title','areaid',
	 * 'categoryid','address','phone','logo',
	 * 'businfo','bulletin')
	 * @return array
	 */
	function editDianpu($params, $id) {
		$service = $this->getDianpuService();
		$conditions['username'] = array($params['username'], 'eq');
		if ($params['username'] && $params['old_username'] != $params['username'] && count($service->search($conditions, 0, 1))) return $this->_addError('该店主已经存在店铺');
		if ($params['url'] && $params['old_url'] != $params['url'] && count($service->search(array(
			'url' => array($params['url'], 'eq'))))) return $this->_addError('输入的店铺网址已经存在');
		$_dianpus = $service->search(array('title' => array($params['title'], 'eq')));
		foreach ($_dianpus as $key => $value) {
			if ($value['dianpuid'] != $id) return $this->_addError('输入的店铺名称已经存在');
		}
		$dianpu = $this->_setDianpu($params);
		$dianpu->setDianpuid($id);
		if (isset($params['orders'])) {
			list($orders, $dels) = $this->_setDianpuOrders($params['orders'], $params['contentorder']);
			$dianpu->setContentorder($orders);
		}
		if ($dianpu->get_error()) return false;
		if ($dels && !$service->deleteDianpuContents($dels)) return false;
		if ($service->updateDianpu($dianpu) && $this->setDianpuLogo($id)) return true;
		Error::addError("编辑店铺失败");
		return false;
	}
	
	/**
	 * 给店铺内容数组排序
	 * @access private
	 * @param array $orders
	 * @param array $contentOrders
	 * @return array
	 */
	function _setDianpuOrders($orders, $contentOrders) {
		$_temp = $_del = array();
		foreach ((array) $contentOrders as $key => $value) {
			if (array_key_exists($key, (array) $orders)) {
				$_temp[$key]['o'] = (int) $orders[$key];
				$_temp[$key]['t'] = $contentOrders[$key]['t'] ? $contentOrders[$key]['t'] : '';
			} else {
				$_del[] = $key;
			}
		}
		return array($_temp, $_del);
	}
	
	/**
	 * 添加店铺内容
	 * @param array $params
	 * @return boolean
	 */
	function addContents($params) {
		if (($titleorder = $this->_validationForDianpuContents($params)) === false) return false;
		$service = $this->getDianpuService();
		$dianpu = $this->_setDianpu($params);
		$dianpu = $this->_paramsMapping($params);
		$dianpu->titlesorder = ($titleorder + 1);
		if ($dianpu->_error) return false;
		if ($service->insertDianpuContent($dianpu)) return true;
		Error::addError('添加店铺失败');
		return false;
	}
	
	/**
	 * 编辑店铺内容
	 * @param array $params
	 * @return boolean
	 */
	function editContents($params) {
		if (($this->_validationForDianpuContents($params)) === false) return false;
		$service = $this->getDianpuService();
		$dianpu = $this->_paramsMapping($params);
		if ($dianpu->_error) return false;
		if ($service->updateDianpuContent($dianpu, $params['contentid'])) return true;
		Error::addError('编辑店铺内容失败');
		return false;
	}
	
	/**
	 * 根据内容ID获取店铺内容
	 * @param unknown_type $contentid
	 * @return boolean | array
	 */
	function getDianpuContent($contentid) {
		if (!$contentid) return $this->_addError('非法操作！');
		$service = $this->getDianpuService();
		if (!$dianpu = $service->getDianpuContent($contentid)) return $this->_addError('获取店铺内容失败');
		return $dianpu;
	}
	
	/**
	 * 过滤参数并返回店铺对象
	 * @access private
	 * @param array $params
	 * @return PW_DianpuModule
	 */
	function _paramsMapping($params) {
		DP::loadClass('dianpumodule', 'module', false); /* @var $dianpu PW_DianpuModule */
		$dianpu = new PW_DianpuModule();
		isset($params['dianpuid']) && $dianpu->setDianpuid($params['dianpuid']);
		isset($params['atc_content']) && $dianpu->setContents($params['atc_content']);
		isset($params['titles']) && $dianpu->setTitles($params['titles']);
		isset($params['contentorder']) && $dianpu->setContentorder($params['contentorder']);
		return $dianpu;
	}
	
	/**
	 * 删除店铺说明分页
	 * @param int $dianpuid
	 * @param int $contentid
	 * @return boolean
	 */
	function deletePage($dianpuid, $contentid) {
		$service = $this->getDianpuService();
		if (!$service->deleteDianpuContentByCid($contentid)) return $this->_addError('删除店铺内容操作失败');
		$dianpu = $service->getDianpu($dianpuid);
		$contentorder = $dianpu->contentorder;
		foreach ((array) $contentorder as $key => $value) {
			if ($contentid == $key) unset($contentorder[$key]);
		}
		if (!$service->updateDianpu($this->_paramsMapping(array('dianpuid' => $dianpuid, 
			'contentorder' => $contentorder)))) return $this->_addError('更新店铺内容失败');
		return true;
	}
	
	/**
	 * 删除店铺logo
	 * @param int $id
	 * @return boolean
	 */
	function deleteLogo($id) {
		$service = $this->getDianpuService();
		DP::loadClass('dianpumodule', 'module', false); /* @var $dianpu PW_DianpuModule */
		$dianpu = new PW_DianpuModule();
		$dianpu->setDianpuid($id);
		$dianpu->setLogo('');
		if ($service->updateDianpu($dianpu)) return true;
		return false;
	}
	
	/**
	 * 设置店铺logo
	 * @param int $did
	 * @return boolean
	 */
	function setDianpuLogo($did) {
		DP::loadClass('dianpulogoupload', '', false);
		if (!PwUpload::getUploadNum()) return true;
		$logoimg = new PW_DianpuLogoUpload($did);
		PwUpload::upload($logoimg);
		if (!$logo = $logoimg->getLogo()) return $this->_addError('上传Logo失败！可能是尺寸过大或者格式不支持');
		DP::loadClass('dianpumodule', 'module', false);
		$dianpu = new PW_DianpuModule(); /* @var $dianpu PW_DianpuModule */
		$dianpu->setLogo($logo);
		$dianpu->setDianpuid($did);
		$service = $this->getDianpuService();
		$service->updateDianpu($dianpu);
		return true;
	}
	
	/**
	 * 设置店铺信息
	 * @access private
	 * @param array $params
	 * @return PW_DianpuModule 
	 */
	function _setDianpu($params) {
		DP::loadClass('dianpumodule', 'module', false); /* @var $dianpu PW_DianpuModule */
		$dianpu = new PW_DianpuModule();
		isset($params['username']) && $dianpu->setUsername($params['username']);
		isset($params['groupid']) && $dianpu->setGroupid($params['groupid']);
		isset($params['title']) && $dianpu->setTitle($params['title']);
		isset($params['areaid']) && $dianpu->setAreaid($params['areaid']);
		isset($params['categoryid']) && $dianpu->setCategoryid($params['categoryid']);
		isset($params['parentid']) && $dianpu->setParentid($params['parentid']);
		isset($params['address']) && $dianpu->setAddress($params['address']);
		isset($params['phone']) && $dianpu->setPhone($params['phone']);
		isset($params['areanumber']) && $dianpu->setAreanumber($params['areanumber']);
		isset($params['businfo']) && $dianpu->setBusinfo($params['businfo']);
		isset($params['bulletin']) && $dianpu->setBulletin($params['bulletin']);
		isset($params['titles']) && $dianpu->setTitles($params['titles']);
		isset($params['recommendlevel']) && $dianpu->setRecommendlevel($params['recommendlevel']);
		isset($params['url']) && $dianpu->setUrl($params['url']);
		isset($params['mapx']) && $dianpu->setMap_x($params['mapx']);
		isset($params['mapy']) && $dianpu->setMap_y($params['mapy']);
		isset($params['mapz']) && $dianpu->setMap_z($params['mapz']);
		isset($params['style']) && $dianpu->setTempstyle($params['style']);
		isset($params['operator']) && $dianpu->setOperator($params['operator']);
		isset($params['operatorphone']) && $dianpu->setOperatorphone($params['operatorphone']);
		isset($params['shangjiaid']) && $dianpu->setShangjiaid($params['shangjiaid']);
		isset($params['company']) && $dianpu->setCompany($params['company']);
		isset($params['delegate']) && $dianpu->setDelegate($params['delegate']);
		isset($params['delegatephone']) && $dianpu->setDelegatephone($params['delegatephone']);
		isset($params['companyaddress']) && $dianpu->setCompanyaddress($params['companyaddress']);
		isset($params['companyphone']) && $dianpu->setCompanyphone($params['companyphone']);
		isset($params['companyfax']) && $dianpu->setCompanyfax($params['companyfax']);
		isset($params['companyzipcode']) && $dianpu->setCompanyzipcode($params['companyzipcode']);
		isset($params['checkway']) && $dianpu->setCheckway(implode(',', (array) $params['checkway']));
		isset($params['ifcheck']) && $dianpu->setIfcheck($params['ifcheck']);
		isset($params['state']) && $dianpu->setState($params['state']);
		isset($params['qq']) && $dianpu->setQq($params['qq']);
		isset($params['msn']) && $dianpu->setMsn($params['msn']);
		isset($params['wangwang']) && $dianpu->setWangwang($params['wangwang']);
		isset($params['email']) && $dianpu->setEmail($params['email']);
		isset($params['overtime']) && $dianpu->setOvertime($params['overtime']);
		$dianpu->setModifytime($this->_getGlobal('timestamp'));
		return $dianpu;
	}
	
	/**
	 * 根据店铺ID获得店铺信息
	 * @param integer $id 店铺ID
	 * @return PW_DianpuModule
	 */
	function getDianpuInfo($id) {
		if (empty($id)) return $this->_addError('请选择要编辑的店铺！');
		$service = $this->getDianpuService();
		$dianpu = $service->getDianpu($id);
		return $dianpu;
	}
	
	/**
	 * 根据店铺店主名字获得店铺信息
	 * @param string $userName 店主名字
	 * @return mixed boolean (false:操作失败) | PW_DianpuModule
	 */
	function getDianpuInfoByUser($userName = '') {
		if (!$userName) $userName = $this->_getGlobal('windid');
		$service = $this->getDianpuService();
		if (!$dianpu = $service->getDianpuByUser($userName)) return $this->_addError('您还未开通任何店铺');
		return $dianpu;
	}
	
	/**
	 * 获得允许上传文件类型
	 * @return array
	 */
	function getUploadFileType() {
		$db_uploadfiletype = $this->_getGlobal('db_uploadfiletype');
		$uploadfiletype = ($db_uploadfiletype) ? unserialize($db_uploadfiletype) : '';
		$filetypeinfo = $filetype = '';
		if ($uploadfiletype) {
			foreach ($uploadfiletype as $type => $size) {
				$filetype .= ' ' . $type . ' ';
				$filetypeinfo .= $type . ":" . $size . "KB; ";
			}
		}
		return array($filetype, $filetypeinfo);
	}
	
	/** 
	 * 过滤分页查询的开始位置和查询的条数
	 * @param integer $page 
	 * @param integer $count
	 * @param integer $perpage
	 * @return array
	 */
	function _validationPage($page, $count, $perpage) {
		$page = $page > ceil($count / $perpage) ? ceil($count / $perpage) : $page;
		$page = (int) $page <= 0 ? 1 : $page;
		$start = ($page - 1) * $perpage;
		return array($page, $start);
	}
	
	/**
	 * 获取末审核的店铺
	 * @param int $page
	 * @param int $perpage
	 * @return array
	 */
	function getUnVerifyDianpus($page, $perpage) {
		$page = intval($page);
		$start = ($page - 1) * $perpage;
		$service = $this->getDianpuService();
		$count = $service->countUncheckDianpuList();
		if (!$count) return array(array(), '');
		list($page, $start) = $this->_validationPage($page, $count, $perpage);
		$lists = $service->getUncheckDianpuList($start, $perpage);
		$pager = numofpage($count, $page, ceil($count / $perpage), $this->_getGlobal('basename') . '&action=verify&');
		return array($this->_buildDianpu($lists), $pager);
	}
	
	/**
	 * 组装店铺输出数据
	 * @param array $lists
	 * @return array
	 */
	function _buildDianpu($lists) {
		if (!S::isArray($lists)) return array();
		$categoryIds = $areaIds = array();
		foreach ($lists as $list) {
			$categoryIds[] = $list['categoryid'];
			$areaIds[] = $list['areaid'];
		}
		$categoriesService = $this->getCategoriesService();
		$areasService = $this->getAreasService();
		$categories = $categoriesService->linkCategories($categoryIds);
		$areas = $areasService->getAreasByIds($areaIds);
		$tmp = array();
		foreach ($lists as $list) {
			$category = ($categories[$list['categoryid']]) ? $categories[$list['categoryid']] : '';
			$list['parent'] = $category ? $category['parent'] : '末定义行业';
			$list['child'] = $category ? $category['child'] : '末定义分类';
			$list['area'] = isset($areas[$list['areaid']]) ? $areas[$list['areaid']] : '末定义地区';
			$tmp[] = $list;
		}
		return $tmp;
	}
	
	/**
	 * 批量处理操作 批量开启与批量删除
	 * @param int $doing
	 * @param array $dianpuIds
	 * @return boolean;
	 */
	function batchVerify($doing, $dianpuIds) {
		if (!$doing) return $this->_addError('非法操作！');
		if (!$dianpuIds) return $this->_addError('请选择需要操作的店铺！');
		if ($doing == 'open') {
			if (!$this->checkDianpu($dianpuIds, 1)) return $this->_addError('审核操作失败！');
		} elseif ($doing == 'delete') {
			if (!$this->deleteDianpus($dianpuIds)) return $this->_addError('删除操作失败！');
		}
		return true;
	}
	
	/**
	 * 批量删除店铺
	 * @param array $dianpuIds
	 * @return boolean
	 */
	function deleteDianpus($dianpuIds) {
		if (!S::isArray($dianpuIds)) return $this->_addError('请选择删除的店铺！');
		$this->_sendCheckDianpuMessages($dianpuIds, false);
		$service = $this->getDianpuService();
		if (!$service->deleteDianpuMulit($dianpuIds)) return $this->_addError('删除店铺失败！');
		return true;
	}
	
	/**
	 * 根据商家ID获得商家信息
	 * @param int $shangjiaid
	 * @return array
	 */
	function getShangjia($shangjiaid) {
		if (!$shangjiaid) return array();
		$_dianpuService = $this->getDianpuService();
		$_tmp = $_dianpuService->getShangjia($shangjiaid);
		return $_tmp;
	}
	
	/**
	 * 店铺批量开通或拒绝
	 * @param array $ids
	 * @param int $ifcheck (0/1)
	 * @return boolean
	 */
	function checkDianpu($ids, $ifcheck) {
		if (empty($ids)) return $this->_addError('请选择要操作的店铺！');
		if (!is_array($ids)) $ids = array($ids);
		$result = $this->getDianpuService()->checkDianpuMulit($ids, $ifcheck);
		if (!$result) return $this->_addError('操作失败！');
		$this->_sendCheckDianpuMessages($ids, $ifcheck);
		return true;
	}
	
	/**
	 * 批量发送消息通知用户店铺开通或拒绝
	 * @param array $dianpuIds
	 * @param boolean $isCheck
	 * @return boolean
	 */
	function _sendCheckDianpuMessages($dianpuIds, $isCheck = true) {
		$dianpuService = $this->getDianpuService();
		$dianpus = $dianpuService->getDianpuListByIds($dianpuIds);
		if (!S::isArray($dianpus)) return false;
		$userNames = array();
		foreach ($dianpus as $dianpu) {
			$dianpu['username'] && $userNames[] = $dianpu['username'];
		}
		if (!S::isArray($userNames)) return false;
		if ($isCheck) {
			$messageInfo = array('title' => '您的店铺申请已经通过审核', 
				'content' => '恭喜你，你的店铺申请已经通过审核，通过我的快捷通道和商家导航首页可进入店铺管理后台，进行相关的功能设置和商品上传。如有问题，请联系站方！');
		} else {
			$messageInfo = array('title' => '对不起，您的店铺申请未被通过', 
				'content' => '对不起，因您提交的店铺信息暂时不符合本站的要求，请确认后再次提交。如有疑问请联系站方。');
		}
		return M::sendNotice($userNames, $messageInfo);
	}
	
	/**
	 * 获得店铺组信息 支持格式 select / txt / array
	 * @param int $gid
	 * @param string $type (txt,select,array)
	 * @return string
	 */
	function getDianpuGroups($gid = '', $type = 'select') {
		$groupservice = $this->getGroupsService();
		if ($type == 'txt' && $gid) {
			$group = $groupservice->getGroupById($gid);
			return $group['title'];
		}
		if ($type == 'array' && $gid) {return $groupservice->getGroupById($gid);}
		if ($type == 'select' && $dianpugroups = $groupservice->getGroupById()) {
			$_select = '<select class="select_wa" name="groupid" id="dianpu_groups" title="店铺组"><option value="">请选择店铺组</option>';
			foreach ($dianpugroups as $key => $value) {
				$_selected = $gid == $key ? 'selected="selected"' : '';
				$_select .= '<option value="' . $key . '" ' . $_selected . '>' . $value['title'] . '</option>';
			}
			$_select .= '</select>';
			return $_select;
		}
		return '';
	}
	
	/**
	 * 获得推荐等级HTML代码 支持格式 select / txt
	 * @param int $level
	 * @param string $type (select/txt)
	 * @return string
	 */
	function getDianpuRecommendLevel($level = '', $type = 'select') {
		$dianpu_recommendLevel = L::config('dianpu_recommendLevel', 'dianpu_config');
		if ($type == 'txt' && $level) return $dianpu_recommendLevel[$level];
		if ($type == 'select') {
			$_select = '<select class="select_wa mr5" name="recommendlevel" title="分类推荐">';
			$_select .= '<option value="0">无</option>';
			foreach ($dianpu_recommendLevel as $key => $value) {
				$_selected = $level == $key ? 'selected="selected"' : '';
				$_select .= '<option value="' . $key . '" ' . $_selected . '>' . $value . '</option>';
			}
			$_select .= '</select>';
			return $_select;
		}
		return '';
	}
	
	/**
	 * 获得店铺认证方式HTML代码 支持 checkbox / img / txt格式
	 * @param string $checkway
	 * @param string $type (checkbox/img/txt)
	 * @return string
	 */
	function getDianpuCheckWay($checkway, $type = 'checkbox') {
		$dianpu_checkway = L::config('dianpu_checkway', 'dianpu_config');
		if (!is_array($checkway) && $type == 'checkbox') $_result = '<ul class="list_A list_80">';
		foreach ((array) $dianpu_checkway as $key => $value) {
			$_checked = strpos(',' . $checkway . ',', ',' . $key . ',') !== false ? 'checked="checked"' : '';
			if ($type == 'checkbox') {
				$_result .= '<li><label><input type="checkbox" value="' . $key . '" name="checkway[]" ' . $_checked . '>' . $value . '</label></li>';
			} elseif ($type == 'img' && strpos(',' . $checkway . ',', ',' . $key . ',') !== false) {
				$_result .= '<span title="' . $value . '" class="B_bg ico_' . $key . ' fl">' . $value . '</span>';
			}
		}
		if ($type == 'checkbox') $_result .= '</ul>';
		return $_result;
	}
	
	/**
	 * 导出店铺申请信息模板
	 */
	function export() {
		$timestamp = $this->_getGlobal('timestamp');
		$filename = "application form.csv";
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $timestamp + 86400) . ' GMT');
		header('Expires: ' . gmdate('D, d M Y H:i:s', $timestamp + 86400) . ' GMT');
		header('Cache-control: max-age=86400');
		header('Content-Encoding: utf-8');
		header("Content-Disposition: attachment; filename=\"{$filename}\"");
		header("Content-type: text/csv");
		header("Content-Transfer-Encoding: binary");
		$_exportData = array('*店主', '*店铺名称', '*店铺经营者', '*经营者手机', '公司全称', '法人', '法人电话', '公司地址', '公司传真', '公司电话', '公司邮编');
		echo dataConvert(implode(',', $_exportData));
	}
	
	/**
	 * 批量导入店铺信息 一次支持最多导入100条店铺数据
	 * @param int $start
	 * @param int $pernum
	 * @return array
	 */
	function import($start = 0, $pernum = 100) {
		@set_time_limit(888);
		$service = $this->getDianpuService();
		$csvservice = DP::loadClass('csvservice', 'service'); /* @var $csvservice PW_CSVService */
		$dianpuList = $csvservice->getDataList();
		$count = count($dianpuList);
		for ($i = 0; $i < ($pernum > $count ? $count : $pernum); $i++) {
			$dianpu = $this->_setDianpu($dianpuList[$i]);
			$dianpu->setCreatetime($this->_getGlobal('timestamp'));
			$dianpu->setModifytime($this->_getGlobal('timestamp'));
			$dianpu->setState('0');
			$dianpu->setIfcheck('1');
			$dianpu->setGroupid('1');
			if ($dianpu->username && count($service->search(array('username' => array($dianpu->username, 'eq')), 0, 1))) {
				$dianpuList[$i]['comments'] = '导入失败：该店主已经存在店铺';
				continue;
			}
			if ($service->search(array('title' => array($dianpu->title, 'eq')), 0, 1)) {
				$dianpuList[$i]['comments'] = '导入失败：输入的店铺名称已经存在！';
				continue;
			}
			if ($dianpu->get_error()) {
				$dianpuList[$i]['comments'] = '导入失败：' . implode(', ', $dianpu->getMessage());
				continue;
			}
			$did = $service->insertDianpu($dianpu);
			$dianpuList[$i]['dianpuid'] = $did;
			$dianpuList[$i]['comments'] = '导入成功';
		}
		return $dianpuList;
	}
	
	/**
	 * 添加店铺说明内容验证方法
	 * 店铺存不存在/店铺标题不能为空/店铺说明内容不能为空/店铺组权限验证
	 * @param array $params
	 * @return boolean
	 */
	function _validationForDianpuContents($params) {
		if (!$params['dianpuid']) return $this->_addError('店铺不存在');
		if (!$params['atc_content']) return $this->_addError('店铺说明内容不能为空');
		if (!$params['titles']) return $this->_addError('店铺说明标题不能为空');
		$service = $this->getDianpuService();
		$dianpu_old = $service->getDianpu($params['dianpuid']);
		$_maxExplain = $dianpu_old->group['configinfo']['maxexplain'];
		$_count = $dianpu_old->contentorder ? count($dianpu_old->contentorder) : 0;
		if ($_maxExplain && $_count > $_maxExplain) return $this->_addError('您所在的用户组最多可添加店铺说明' . $_maxExplain . '页');
		return $_count;
	}

}
?>