<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/basehelper.php';

/**
 * 用户评论的助手层设计
 * @author xiaoxia.xuxx
 */
class PW_CommentHelper extends BaseHelper {
	
	/**
	 * 添加评论
	 * @param array $data 新评论的信息
	 * @return array array(boolean, string) 返回处理显示的结果
	 */
	function addComment($data) {
		if (!$data) return array(false, '非法操作');
		if (!$data) return $this->_addError('非法操作');
		$commentService = $this->getCommentService();
		$_result = $commentService->addComment($data);
		if (S::isArray($_result) && $_result[0] === false) return $_result;
		if ($_result) {
			return array(true, '发表评论成功！');
		} else {
			return array(false, '发表评论失败！');
		}
	}
	
	/**
	 * 管理员根据评论ID删除评论
	 * @param integer $id 需要删除的评论ID
	 * @return array array(boolean, string)返回处理的结果（是否成功，处理的信息）
	 */
	function delCommentForAdmin($id) {
		if (!$id) return array(false, '评论删除失败');
		$commentService = $this->getCommentService();
		if (!$commentService->delCommentForAdmin($id)) {
			return array(false, '评论删除失败');
		}
		return array(true, '评论删除成功');
	}
	
	/**
	 * 根据评论ID删除评论
	 * @param integer $id 需要删除的评论ID
	 * @param integer $dianpuid 需要删除的评论所在的店铺ID
	 * @return array array(boolean, string) 返回处理的结果
	 */
	function deleteComment($id, $dianpuid) {
		if (!$id || !$dianpuid) return array(false, '非法操作');
		$commentService = $this->getCommentService();
		if (!$commentService->deleteComment($id, $dianpuid)) {
			return array(false, '评论删除失败');
		}
		return array(true, '评论删除成功');
	}
	
	/**
	 * 管理员批量删除评论
	 * @param array $ids 需要删除的评论ID列表
	 * @return array array(boolean, string)返回处理的结果
	 */
	function delCommentsForAdmin($ids) {
		if (!$ids) return array(false, '非法操作');
		$commentService = $this->getCommentService();
		if (!$commentService->delCommentsForAdmin($ids)) {
			return array(false, '评论批量删除失败');
		}
		return array(true, '评论批量删除成功');
	}
	
	/**
	 * 根据评论ID列表批量删除评论
	 * @param array $ids 需要删除的评论ID列表
	 * @param integer $dianpuid 需要删除的评论的店铺ID
	 * @return array array(boolean, string)返回处理的结果
	 */
	function deleteComments($ids, $dianpuid) {
		if (!$ids || !$dianpuid) return array(false, '非法操作');
		$commentService = $this->getCommentService();
		if (!$commentService->deleteComments($ids, $dianpuid)) {
			return array(false, '评论批量删除失败');
		}
		return array(true, '评论批量删除成功');
	}
	
	/**
	 * 前台显示获取第一级评论列表
	 * @param integer $objectid  店铺ID
	 * @param integer $typeid  商品ID  如果为0，则只取店铺的评论，如果不为0，则取该店铺中该商品的评论
	 * @param integer $page  查找的分页页数
	 * @param integer $perpage 每页显示的条数
	 * @return array  array(count, page, totalpage, rootList, childList) 返回查询信息
	 */
	function getFrontCommentList($objectid, $typeid = 0, $page = 1, $perpage = 20) {
		require_once(R_P . 'require/showimg.php');//装载函数showfacedesign
		if (!$objectid) return array();
		$commentService = $this->getCommentService();
		$count = $commentService->getFrontCount($objectid, $typeid);
		if ($count == 0) return array();
		list($start, $page, $perpage, $totalPage) = $this->_filterPage($page, $count, $perpage);
		$_rootList = $commentService->getFrontCommentList($objectid, $typeid, $start, $perpage);
		$rootIDs = array_keys($_rootList);
		$_childList = $commentService->getChildCommentList($rootIDs);
		$_replyList = $commentService->getReplyCommentList($objectid, $typeid);
		$_childList = $this->_mergeReplyToChild($_childList, $_replyList);
		return array($count,$page, $totalPage, $_rootList, $_childList);
	}
	
	
	/**
	 * 商家管理后台-评论管理
	 * @param array $params 查询参数
	 * @param integer $page 页数
	 * @param integer $perpage 每页显示的条数
	 * @return array array(count, page, totalpage, commentList) 返回查询信息
	 */
	function getShangjiaCommentList($params, $page = 1, $perpage = 20) {
		$params['isanswer'] = 0;//只查询不是店主的回复
		$commentService = $this->getCommentService();
		$count = $commentService->countTotals($params);
		list($start, $page, $perpage, $totalPage) = $this->_filterPage($page, $count, $perpage);
		$_commentList = $commentService->getSearchCommentList($params, $start, $perpage);
		return array($count, $page, $totalPage, $_commentList);
	}
	
	/**
	 * 根据条件搜索评论(站长后台搜索)
	 * @param array $params 搜索条件
	 * @param integer $page 查询页
	 * @param integer $perpage 查询条数
	 * @return array array(count, page, totalpage, commentList) 返回查询信息
	 */
	function getAdminCommentList($params, $page = 1, $perpage = 20) {	
	    $params['isanswer'] = 'all';
		$commentService = $this->getCommentService();
		$count = $commentService->countTotals($params);
		list($start, $page, $perpage, $totalPage) = $this->_filterPage($page, $count, $perpage);//获得当前页及总页数
		$_commentList = $commentService->getSearchCommentList($params, $start, $perpage);
		return array($count, $page, $totalPage, $_commentList);
	}
	
	/**
	 * 返回记录总数
	 * @param array $params 需要筛选的参数列表
	 * @return integer 返回记录总数
	 */
	function countTotals($params) {
		$commentService = $this->getCommentService();
		return $commentService->countTotals($params);
	}
	
	/**
	 * 过滤分页数据
	 * @access private
	 * @param integer $page 当前页数
	 * @param integer $count 总记录数
	 * @param integer $perPage 每页显示的条数
	 * @return array (开始位置，当前页码，每页显示的记录数，总页数)
	 */
	function _filterPage($page, $count, $perPage) {
		(empty($page) || intval($page) <1 ) ? $page = 1 : $page = intval($page);
		(empty($count) || intval($count) < 0) ? $count = 0 : $count = intval($count) ;
		(empty($perPage) || intval($perPage) < 1) ? $perPage = 1 : $perPage = intval($perPage);
		$totalPage = ceil($count/$perPage);
		if ($page > $totalPage) $page = $totalPage;
		$start = ($page - 1) * $perPage;
		$start = intval($start);
		return array($start, $page, $perPage, $totalPage);
	}
	
	/**
	 * 构造返回分页的url
	 * @param array $params 需要配置生成分页的参数列表
	 * @return string 返回构造好的url参数练
	 */
	function getPageUrl($params) {
		$_pager = '';
		if (!S::isArray($params)) return '';
		($params['isanswer']) && $_pager .= '&isanswer=' . $params['isanswer'];
		($params['content']) && $_pager .= '&content=' . urlencode(stripslashes($params['content'])); 
		($params['username']) && $_pager .= '&username=' . urlencode(stripslashes($params['username'])); 
		($params['startdate']) && $_pager .= '&startdate=' . $params['startdate'];
		($params['enddate']) && $_pager .= '&enddate=' . $params['enddate'];
		($params['state']) && $_pager .= '&state=' . $params['state'];
		return $_pager;
	}
	
	
	/**
	 * 获得当前用户的评论权限（删除，回复，评论）
	 * 输入某个店铺的店主ID，判断登录用户是否有对该店铺的评论进行相关的操作
	 * 如果是店主：则有全部权限，如果是其他成员登录则有评论权限，如果是管理员登录则有评论和删除权限
	 * @param integer $dianpuUid 店主ID
	 * @return array array（'comment', 'del', 'reply') 返回一系列的权限设置
	 */
	function getRight($dianpuUid) {
		$right = array();
		$_configService = DP::loadClass("configservice", "service");//查看是否开启评论
		$_config = $_configService->getConfigInfo();
		if ($_config['cancomment'] == 0) return array('comment' => 0);//没有开启留言功能
		$right['comment'] = 1;
		$winduid = $this->_getGlobal('winduid');//登录用户ID
		if (!$winduid) return $right;
		//如果该店铺是登录者的店铺，则具有回复和删除权限
		if ($dianpuUid == $winduid) {
			$right['reply'] = 1;
			$right['del'] = 1;
		}
		(isGM($this->_getGlobal('windid'))) && $right['del'] = 1;//判断是否是管理员登录
		return $right;
	}

	/**
	 * 根据当然店主及当前店铺所在店铺组的评论权限及站点的评论权限进行权限判断
	 * 输入某个店铺的店主ID，操作的类型 判断当前登录的用户是否有该操作权限
	 * @param integer $dianpuUid 店主ID
	 * @param integer $groupRight 店铺组的评论权限
	 * @param string $type in_array('del', 'comment', 'reply')  操作类型
	 * @return array array(boolean, string) 返回判断结果，如果为false则跟出是什么原因导致不能评论
	 */
	function checkRight($dianpuUid, $groupRight, $type = 'all') {
		$right = $this->getRight($dianpuUid);
		if (!in_array($type, array('all', 'del', 'comment', 'reply')))  return array(false, '非法操作');
		if (!$right['comment']) return array(false, '评论功能已关闭，请联系站长');
		if (!$groupRight) return array(false, '您所在的店铺组不允许评论');
		return ($type == 'all') ? array(true, '') : ($right[$type] ? array(true, '') : array(false, '没有操作权限'));
	}
	
	/**
	 * 生成分页html
	 * （这里重写了版本中的numofpage，原因是因为：
	 *     1：在我用ajax调用分页函数的时候，会因为分页触发函数js中含有{}符号而导致json解析失败，
	 *     2：用ajax调用分页的时候 提供给用户输入页数的文本框的onkeydown的触发将会导致输入框输入被响应并重置为空导致无法跳转分页；
	 *    所以这里重写了该方法，并去掉了输入页数控件的onkeydown响应事件）
	 * @param int $count 总记录数
	 * @param int $page 当前页
	 * @param int $numofpage 总页数
	 * @param string $url 分页的URL
	 * @param int $max 显示页数
	 * @param string $ajaxurl ajax调用翻页的地址
	 * @return string 返回分页
	 */
	function NumOfPage($count, $page, $numofpage, $url, $max = null, $ajaxCallBack = '') {
		global $tablecolor;
		$total = $numofpage;
		if (!empty($max)) {
			$max = (int) $max;
			$numofpage > $max && $numofpage = $max;
		}
		if ($numofpage <= 1 || !is_numeric($page)) return '';
		$ajaxurl = $ajaxCallBack ? " onclick=\"return $ajaxCallBack(this.href);\"" : '';
		list($url, $mao) = explode('#', $url);
		$mao && $mao = '#' . $mao;
		$pages = "<div class=\"pages\"><a href=\"{$url}page=1$mao\"{$ajaxurl}>&laquo;</a>";
		for ($i = $page - 3; $i <= $page - 1; $i++) {
			if ($i < 1) continue;
			$pages .= "<a href=\"{$url}page=$i$mao\"{$ajaxurl}>$i</a>";
		}
		$pages .= "<b>$page</b>";
		if ($page < $numofpage) {
			$flag = 0;
			for ($i = $page + 1; $i <= $numofpage; $i++) {
				$pages .= "<a href=\"{$url}page=$i$mao\"{$ajaxurl}>$i</a>";
				$flag++;
				if ($flag == 4) break;
			}
		}
		$pages .= "<a href=\"{$url}page=$numofpage$mao\"{$ajaxurl}>&raquo;</a><div class=\"fl\">共{$total}页</div><span class=\"pagesone\"><input type=\"text\" size=\"3\"><button onclick=\"javascript: var page=(this.previousSibling.value>$total) ? $total : this.previousSibling.value; " . ($ajaxurl ? "$ajaxCallBack('{$url}page='+page);" : " location='{$url}page='+page+'{$mao}';") . " return false;\">Go</button></span></div>";
		return $pages;
	}
	
	/**
	 * 将二级评论和其回复进行排列，
	 * 这里需要将店主的三级回复能紧跟着该回复的二级评论下现实，并且三级回复只有一条的情况，进行排列
	 * 循环$childList，获得其子元素中的列表，如果该列表中的某条元素ID在$replyList中作为键值存在值的情况下（说明有回复），
	 * 则将这条回复跟在该条回复的后面，如果没有则跳过，跟上原先的后续列表
	 * @access private
	 * @param array $childList 二级评论（按时间顺序并且以根级评论的ID为节点）
	 * @param array $replyList 店主的回复评论（按照时间顺序并且以父级评论的ID为节点）
	 * @return array array('rootid'=>array(),..);返回已根评论ID为键的数组，并且该数组中顺序按照内容上连续的方式排序
	 */
	function _mergeReplyToChild($childList, $replyList) {
		foreach ($childList as $rootid => $child) {
			$_tmp = array();
			foreach ($child as $value) {
				$_tmp[] = $value;
				if ($replyList[$value['commentid']]) $_tmp[] = $replyList[$value['commentid']][0];
			}
			$childList[$rootid] = $_tmp;
		}
		return $childList;
	}
}