<?php
!defined('P_W') && exit('Forbidden');
/**
 * 商家导航商品DAO
 * @author L.IuHu.I @2010/8/24
 */
class PW_Dianpu_ProductsDB extends BaseDB {
	var $_tableName = 'pw_dianpu_products';
	var $_dianpuTableName = 'pw_dianpu_dianpuindex';
	var $_primaryKey = 'productid';
	
	/**
	 * 添加产品数据
	 * @param array $fieldData
	 * @return int
	 */
	function insert($fieldData) {
		$fieldData = $this->_checkAllowField($fieldData,$this->getStruct());
		return $this->_insert($fieldData);
	}
	
	/**
	 * 根据商品ID更新商品数据
	 * @param array $fieldData
	 * @param int $id
	 * @param int $objectId
	 * @return boolean
	 */
	function update($fieldData, $id, $objectId) {
		$fieldData = $this->_checkAllowField($fieldData,$this->getStruct());
		$id = intval($id);
		$objectId = intval($objectId);
		if ($objectId < 1 || !is_array($fieldData) || $id < 1) {return false;}
		$this->_db->update("UPDATE " . $this->_tableName . " SET " . $this->_getUpdateSqlString($fieldData) . " WHERE objectid= " . $this->_addSlashes($objectId) . " AND productid = " . $this->_addSlashes($id));
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据商品ID删除商品数据
	 * @param int $id
	 * @param int $objectId
	 * @return boolean
	 */
	function delete($id, $objectId) {
		$id = intval($id);
		$objectId = intval($objectId);
		if ($objectId < 1 || $id < 1) {return false;}
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE objectid= " . $this->_addSlashes($objectId) . " AND productid = " . $this->_addSlashes($id));
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据商品ID获得一条商品数据
	 * @param int $id
	 * @return array
	 */
	function get($id) {
		return $this->_get($id);
	}
	
	/**
	 * 获得商品列表总数
	 * @return int
	 */
	function count() {
		return $this->_count();
	}
	
	/**
	 * 获得某一页商品列表
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function gets($start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		if ($offset < 1) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据商品ID获得商品列表
	 * @param array $ids
	 * @return Array
	 */
	function getsByIds($ids) {
		if (!is_array($ids)) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE productid IN( " . $this->_getImplodeString($ids) . ") ");
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据店铺ID获得该店铺分页获取商品列表
	 * @param int $objectid
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function getsByObjectId($objectid, $start, $offset) {
		$objectid = intval($objectid);
		$start = intval($start);
		$offset = intval($offset);
		if ($objectid < 1 || $offset < 1) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid) . " ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据店铺ID获取店铺商品总数
	 * @param int $objectid
	 * @return int
	 */
	function countByObjectId($objectid) {
		$objectid = intval($objectid);
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid));
		return $result['total'];
	}
	
	/**
	 * 根据点击率排序获得商品分页列表
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function getsByProductWithHits($start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		if ($offset < 1) return false;
		$query = $this->_db->query("SELECT p.* FROM " . $this->_tableName . " p LEFT JOIN " . $this->_dianpuTableName . " d ON d.dianpuid=p.objectid WHERE d.state = 1 AND d.ifcheck = 1 AND  p.shelf = 1  ORDER BY p.hits DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据店铺ID分页获取已上架商品列表
	 * @param int $objectid
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function getsByObjectIdWithShelf($objectid, $start, $offset) {
		$objectid = intval($objectid);
		$start = intval($start);
		$offset = intval($offset);
		if ($objectid < 1 || $offset < 1) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid) . " AND shelf = 1  ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据店铺ID获取已商家商品总数
	 * @param int $objectid
	 * @return int
	 */
	function countByObjectIdWithShelf($objectid) {
		$objectid = intval($objectid);
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid) . " AND shelf = 1  ");
		return $result['total'];
	}
	
	/**
	 * 根据店铺ID分页获取已推荐商品列表
	 * @param int $objectid
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function getsByObjectIdWithRecommend($objectid, $start, $offset) {
		$objectid = intval($objectid);
		$start = intval($start);
		$offset = intval($offset);
		if ($objectid < 1 || $offset < 1) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid) . " AND recommend = 1 AND shelf = 1 ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据店铺ID获取已推荐商品数
	 * @param int $objectid
	 * @return int
	 */
	function countByObjectIdWithRecommend($objectid) {
		$objectid = intval($objectid);
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectid) . " AND recommend = 1  AND shelf = 1 ");
		return $result['total'];
	}
	
	/**
	 * 分页获取已经上架并被推荐的商品列表
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function getsWithRecommend($start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		if ($offset < 1) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE  recommend = 1 AND shelf = 1 ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 获得已上架并被推荐的商品数
	 * @return int
	 */
	function countWithRecommend() {
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE  recommend = 1  AND shelf = 1 ");
		return $result['total'];
	}
	
	/**
	 * 根据商品ID批量更新商品信息
	 * @param array $fieldData
	 * @param array $productIds
	 * @param int $objectId
	 * @return array
	 */
	function updates($fieldData, $productIds, $objectId) {
		$fieldData = $this->_checkAllowField($fieldData,$this->getStruct());
		$objectId = intval($objectId);
		if ($objectId < 1 || !is_array($fieldData) || !is_array($productIds)) {return false;}
		$this->_db->update("UPDATE " . $this->_tableName . " SET " . $this->_getUpdateSqlString($fieldData) . " WHERE objectid= " . $this->_addSlashes($objectId) . " AND productid IN (" . $this->_getImplodeString($productIds) . ")");
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据商品ID批量删除商品
	 * @param array $productIds
	 * @param int $objectId
	 * @return int
	 */
	function deletes($productIds, $objectId) {
		$objectId = intval($objectId);
		if ($objectId < 1 || !is_array($productIds)) {return false;}
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE objectid= " . $this->_addSlashes($objectId) . " AND productid IN (" . $this->_getImplodeString($productIds) . ")");
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据商品ID批量删除商品
	 * @param array $productIds
	 * @return int
	 */
	function deletesForAdmin($productIds) {
		if (!is_array($productIds)) {return false;}
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE productid IN (" . $this->_getImplodeString($productIds) . ")");
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据商品标题分页检索商品信息
	 * @param string $keyword
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function searchProductsByTitle($keyword, $start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		if ($keyword == '' || $offset < 1) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE title LIKE " . $this->_addSlashes("%" . $keyword . "%") . " ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据商品标题获得检索到商品总数
	 * @param string $keyword
	 * @return int
	 */
	function countProductsByTitle($keyword) {
		if ($keyword == '') {return false;}
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE title LIKE " . $this->_addSlashes("%" . $keyword . "%"));
		return $result['total'];
	}
	
	/**
	 * 根据店铺ID分页获取商品
	 * @param int $objectIds
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function getsByObjectIds($objectIds, $start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		if ($offset < 1 || !is_array($objectIds)) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE objectid IN( " . $this->_getImplodeString($objectIds) . ") ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据店铺ID获取检索到商品总数
	 * @param array $objectIds
	 * @return int
	 */
	function countByObjectIds($objectIds) {
		if (!is_array($objectIds)) {return false;}
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE objectid IN( " . $this->_getImplodeString($objectIds) . ")");
		return $result['total'];
	}
	
	/**
	 * 根据商品上下架情况以及商品标题分页检索商品
	 * @param int $objectid
	 * @param string $keyword
	 * @param array $shelfs
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function searchByShelfAndTitle($objectid, $keyword, $shelfs, $start, $offset) {
		$start = intval($start);
		$offset = intval($offset);
		$objectid = intval($objectid);
		if ($objectid < 1 || $keyword == '' || $offset < 1 || !is_array($shelfs)) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE title LIKE " . $this->_addSlashes("%" . $keyword . "%") . " AND shelf IN (" . $this->_getImplodeString($shelfs) . ") AND objectid = " . $this->_addSlashes($objectid) . " ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 获得根据商品上下架情况已经商品标题检索到数据总数
	 * @param int $objectid
	 * @param string $keyword
	 * @param array $shelfs
	 * @return int
	 */
	function countByShelfAndTitle($objectid, $keyword, $shelfs) {
		$objectid = intval($objectid);
		if ($objectid < 1 || $keyword == '' || !is_array($shelfs)) {return false;}
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE title LIKE " . $this->_addSlashes("%" . $keyword . "%") . " AND shelf IN (" . $this->_getImplodeString($shelfs) . ") AND objectid = " . $this->_addSlashes($objectid));
		return $result['total'];
	}
	
	/**
	 * 根据商品上下架情况分页检索商品列表
	 * @param int $objectid
	 * @param array $shelfs
	 * @param int $start
	 * @param int $offset
	 * @return array
	 */
	function searchByShelf($objectid, $shelfs, $start, $offset) {
		$objectid = intval($objectid);
		if (!is_array($shelfs) || $objectid < 1) {return false;}
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE shelf IN (" . $this->_getImplodeString($shelfs) . ") AND objectid = " . $this->_addSlashes($objectid) . "  ORDER BY createdtime DESC LIMIT " . $start . "," . $offset);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 获得根据商品上下架情况检索到的商品总数
	 * @param int $objectId
	 * @param array $shelfs
	 * @return int
	 */
	function countByObjectIdAndShelfs($objectId, $shelfs) {
		$objectId = intval($objectId);
		if ($objectId < 1 || !is_array($shelfs)) {return false;}
		$result = $this->_db->get_one("SELECT COUNT(*) as total FROM " . $this->_tableName . " WHERE objectid = " . $this->_addSlashes($objectId) . " AND shelf IN (" . $this->_getImplodeString($shelfs) . ")");
		return $result['total'];
	}
	
	/**
	 * 根据店铺ID随机获取一条商品信息
	 * @param array $objectIds
	 * @return array
	 */
	function getsByRand($objectIds) {
		if (!is_array($objectIds)) return false;
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE objectid in(" . $this->_getImplodeString($objectIds) . ") AND shelf = 1 AND recommend = 1 ORDER BY rand() DESC LIMIT 3");
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 获得商品数据结构数组
	 * @return array
	 */
	function getStruct() {
		return array('productid', 'objectid', 'title', 'description', 'recommend', 'market_price', 'member_price', 
			'shelf', 'photoid', 'createdtime', 'modifiedtime', 'hits');
	}

}