<?php
!defined('M_P') && exit('Forbidden');
/**
 * 商家导航店铺点击率DB层实现
 * @author yishuo
 */
class PW_Dianpu_DianpuhitsDB extends BaseDB {
	var $_tableName = "pw_dianpu_dianpuhits";
	var $_primaryKey = "id";
	
	/**
	 * 添加店铺点击率
	 * @param array $fieldData
	 * @return boolean
	 */
	function insert($fieldData) {
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_insert($fieldData);
	}
	
	/**
	 * 根据店铺ID获得店铺点击率
	 * @param int $id
	 * @return array
	 */
	function getHits($id) {
		if (!$id) return array();
		return $this->_get($id);
	}
	
	/**
	 * 根据店铺ID更新店铺点击率表
	 * @param int $id
	 * @return boolean
	 */
	function update($id) {
		$_sql = "UPDATE " . $this->_tableName . " SET hits = hits+1 WHERE id = " . $this->_addSlashes($id);
		return $this->_db->update($_sql);
	}
	
	/**
	 * 根据店铺ID删除店铺点击率
	 * @param int $id
	 * @return boolean
	 */
	function delete($id) {
		if (!$id) return false;
		return $this->_delete($id);
	}
	
	/**
	 * 获得店铺点击率表数据结构
	 * @return array
	 */
	function getStruct() {
		return array('id', 'hits');
	}
}

?>
