<?php
!defined('M_P') && exit('Forbidden');

/**
 * 商家导航店铺DB实现
 * @author yishuo
 */
class PW_Dianpu_DianpuDB extends BaseDB {
	var $_tableName = "pw_dianpu_dianpubase";
	var $_primaryKey = "dianpuid";
	var $_tableName_shangjia = "pw_dianpu_shangjia";
	var $_primaryKey_shangjia = "shangjiaid";
	var $_tableName_extend = "pw_dianpu_dianpuextend";
	var $_tableName_content = "pw_dianpu_dianpucontent";
	var $_primaryKey_content = "contentid";
	var $_tableName_index = "pw_dianpu_dianpuindex";
	var $_orderWrite = array('');
	
	/**
	 * 添加店铺信息
	 * @param array $fieldData
	 * @return int
	 */
	function insertDianpu($fieldData) {
		$fieldData = $this->_serializeData($fieldData);
		$_shangjiaid = $this->_insertShangjia($this->_getExtendTableData($fieldData, 'shangjia'));
		if (!$_shangjiaid) return false;
		$fieldData[$this->_primaryKey_shangjia] = $_shangjiaid;
		$_dianpuid = $this->_insertBase($this->_getExtendTableData($fieldData, 'base'));
		if (!$_dianpuid) return false;
		$fieldData[$this->_primaryKey] = $_dianpuid;
		$this->_insertExtend($this->_getExtendTableData($fieldData, 'extend'));
		$this->_insertIndex($this->_getExtendTableData($fieldData, 'index'));
		return $_dianpuid;
	}
	
	/**
	 * 根据店铺信息更新店铺
	 * @param array $fieldData
	 * @return boolean
	 */
	function updateDianpu($fieldData) {
		$fieldData = $this->_serializeData($fieldData);
		$this->_updateShangjia($this->_getExtendTableData($fieldData, 'shangjia'));
		$this->_updateBase($this->_getExtendTableData($fieldData, 'base'));
		$this->_updateExtend($this->_getExtendTableData($fieldData, 'extend'));
		$this->_updateIndex($this->_getExtendTableData($fieldData, 'index'));
		return true;
	}
	
	/**
	 * 批量设置店铺状态
	 * @param array $ids
	 * @param int $state (0/1) 
	 * @return int
	 */
	function stateDianpuMulit($ids, $state) {
		if (!is_array($ids) || empty($ids)) return false;
		$this->_db->update("UPDATE " . $this->_tableName . " SET state = " . $this->_addSlashes($state) . " WHERE " . $this->_primaryKey . " IN (" . pwImplode($ids) . ")");
		$this->_db->update("UPDATE " . $this->_tableName_index . " SET state = " . $this->_addSlashes($state) . " WHERE " . $this->_primaryKey . " IN (" . pwImplode($ids) . ")");
		return $this->_db->affected_rows();
	}
	
	/**
	 * 批量设置店铺审核通过
	 * @param array $ids
	 * @param int $ifcheck (0/1)
	 * @return int
	 */
	function checkDianpuMulit($ids, $ifcheck) {
		if (!is_array($ids) || empty($ids)) return false;
		$this->_db->update("UPDATE " . $this->_tableName . " SET ifcheck = " . $this->_addSlashes($ifcheck) . " WHERE " . $this->_primaryKey . " IN (" . pwImplode($ids) . ")");
		$this->_db->update("UPDATE " . $this->_tableName_index . " SET ifcheck = " . $this->_addSlashes($ifcheck) . " WHERE " . $this->_primaryKey . " IN (" . pwImplode($ids) . ")");
		return $this->_db->affected_rows();
	}
	
	/**
	 * 设置店铺点击率
	 * @param int $dianpuid
	 * @param int $num
	 * @return int
	 */
	function updateDianpuHits($dianpuid, $num) {
		if (!$num || !$dianpuid) return false;
		$this->_db->update("UPDATE " . $this->_tableName_index . " SET hit = " . $this->_addSlashes($num) . " WHERE  dianpuid = " . $this->_addSlashes($dianpuid));
		return $this->_db->affected_rows();
	}
	
	/**
	 * 批量设置店铺推荐已过期
	 * @param array $dianpuids
	 * @return boolean
	 */
	function updateDianpuOvertime($dianpuids) {
		if (!$dianpuids || !is_array($dianpuids)) return false;
		$this->_db->update("UPDATE " . $this->_tableName . " SET recommendlevel = '0' , overtime = '0' WHERE dianpuid IN (" . pwImplode($dianpuids) . ")");
		$this->_db->update("UPDATE " . $this->_tableName_index . " SET recommendlevel = '0' WHERE dianpuid IN (" . pwImplode($dianpuids) . ")");
		return true;
	}
	
	/**
	 * 移动店铺分类
	 * @param array $fieldData
	 * @return int
	 */
	function updateDianpuCategory($fieldData) {
		if (!is_array($fieldData) || empty($fieldData)) return false;
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct('index'));
		$_sql = "UPDATE " . $this->_tableName_index . " SET parentid = " . $this->_addSlashes($fieldData['parentid']) . " WHERE categoryid = " . $this->_addSlashes($fieldData['categoryid']);
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据分类统计店铺数
	 * 根据分类ID查询该分类下的店铺数
	 * @author xiaoxia.xu  2010-09-19
	 * 在后台删除分类的时候，需要先判断下该分类下是否已经存在有店铺，并且，该分类下的店铺状态不受限制
	 * @param int $categoryID 分类ID
	 * @return int total;
	 */
	function statDianpuByCategory($categoryID = 0) {
		$_condition = '';
		($categoryID == 0) ? $_condition = ' ' : $_condition = ' WHERE i.categoryid = ' . $this->_addSlashes($categoryID);
		$_sql = "SELECT i.categoryid,i.parentid,COUNT(*) as total FROM " . $this->_tableName_index . ' i ' . $_condition . ' GROUP BY i.categoryid';
		$_query = $this->_db->query($_sql);
		return $this->_getAllResultFromQuery($_query);
	}
	
	/**
	 * 根据用户信息获得店铺信息
	 * @param int $uid
	 */
	function getDianpu($uid) {
		if (empty($uid) || !is_numeric($uid)) return false;
		$_sql = "SELECT * FROM " . $this->_tableName_extend . " e LEFT JOIN " . $this->_tableName . " b ON e.dianpuid = b.dianpuid LEFT JOIN " . $this->_tableName_content . " c ON e.dianpuid = c.dianpuid WHERE e.uid = " . $this->_addSlashes($uid);
		$_tmp = $this->_db->get_one($_sql);
		return $this->_unserializeData($_tmp);
	}
	
	/**
	 * 根据商家ID获得商家信息
	 * @param int $shangjiaid
	 */
	function getShangjia($shangjiaid) {
		if (empty($shangjiaid) || !is_numeric($shangjiaid)) return false;
		$_sql = "SELECT * FROM " . $this->_tableName_shangjia . " WHERE shangjiaid = " . $this->_addSlashes($shangjiaid);
		$_tmp = $this->_db->get_one($_sql);
		return $_tmp;
	}
	
	/**
	 * 根据店铺ID获得店铺信息
	 * @param int $id
	 * @return array
	 */
	function getDianpuById($id) {
		if (empty($id) || !is_numeric($id)) return false;
		$_sql = "SELECT * FROM " . $this->_tableName . " b LEFT JOIN " . $this->_tableName_extend . " e ON e.dianpuid = b.dianpuid LEFT JOIN " . $this->_tableName_content . " c ON b.dianpuid = c.dianpuid LEFT JOIN " . $this->_tableName_index . " i ON b.dianpuid = i.dianpuid WHERE b.dianpuid = " . $this->_addSlashes($id);
		return $this->_unserializeData($this->_db->get_one($_sql));
	}
	
	/**
	 * 根据用户名获得店铺信息
	 * @param string $username
	 * @return string
	 */
	function getDianpuByUsername($username) {
		if (empty($username)) return false;
		$_sql = "SELECT * FROM " . $this->_tableName . " b LEFT JOIN " . $this->_tableName_extend . " e ON e.dianpuid = b.dianpuid LEFT JOIN " . $this->_tableName_content . " c ON b.dianpuid = c.dianpuid LEFT JOIN " . $this->_tableName_index . " i ON b.dianpuid = i.dianpuid WHERE e.username = " . $this->_addSlashes($username);
		return $this->_unserializeData($this->_db->get_one($_sql));
	}
	
	/**
	 * 店铺搜索
	 * @param array $conditons
	 * @param int $start
	 * @param int $perpage
	 * @param string $order
	 * @param array $result
	 * @return array:
	 */
	function search($conditons = array(), $start = 0, $perpage = 0, $order = '', $desc = 'DESC', $result = array()) {
		if ($order && !$this->_checkAllowFields($order)) return false;
		$_select = empty($result) ? "*" : $this->_getSelect($result);
		$_where = $this->_getConditions($conditons);
		$_limit = is_numeric($perpage) && $perpage > 0 && is_numeric($start) && $start >= 0 ? " LIMIT " . $start . "," . $perpage : "";
		$desc = in_array($desc, array('DESC', 'ASC')) ? $desc : 'DESC';
		$_order = empty($order) ? " ORDER BY b.dianpuid DESC " : " ORDER BY " . $this->_getAsName($order) . "." . $order . ' ' . $desc;
		$_sql = "SELECT " . $_select . " FROM " . $this->_tableName . " b LEFT JOIN " . $this->_tableName_extend . " e ON b.dianpuid = e.dianpuid LEFT JOIN " . $this->_tableName_index . " i ON i.dianpuid=b.dianpuid " . $_where . $_order . $_limit;
		$query = $this->_db->query($_sql);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 获得店铺检索总条数
	 * @param array $conditions
	 * @return int
	 */
	function count($conditions) {
		$_where = $this->_getConditions($conditions);
		$_sql = "SELECT COUNT(*) FROM " . $this->_tableName . " b LEFT JOIN " . $this->_tableName_extend . " e ON b.dianpuid = e.dianpuid LEFT JOIN " . $this->_tableName_index . " i ON i.dianpuid=b.dianpuid " . $_where;
		return $this->_db->get_value($_sql);
	}
	
	/**
	 * 根据索引表搜索店铺
	 * @param array $conditions
	 * @param int $start
	 * @param int $perpage
	 * @return array: (返回店铺id列表)
	 */
	function searchByIndex($conditions = array(), $order = '', $desc = 'DESC', $start = 0, $perpage = 0) {
		if ($order && !$this->_checkAllowFields($order)) return false;
		$_where = $this->_getConditions($conditions, 'index');
		$_limit = is_numeric($perpage) && $perpage > 0 && is_numeric($start) && $start >= 0 ? " LIMIT " . $start . "," . $perpage : "";
		$desc = in_array($desc, array('DESC', 'ASC')) ? $desc : 'DESC';
		$_order = empty($order) ? " ORDER BY i.modifytime DESC " : " ORDER BY i." . $order . " " . $desc;
		$_sql = "SELECT * FROM " . $this->_tableName_index . " i " . $_where . $_order . $_limit;
		$query = $this->_db->query($_sql);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据店铺索引表检索店铺总条数
	 * @param array $conditions
	 * @return int
	 */
	function searchByIndexCount($conditions) {
		$_where = $this->_getConditions($conditions, 'index');
		$_sql = "SELECT COUNT(*) FROM " . $this->_tableName_index . " i " . $_where;
		return $this->_db->get_value($_sql);
	}
	
	/**
	 * 随机获取一条推荐数据
	 * @param int $num 
	 * @param array $groups
	 * @return ArrayObject
	 */
	function searchByRandWithRecommend($num, $groups = array()) {
		if (!is_numeric($num) || !is_array($groups)) return false;
		$_sql = "SELECT i.dianpuid FROM " . $this->_tableName_index . " i WHERE i.ifcheck = '1' AND i.state = '1' AND i.recommendlevel != '0' AND i.groupid IN (" . pwImplode($groups) . ") ORDER BY rand() LIMIT " . $num;
		$query = $this->_db->query($_sql);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据店铺ID 查询店铺列表信息
	 * @param array $ids
	 * @return array
	 */
	function getDianpuListByIds($ids) {
		if (!is_array($ids) || empty($ids)) return false;
		$_sql = "SELECT * FROM " . $this->_tableName . " b LEFT JOIN " . $this->_tableName_extend . " e ON b.dianpuid = e.dianpuid WHERE e." . $this->_primaryKey . " IN (" . pwImplode($ids) . ")";
		$_query = $this->_db->query($_sql);
		return $this->_getAllResultFromQuery($_query);
	}
	
	/**
	 * 删除一条店铺(删除店铺，并不删除商家，删除商家的时候删除商家下面所有店铺)
	 * @param int $id
	 * @return boolean
	 */
	function deleteDianpu($id) {
		$this->_deleteBase($id);
		$this->_deleteExtend($id);
		$this->_deleteContent($id);
		$this->_deleteIndex($id);
		return true;
	}
	
	/**
	 * 根据店铺ID批量删除店铺
	 * @param array $ids
	 * @return boolean
	 */
	function deleteDianpuMulit($ids) {
		$this->_deleteBaseMulti($ids);
		$this->_deleteExtendMulit($ids);
		$this->_deleteContentMulit($ids);
		$this->_deleteIndexMulit($ids);
		return true;
	}
	
	/**
	 * 删除商家(删除商家并删除商家的店铺)
	 * @param int $shangjiaid
	 * @param int $dianpuid
	 * @return boolean
	 */
	function deleteShangjia($shangjiaid, $dianpuid) {
		$this->_deleteShangjia($shangjiaid);
		return $this->deleteDianpu($dianpuid);
	}
	
	/**
	 * 添加店铺基本信息表
	 * @param $fieldData
	 * @return int
	 */
	function _insertBase($fieldData) {
		if (!$fieldData = $this->_checkAllowField($fieldData, $this->getStruct('base'))) return false;
		return $this->_insert($fieldData);
	}
	
	/**
	 * 更新店铺基本表
	 * @param array $fieldData
	 * @return int
	 */
	function _updateBase($fieldData) {
		if (!$fieldData[$this->_primaryKey]) return false;
		if (!$fieldData = $this->_checkAllowField($fieldData, $this->getStruct('base'))) return false;
		return $this->_update($fieldData, $fieldData[$this->_primaryKey]);
	}
	
	/**
	 * 删除店铺基本表
	 * @param int $id
	 * @return int
	 */
	function _deleteBase($id) {
		return $this->_delete($id);
	}
	
	/**
	 * 批量删除店铺基本表
	 * @param array $ids
	 * @return int
	 */
	function _deleteBaseMulti($ids) {
		if (!is_array($ids)) return false;
		$_sql = "DELETE FROM " . $this->_tableName . " WHERE " . $this->_primaryKey . " IN (" . pwImplode($ids) . ") ";
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 添加店铺扩展信息
	 * @param array $fieldData
	 * @return int
	 */
	function _insertExtend($fieldData) {
		if (!$fieldData = $this->_checkAllowField($fieldData, $this->getStruct('extend'))) return false;
		$_sql = "INSERT INTO " . $this->_tableName_extend . " SET " . $this->_getUpdateSqlString($fieldData);
		$this->_db->update($_sql);
		return $this->_db->insert_id();
	}
	
	/**
	 * 更新店铺扩展信息
	 * @param array $fieldData
	 * @return int
	 */
	function _updateExtend($fieldData) {
		if (!$fieldData[$this->_primaryKey]) return false;
		if (!$fieldData = $this->_checkAllowField($fieldData, $this->getStruct('extend'))) return false;
		$_sql = "UPDATE " . $this->_tableName_extend . " SET " . $this->_getUpdateSqlString($fieldData) . " WHERE " . $this->_primaryKey . " = " . $fieldData[$this->_primaryKey];
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据店铺ID删除店铺扩展信息
	 * @param int $id (店铺ID)
	 * @return int
	 */
	function _deleteExtend($id) {
		if (empty($id)) return false;
		$_sql = "DELETE FROM " . $this->_tableName_extend . " WHERE " . $this->_primaryKey . " = " . $this->_addSlashes($id);
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据店铺ID批量删除店铺扩展信息
	 * @param array $ids (店铺ID的数组)
	 * @return int
	 */
	function _deleteExtendMulit($ids) {
		if (!is_array($ids) || empty($ids)) return false;
		$_sql = "DELETE FROM " . $this->_tableName_extend . " WHERE " . $this->_primaryKey . " IN (" . pwImplode($ids) . ") ";
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 添加一条店铺内容信息
	 * @param array $fieldData
	 * @return int
	 */
	function insertContent($fieldData) {
		$fieldData = $this->_getExtendTableData($fieldData, 'content');
		$_sql = "INSERT INTO " . $this->_tableName_content . " SET " . $this->_getUpdateSqlString($fieldData);
		$this->_db->update($_sql);
		return $this->_db->insert_id();
	}
	
	/**
	 * 根据内容ID更新店铺内容信息表
	 * @param array $fieldData
	 * @param int $contentid
	 * @return boolean
	 */
	function updateContent($fieldData, $contentid) {
		$fieldData = $this->_getExtendTableData($fieldData, 'content');
		if (!$contentid) return false;
		$_sql = "UPDATE " . $this->_tableName_content . " SET " . $this->_getUpdateSqlString($fieldData) . " WHERE " . $this->_primaryKey_content . " = " . $this->_addSlashes($contentid);
		$this->_db->update($_sql);
		return true;
	}
	
	/**
	 * 根据店铺内容ID删除内容
	 * @param int $cid
	 * @return boolean
	 */
	function deleteContent($cid) {
		if (empty($cid)) return false;
		$_sql = "DELETE FROM " . $this->_tableName_content . " WHERE " . $this->_primaryKey_content . " = " . $this->_addSlashes($cid);
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据店铺内容ID批量删除店铺内容
	 * @param array $cids
	 * @return boolean
	 */
	function deleteContents($cids) {
		if (empty($cids)) return false;
		$_sql = "DELETE FROM " . $this->_tableName_content . " WHERE " . $this->_primaryKey_content . " IN (" . pwImplode($cids) . ")";
		$this->_db->update($_sql);
		return true;
	}
	
	/**
	 * 根据店铺ID获得店铺内容
	 * @param int $did
	 * @return array
	 */
	function getDianpuContents($did) {
		if (empty($did)) return false;
		$_sql = "SELECT * FROM " . $this->_tableName_content . " WHERE " . $this->_primaryKey . " = " . $this->_addSlashes($did);
		$query = $this->_db->query($_sql);
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据内容ID获取店铺内容
	 * @param array $cid
	 * @return array
	 */
	function getDianpuContent($cid) {
		if (empty($cid)) return false;
		$_sql = "SELECT * FROM " . $this->_tableName_content . " WHERE " . $this->_primaryKey_content . " = " . $this->_addSlashes($cid);
		return $this->_db->get_one($_sql);
	}
	
	/**
	 * 根据店铺内容ID删除店铺内容
	 * @param int $cid (店铺内容ID)
	 * @return int
	 */
	function deleteContentByCid($cid) {
		if (empty($cid)) return false;
		$_sql = "DELETE FROM " . $this->_tableName_content . " WHERE " . $this->_primaryKey_content . " = " . $this->_addSlashes($cid);
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据店铺ID删除店铺内容
	 * @param int $id (店铺ID)
	 * @return int
	 */
	function _deleteContent($id) {
		if (empty($id)) return false;
		$_sql = "DELETE FROM " . $this->_tableName_content . " WHERE " . $this->_primaryKey . " = " . $this->_addSlashes($id);
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据店铺ID批量删除店铺内容
	 * @param array $ids  (店铺ID数组)
	 * @return int
	 */
	function _deleteContentMulit($ids) {
		if (!is_array($ids) || empty($ids)) return false;
		$_sql = "DELETE FROM " . $this->_tableName_content . " WHERE " . $this->_primaryKey . " IN (" . pwImplode($ids) . ")";
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 添加商家信息
	 * @param array $fieldData
	 * @return int
	 */
	function _insertShangjia($fieldData) {
		if (!$fieldData = $this->_checkAllowField($fieldData, $this->getStruct('shangjia'))) return false;
		$_sql = "INSERT INTO " . $this->_tableName_shangjia . " SET " . $this->_getUpdateSqlString($fieldData);
		$this->_db->update($_sql);
		return $this->_db->insert_id();
	}
	
	/**
	 * 更新商家信息
	 * @param array $fieldData
	 * @return int
	 */
	function _updateShangjia($fieldData) {
		if (!$fieldData[$this->_primaryKey_shangjia]) return false;
		if (!$fieldData = $this->_checkAllowField($fieldData, $this->getStruct('shangjia'))) return false;
		$_sql = "UPDATE " . $this->_tableName_shangjia . " SET " . $this->_getUpdateSqlString($fieldData) . " WHERE " . $this->_primaryKey_shangjia . " = " . $this->_addSlashes($fieldData[$this->_primaryKey_shangjia]);
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据商家ID删除商家信息
	 * @param int $id
	 * @return int
	 */
	function _deleteShangjia($id) {
		if (empty($id)) return false;
		$_sql = "DELETE FROM " . $this->_tableName_shangjia . " WHERE " . $this->_primaryKey_shangjia . " = " . $this->_addSlashes($id);
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据商家ID批量删除商家信息
	 * @param array $ids
	 * @return int
	 */
	function _deleteShangjiaMulit($ids) {
		if (!is_array($ids) || empty($ids)) return false;
		$_sql = "DELETE FROM " . $this->_tableName_shangjia . " WHERE " . $this->_primaryKey_shangjia . " = " . pwImplode($ids);
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 添加店铺索引信息表
	 * @param array $fieldData
	 * @return int
	 */
	function _insertIndex($fieldData) {
		if (!$fieldData = $this->_checkAllowField($fieldData, $this->getStruct('index'))) return false;
		$_sql = "INSERT INTO " . $this->_tableName_index . " SET " . $this->_getUpdateSqlString($fieldData);
		$this->_db->update($_sql);
		return $this->_db->insert_id();
	}
	
	/**
	 * 更新店铺索引表信息
	 * @param array $fieldData
	 * @return int
	 */
	function _updateIndex($fieldData) {
		if (!$fieldData[$this->_primaryKey]) return false;
		if (!$fieldData = $this->_checkAllowField($fieldData, $this->getStruct('index'))) return false;
		$_sql = "UPDATE " . $this->_tableName_index . " SET " . $this->_getUpdateSqlString($fieldData) . " WHERE " . $this->_primaryKey . " = " . $this->_addSlashes($fieldData[$this->_primaryKey]);
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据店铺ID删除店铺索引
	 * @param int $id (店铺ID)
	 * @return int
	 */
	function _deleteIndex($id) {
		if (empty($id)) return false;
		$_sql = "DELETE FROM " . $this->_tableName_index . " WHERE " . $this->_primaryKey . " = " . $this->_addSlashes($id);
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据店铺ID批量删除店铺索引
	 * @param array $ids
	 * @return int
	 */
	function _deleteIndexMulit($ids) {
		if (!is_array($ids) || empty($ids)) return false;
		$_sql = "DELETE FROM " . $this->_tableName_index . " WHERE " . $this->_primaryKey . " IN (" . pwImplode($ids) . ")";
		$this->_db->update($_sql);
		return $this->_db->affected_rows();
	}
	
	/**
	 * 根据类型获得店铺分表数据
	 * @param array $fieldData
	 * @param string $type ('content' / 'extend' / 'base' / 'shangjia' / 'index')
	 * @return array
	 */
	function _getExtendTableData($fieldData, $type) {
		if (!is_array($fieldData) || empty($fieldData)) return false;
		$_struct = $this->getStruct($type);
		if (!is_array($_struct) || empty($_struct)) return false;
		$_data = array();
		foreach ($fieldData as $key => $value) {
			if (in_array($key, $_struct) && !is_null($value)) $_data[$key] = $value;
		}
		return $_data;
	}
	
	/**
	 * 获得数据表引用名称（引用名称为类型名称的首字母）
	 * @param string $field (字段名称)
	 * @param string $type (字段类型)
	 * @return string
	 */
	function _getAsName($field, $type = '') {
		if ($type) {
			if (in_array($field, $this->getStruct($type))) return substr($type, 0, 1);
		} else {
			if (in_array($field, $this->getStruct('base'))) return 'b';
			if (in_array($field, $this->getStruct('extend'))) return 'e';
			if (in_array($field, $this->getStruct('content'))) return 'c';
			if (in_array($field, $this->getStruct('index'))) return 'i';
			if (in_array($field, $this->getStruct('shangjia'))) return 's';
		}
	}
	
	/**
	 * 获得检索表时的查找字段
	 * @param array $result
	 * @return string
	 */
	function _getSelect($result) {
		$_tmp = '';
		foreach ($result as $value) {
			if ($as = $this->_getAsName($value)) $_tmp .= $as . "." . $value . ", ";
		}
		return trim($_tmp, ', ');
	}
	
	/**
	 * 用于店铺检索的条件解析方法
	 * @param array $conditions
	 * @param string $type
	 * @return string
	 */
	function _getConditions($conditions, $type = '') {
		$_where = "";
		if (!is_array($conditions) || empty($conditions)) return $_where;
		$_where .= " WHERE 1 = 1 AND ";
		foreach ($conditions as $key => $value) {
			$_where .= $this->_getConditionsValue($value, $key, $type);
		}
		return trim($_where, 'AND ');
	}
	
	/**
	 * 用于店铺检索的条件解析方法
	 * @param array $values
	 * @param string $key
	 * @param string $type
	 * @return string
	 */
	function _getConditionsValue($values, $key = '', $type = '') {
		$_result = '';
		$_mapping = array("eq" => "=", "like" => "LIKE", "neq" => "!=", "in" => "IN");
		if ($values && is_array($values) && !is_array($values[0])) $values = array($values);
		foreach ((array) $values as $k => $value) {
			if ($_mapping[$value[1]] && $_mapping[$value[1]] == "LIKE") {
				$value[0] = $this->_addSlashes("%" . $value[0] . "%");
			} elseif ($_mapping[$value[1]] && $_mapping[$value[1]] == "IN" && is_array($value[0])) {
				$value[0] = "(" . pwImplode($value[0]) . ")";
			} else {
				$value[0] = $this->_addSlashes($value[0]);
			}
			$_result .= $this->_getAsName($key, $type) . "." . $key . " " . $_mapping[$value[1]] . " " . $value[0] . " AND ";
		}
		return $_result;
	}
	
	/**
	 * 过滤出合法的数据表字段
	 * @param array $fieldData
	 * @param array $allowFields
	 * @return array
	 */
	function _checkAllowField($fieldData, $allowFields) {
		if (!$fieldData || empty($fieldData) || empty($allowFields)) return false;
		return parent::_checkAllowField($fieldData, $allowFields);
	}
	
	/**
	 * 检查店铺数据表字段白名单
	 * @param array $field
	 * @return boolean
	 */
	function _checkAllowFields($field) {
		return in_array($field, $this->getStruct());
	}
	
	/**
	 * 序列化数据值
	 * @param array $data
	 * @return array
	 */
	function _serializeData($data) {
		if (is_array($data) && $data['contentorder']) $data['contentorder'] = $this->_serialize($data['contentorder']);
		return $data;
	}
	
	/**
	 * 反序列化数据值
	 * @param array $data
	 * @return array
	 */
	function _unserializeData($data) {
		if (is_array($data) && $data['contentorder']) $data['contentorder'] = $this->_unserialize($data['contentorder']);
		return $data;
	}
	
	/**
	 * 根据类型获得数据结构
	 * @param string $type
	 * @return array
	 */
	function getStruct($type = '') {
		$_struct['content'] = array('contentid', 'dianpuid', 'titles', 'contents');
		$_struct['extend'] = array('dianpuid', 'uid', 'username', 'url', 'areaid', 'categoryid', 'operator', 
			'operatorphone', 'groupid', 'businfo', 'tempstyle', 'contentorder');
		$_struct['base'] = array('dianpuid', 'shangjiaid', 'title', 'state', 'ifcheck', 'checkway', 'checktime', 
			'address', 'qq', 'msn', 'wangwang', 'email', 'phone', 'map_x', 'map_y', 'map_z', 'logo', 'bulletin', 
			'recommendlevel', 'ifattach', 'createtime', 'modifytime', 'overtime');
		$_struct['shangjia'] = array('shangjiaid', 'uid', 'username', 'company', 'delegate', 'delegatephone', 
			'companyaddress', 'companyphone', 'companyfax', 'companyzipcode', 'createtime');
		$_struct['index'] = array('dianpuid', 'title', 'state', 'areaid', 'categoryid', 'parentid', 'groupid', 
			'ifcheck', 'checkway', 'recommendlevel', 'modifytime', 'hit');
		return empty($type) && !in_array($type, $_struct) ? array_unique(array_merge($_struct['index'], $_struct['content'], $_struct['extend'], $_struct['base'], $_struct['shangjia'])) : $_struct[$type];
	}
}

?>
