<?php
!defined('M_P') && exit('Forbidden');
/**
 * 用户评论根级评论DB实现
 * @author xiaoxia.xuxx
 */
class PW_Dianpu_CommentsDB extends BaseDB {
	var $_tableName = 'pw_dianpu_comments';
	var $_primaryKey = 'commentid';
	
	/**
	 * 插入根级评论信息
	 * 将一级评论信息，插入到表pw_dianpu_comments表中
	 * @param array $fieldData 待插入的评论信息
	 * @return integer 返回插入的ID
	 */
	function insert($fieldData) {
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_insert($fieldData);
	}
	
	/** 后台根据评论ID删除一级评论信息
	 * @param array $commentid  评论的ID
	 * @return integer 返回删除影响到的记录数
	 */
	function delForAdmin($commentid) {
		if (!$commentid) return false;
		return $this->_delete($commentid);
	}
	
	/**
	 * 后台批量删除多个评论信息
	 * @param array $commentid 评论ID列表
	 * @return integer 返回删除的影响记录数
	 */
	function delsForAdmin($commentid) {
		if (!$commentid) return false;
		if (!S::isArray($commentid)) $commentid = array($commentid);
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE commentid IN (" . $this->_getImplodeString($commentid) . ")");
	    return $this->_db->affected_rows();
	}

	/**
	 * 根据评论ID和店铺ID删除一级评论信息
	 * @param array $commentid  评论的ID
	 * @param integer $objectid 店铺ID（或者是对象ID）
	 * @return integer 返回删除影响到的记录数
	 */
	function delete($commentid, $objectid) {
		if (!$commentid || !$objectid) return false;
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE commentid =" . $this->_addSlashes($commentid) . " AND objectid=" . $this->_addSlashes($objectid));
	    return $this->_db->affected_rows();
	}
	
	/**
	 * 批量删除多个评论信息，需要传入该条评论的店铺ID或者是对象ID
	 * @param array $commentid 评论ID列表
	 * @param integer $objectid 店铺ID（或者是对象ID）
	 * @return integer 返回删除的影响记录数
	 */
	function deletes($commentid, $objectid) {
		if (!$commentid || !$objectid) return false;
		if (!S::isArray($commentid)) $commentid = array($commentid);
		$this->_db->update("DELETE FROM " . $this->_tableName . " WHERE commentid IN (" . $this->_getImplodeString($commentid) . ") AND objectid=" . $this->_addSlashes($objectid));
	    return $this->_db->affected_rows();
	}
	
	/**
	 * 从输入的评论ID中过滤出所有根级评论ID
	 * 当删除多条评论的时候，根据$CommentIDs来级联的删除其余下级的评论,过滤出根级评论ID
	 * 为了完全删除其级下的所有相关评论，需要先查找出所有相关的评论ID
	 * 此处为确认所有被删除ID中根级的ID列表
	 * @param array $commentID 需要筛选的评论的ID列表
	 * @param array array(array('commentid'),array('commentid')...)返回符合的ID列表
	 */
	function filterDeleteRootID($commentIDs) {
		if (!$commentIDs) return false;
		if (!S::isArray($commentIDs)) $commentIDs = array($commentIDs);
		$query = $this->_db->query("SELECT commentid FROM " . $this->_tableName . ' WHERE commentid IN (' . $this->_getImplodeString($commentIDs) . ')');
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 获得的是pw_dianpu_comments的数据库表结构
	 * @return array 返回数据库表的数据结构
	 */
	function getStruct() {
		return array('commentid', 'objectid', 'typeid', 'postdate');
	}
}
?>
	
	