<?php
!defined('P_W') && exit('Forbidden');
/**
 * 商家导航-行业分类表
 * @author liuhui@2010-09-30
 *
 */
class PW_Dianpu_categoriesDB extends BaseDB {
	var $_tableName = 'pw_dianpu_categories';
	var $_primaryKey = 'categoryid';
	
	/**
	 * 插入数据
	 * @param array $fieldData
	 * @return integer
	 */
	function insert($fieldData) {
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_insert($fieldData);
	}
	
	/**
	 * 更新数据
	 * @param array $fieldData
	 * @param int $id
	 * @return integer
	 */
	function update($fieldData, $id) {
		if (!is_array($fieldData) || !is_numeric($id)) return false;
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		return $this->_update($fieldData, $id);
	}
	
	/**
	 * 删除数据
	 * @param int $id
	 * @return integer
	 */
	function delete($id) {
		if (!is_numeric($id)) return false;
		return $this->_delete($id);
	}
	
	/**
	 * 根据分类ID查询一条分类信息
	 * @param int $id
	 * @return array
	 */
	function get($id) {
		if (!is_numeric($id)) return false;
		return $this->_get($id);
	}
	
	/**
	 * 获得数据条数
	 * @return int
	 */
	function count() {
		return $this->_count();
	}
	
	/**
	 * 根据父ID更新所有分类数据
	 * @param array $fieldData
	 * @param int $parentId
	 * @return string
	 */
	function updateByParentId($fieldData, $parentId) {
		$parentId = intval($parentId);
		$fieldData = $this->_checkAllowField($fieldData, $this->getStruct());
		if (!is_array($fieldData) || $parentId < 1) return false;
		$this->_db->update("UPDATE " . $this->_tableName . " SET " . $this->_getUpdateSqlString($fieldData) . " WHERE parentid = " . $this->_addSlashes($parentId));
		return $this->_db->affected_rows();
	}
	
	/**
	 * 添加分类数据
	 * @param array $fieldDatas
	 * @param int
	 */
	function addCategories($fieldDatas) {
		$this->_db->update("INSERT INTO " . $this->_tableName . " (parentid,name,sort,createdtime) VALUES  " . pwSqlMulti($fieldDatas, FALSE));
		return $this->_db->insert_id();
	}
	
	/**
	 * 获得所有店铺分类数据
	 * @return array
	 */
	function gets() {
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " ORDER BY sort ASC");
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 根据分类父ID获得全部子分类
	 * @param int $parentId
	 * @return array
	 */
	function getsByParentid($parentId) {
		$parentId = intval($parentId);
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE parentid = " . $this->_addSlashes($parentId) . " ORDER BY sort ASC");
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * 获得数据库的结构
	 * @return array 返回数据库表的数据结构
	 */
	function getStruct() {
		return array('categoryid', 'parentid', 'name', 'sort', 'createdtime');
	}
}