<?php
!defined('P_W') && exit('Forbidden');
L::loadClass('upload', '', false);
/**
 * CSV文件上传实现
 * @author qiong
 *
 */
class PW_CsvUpload extends uploadBehavior {
	
	var $db;
	var $uid;
	var $ifftp;
	var $pathname;
	
	function PW_CsvUpload() {
		$this->__construct();
	}
	
	function __construct() {
		global $db, $db_ifftp;
		parent::uploadBehavior();
		$maxfilesize = 4000;
		$this->db = & $db;
		$this->ifftp = $db_ifftp;
		$this->ftype = array('csv' => $maxfilesize);
	}
	
	/* (non-PHPdoc)
	 * @see lib/uploadBehavior#allowType()
	 */
	function allowType($key) {
		return true;
	}
	
	/* (non-PHPdoc)
	 * @see lib/uploadBehavior#getFilePath()
	 */
	function getFilePath($currUpload) {
		$_str = randstr(20);
		$filename = $_str . '_dianpucsv.' . $currUpload['ext'];
		$savedir = 'csv/';
		$this->pathname = $this->getServerPath($filename, $savedir);
		return array($filename, $savedir, '', '');
	}
	
	/**
	 * 获得文件临时存放路径
	 * @param string $filename
	 * @param string $dir
	 * @return string
	 */
	function getServerPath($filename, $dir) {
		global $attachdir;
		if ($this->ifftp) {
			$source = D_P . "data/tmp/{$filename}";
		} else {
			$source = $attachdir . '/' . $dir . $filename;
		}
		return $source;
	}

}
?>