//全局变量
var clickPointIds = new Array();
//初始化地图
var mapObj=null;
function  mapInit(mapPointObj) {
  var mapoption = new MMapOptions();  
  mapoption.zoom = mapPointObj.mapZoom;	//设置地图zoom级别  
  mapoption.center=new MLngLat(mapPointObj.point_x,mapPointObj.point_y);  
  mapoption.toolbar=ROUND;	//设置工具条  
  mapoption.toolbarPos=new MPoint(20,20);	//设置工具条位置  
  mapoption.scale = DEFAULT;
  mapoption.overviewMap = SHOW;
  mapoption.mapComButton = HIDE; 
  if (mapObj == null || mapObj == 'undefined' || mapObj == '') {
	  mapObj = new MMap(mapPointObj.mapPane, mapoption);	//地图初始化 
  }
  mapObj.addEventListener(mapObj,MAP_READY,function(){
	  changeMapState(mapPointObj);
	  drawPointOnMap(mapPointObj);
  });
}

function changeMapState(mapPointObj){
  /*工具条*/
  if (mapPointObj.toolbarMap == 'show') {
	mapObj.setCtrlPanelState(TOOLBAR_CTRL,SHOW);
  }else{
	mapObj.setCtrlPanelState(TOOLBAR_CTRL,HIDE);
  }
  
  /*比例尺*/
  if (mapPointObj.scaleMap == 'show') {
  	mapObj.setCtrlPanelState(SCALE_CTRL,SHOW);
  } else {
  	mapObj.setCtrlPanelState(SCALE_CTRL,HIDE);
  }
  
  /*鹰眼*/
  if (mapPointObj.overviewMap == 'show') {
  	mapObj.setCtrlPanelState(OVERVIEW_CTRL,SHOW);
  } else {
  	mapObj.setCtrlPanelState(OVERVIEW_CTRL,HIDE);
  }
}

function panToCenter(x,y,pointId) {  
	if (mapObj != null && mapObj != 'undefined' && mapObj != '') {
		mapObj.panTo(new MLngLat(x, y));  
		mapObj.setOverlayToTopById(pointId);
	}  
}

function addLabel(text,x,y) {
  var labelOptions=new MLabelOptions();  
  var fontstyle = new MFontStyle();  //定义字体风格对象  
  fontstyle.name ="Arial";  
  fontstyle.size = 12;  
  fontstyle.color = 0x75381c;  
  fontstyle.bold = false;  
  labelOptions.fontStyle=fontstyle;  
  labelOptions.borderColor =0xd1a874;
  labelOptions.content= ' ' + text + ' ';  
  labelOptions.hasBorder =true;  
  labelOptions.hasBackground =true;  
  labelOptions.backgroundColor  =0xfffee9;  
  var label=new MLabel(new MLngLat(x,y),labelOptions);  
  mapObj.addOverlay(label,true);  
}

//改变地图状态，如果地图未初始化则从新初始化
function changeMap(mapPointObj){
	if (mapObj == null) {
	  mapObj = new MMap("map", mapoption); 									//地图初始化 
	  mapInit(mapPointObj);
  	}else{
	  mapObj.setZoomAndCenter(mapPointObj.mapZoom,new MLngLat(mapPointObj.point_x,mapPointObj.point_y));
	  drawPointOnMap(mapPointObj);
	  clickPointIds.push(marker.id);
  	}
}

//事件处理
/*
 * 鼠标点击地图事件触发该方法
 * 后台描点
 * */
function clickMouse(param){
	/* 设置描点坐标 */
	getPointPosition(param);
	
	/* 删除其他描点 */
	clearPointsByIds(clickPointIds);
	
	/* 创建point对象 */
	var mapPointObj = new mapPoint();
	mapPointObj.point_x = param.eventX;
	mapPointObj.point_y = param.eventY;
	mapPointObj.showTip = false;
	mapPointObj.canMove = true;
	mapPointObj.pointMoveEventCallBack = getPointPosition;
	
	drawPointOnMap(mapPointObj);
	/* 记录点信息 */
	clickPointIds.push(marker.id);
}

function getPointPosition(param) {
	var point_x = document.getElementById("point_x");
	var point_y = document.getElementById("point_y");
	var mapZoom = document.getElementById("mapZoom");
	point_x.value =  param.eventX;
	point_y.value =  param.eventY;
	mapZoom.value = mapObj.getZoomLevel();
};

//根据坐标点信息在地图上绘制一个点,并且显示出来
var marker;
var markerOptions;
function drawPointOnMap(mapPointObj){
	markerOptions = new MMarkerOptions();  
    markerOptions.isDraggable = mapPointObj.canMove;	//是否可以拖动
    markerOptions.canShowTip = mapPointObj.showTip;
    if (mapPointObj.pointRotation != '' && mapPointObj.pointRotation != null && mapPointObj.pointRotation != 'undefined') {
    	markerOptions.rotation = mapPointObj.pointRotation;
    }
    if (mapPointObj.pointImageURL != '' && mapPointObj.pointImageURL != null && mapPointObj.pointImageURL != 'undefined') {
	    markerOptions.imageUrl = mapPointObj.pointImageURL;
    }

    var tipOption = new MTipOptions();	//定义tip内容
	tipOption.title = mapPointObj.pointTitle;
	tipOption.tipType = HTML_BUBBLE_TIP;
	tipOption.content = mapPointObj.pointTip;
	
	var mfillstyle = new MFillStyle();	//定义填充类
	mfillstyle.color = 0x005cb5;  
	mfillstyle.alpha = 1;
	tipOption.titleFillStyle = mfillstyle;  

	var linestyle = new MLineStyle();  
    linestyle.thickness = 3;  
    linestyle.alpha = 1;  
    tipOption.borderStyle = linestyle; 
    markerOptions.tipOption = tipOption;  
    markerOptions.labelStyle.color = 0xffffff;
    markerOptions.imageAlign=5
    
    if (mapPointObj.showLaber) {
    	markerOptions.labelAlign = TOP_CENTER;
		markerOptions.labelOption = drawPointLable(mapPointObj.pointLaber);
    }
	
	marker = new MMarker(new MLngLat(mapPointObj.point_x, mapPointObj.point_y),markerOptions);
	if (mapPointObj.pointMoveEventCallBack != '' && mapPointObj.pointMoveEventCallBack != null && mapPointObj != 'undefined') {
		mapObj.addEventListener(marker,DRAG_END,mapPointObj.pointMoveEventCallBack);
	}
	
	if (mapPointObj.pointId != '' && mapPointObj.pointId != null && mapPointObj.pointId != 'undefined') {
		marker.id = mapPointObj.pointId;
	}
	
	if (mapPointObj.showPointDelay == false) {
		mapObj.addOverlay(marker,false);
		if (mapPointObj.showTip == "show" || mapPointObj.showTip == true) {
			mapObj.openOverlayTip(marker.id);
		}
	}
}

function drawPointLable(text){
  var labelOptions=new MLabelOptions();  
  var fontstyle = new MFontStyle();  //定义字体风格对象  
  fontstyle.name ="Arial";  
  fontstyle.size = 12;  
  fontstyle.color = 0x75381c;  
  fontstyle.bold = false;  
  labelOptions.fontStyle=fontstyle;  
  labelOptions.borderColor =0xd1a874;  
  labelOptions.content= ' ' + text + ' ';  
  labelOptions.hasBorder = true;  
  labelOptions.hasBackground = true;  
  labelOptions.backgroundColor  =0xfffee9;  
  return labelOptions;
}

//定义Map相关配置信息
function mapConfig () {
	/* MAP 相关 */
	this.mapZoom = 12;
	this.showTip = 'show';
	this.overviewMap = 'show';
	this.toolbarMap = 'show';
	this.scaleMap = 'show';
	this.mapPane = 'map';
}

//定义Point类 属性定义
function mapPoint () {
	this.point_x = 0;
	this.point_y = 0;
	this.pointTip = '描述信息';
	this.pointTitle = '标题信息';
	this.pointId;
	this.showPointDelay = false;
	this.canMove = false;			//true  false
	this.pointMoveEventCallBack = '';
	this.showLaber = false;
	this.pointLaber = '';
	
	/* 定义点样式 */
	this.pointImageURL = "http://code.mapabc.com/images/lan_1.png";			//定义点图片
	this.pointRotation = '';			//定义点的角度，区别不同类型的点
	
	/* MAP 相关 */
	this.mapZoom = 12;
	this.showTip = 'show';
	this.overviewMap = 'show';
	this.toolbarMap = 'show';
	this.scaleMap = 'show';
	this.mapPane = 'map';
}

mapPoint.prototype = {
	setPoints : function(x,y,mzoom,mlaber,mtitle){
		this.point_x = x;
		this.point_y = y;
		this.mapZoom = mzoom;
		this.pointLaber = mlaber;
		this.pointTitle = mtitle;
	},
	setMapZoom : function(mzoom){
		this.mapZoom = mzoom;
	},
	setMapLaber : function(mlaber){
		this.mapLaber = mlaber;
	}
}


/* Utility Methods For HouseMap */

/*
 * 清除所有搜索结果点
 * */
function clearAllSearchResultPoints(){
	mapObj.removeOverlays(searchResults);
}

/*
 * 显示地图点的Tip标签
 * */
function showMapPointTip(pointId){
	mapObj.openOverlayTip(pointId);
	mapObj.setOverlayToTopById(pointId);
}
/* 清除地图上所有参数传递的点信息 */
function clearPointsByIds(pointArray){
	for(var i=0; i<pointArray.length; i++) {
		mapObj.removeOverlayById(pointArray[i]);
	}
	pointArray.length = 0;
}

/*
 * 根据城市名称定为地图
 * */
function setCityCenter(cityName){
 	//如果没有坐标点信息地图定位到默认城市
	var cityCode = city.ctn2c(cityName);
	var xy = new Array();
	xy = city.ctxy(cityCode);
	if (mapObj != null && mapObj != 'undefined' && mapObj != '') {
		mapObj.setZoomAndCenter(11, new MLatLng(xy[1],xy[0]));
	}
}

function getPointTipContents(title,tel,add,did){
	var content = '';
	content += "<table width='260' style='line-height:1.8;color:#333;font-size:12px;'>";
	content += "<tr><th colspan='2'>"+title+"</th></tr>";
	content += "<tr><th width='40px'>电话: </th><td width='220px'>"+tel+"</td></tr>";
	content += "<tr><th valign='top'>地址: </th><td>"+add+"</td></tr>";
	content += "<tr><td colspan='2' style='text-align:right;'><a style='color:#3366cc;' href='index.php?m=dianpu&c=info&id="+did+"' target='_blank'>进入店铺</a></td></tr>";
	content += "</table>";
	return content;
}
