<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/frontcontroller.php';

class DianpuController extends FrontController {
	var $_dianpu;
	
	function _before() {
		parent::_before();
		$this->_dianpu = $this->_getdianpu();
		$this->_viewer->baseName = BASEURL;
		$this->_viewer->title = $this->_dianpu->title;
		$this->_viewer->dianpuid = $this->_dianpu->dianpuid;
		$this->_viewer->mode = $this->_getGlobal('db_mode');
		$this->_viewer->siteName = $this->_getGlobal($this->_viewer->mode . '_sitename');
		$this->_setPartial($this->_getThemesTemplate());
		return true;
	}
	
	/**
	 * 获得店铺信息页
	 * @return PW_DianpuModule
	 */
	function _getdianpu() {
		list($id, $username) = $this->_gp(array('id', 'u'));
		if (!$id && !$username) Error::showError($this->_getErrorMessage(0));
		$dianpuService = DP::loadClass('dianpuservice', 'service');
		/* @var $dianpuService PW_DianpuService */
		if ($id) {
			if (!$dianpu = $dianpuService->getDianpu($id)) Error::showError($this->_getErrorMessage(1));
		} elseif ($username) {
			if (!$dianpu = $dianpuService->getDianpuByUser($username)) Error::showError($this->_getErrorMessage(1));
		}
		if (!$dianpu) Error::showError($this->_getErrorMessage(1));
		if (!$dianpu->state) Error::showError($this->_getErrorMessage(2));
		if (!$dianpu->ifcheck) Error::showError($this->_getErrorMessage(3));
		$this->_viewer->manageable = (isGM($this->_getGlobal('windid')) || ($dianpu->username == $this->_getGlobal('windid')) || ($dianpu->uid == $this->_getGlobal('winduid')));
		if ($dianpu->wangwang) $dianpu->wangwang = urlencode(dataConvert($dianpu->wangwang, 'UTF-8'));
		dianpuSeoSettings('read', '', '', $dianpu->title);
		return $dianpu;
	}
	
	/**
	 * 显示地图
	 */
	function showmap() {
		$this->_viewer->mapkey = $this->_getGlobal('dianpu_mapkey');
		$this->_viewer->cityName = $this->_getGlobal('dianpu_mapcity');
		$this->_viewer->dianpu = $this->_dianpu;
		$this->_viewer->toolbarMap = 'hidden';
		$this->_viewer->scaleMap = 'hidden';
		$this->_viewer->overviewMap = 'hidden';
		$this->_viewer->maph = '300px';
		$this->_setViewPath(APP_VIEWER);
		$this->_setLayoutFile('map.layout');
		$this->_setLayoutType('pw');
	}
	
	function _getErrorMessage($type) {
		$_message = array('0' => '非法操作请', '1' => '获取店铺信息失败', '2' => '该店铺暂未开通，访问失败', '3' => '该店铺审核未通过，访问失败');
		
		return $_message[$type] ? $_message[$type] : $_message[0];
	}
	
	/**
	 * 获得浏览记录（店铺浏览记录/商品浏览记录）
	 * @param string $type (dianpu / product)
	 * @param string $data (dianpuid / productid)
	 * @return array
	 */
	function getBrowse($type, $data = '') {
		if (!in_array($type, array('dianpu', 'product'))) return array();
		if (!$this->_getGlobal('winduid')) return array();
		$dids = $this->_getBrowse($type);
		$_dids = $data ? array($data) : array();
		$dids = $dids ? explode(',', trim($dids, ', ')) : array();
		for ($i = 0; $i < 10 && $i < count($dids); $i++) {
			if ($dids[$i] != $data) array_push($_dids, $dids[$i]);
		}
		$this->_setBrowse($type, implode(',', $_dids));
		return $_dids;
	}
	
	function _getBrowse($type) {
		$_winduid = $this->_getGlobal('winduid');
		return GetCookie($type . '_' . $_winduid);
	}
	
	function _setBrowse($type, $data) {
		$_winduid = $this->_getGlobal('winduid');
		Cookie($type . '_' . $_winduid, $data);
		return true;
	}
	
	function _setDianpuStyle() {
		$groupHelper = DP::loadClass('groupshelper', 'helper');
		$styleList = $groupHelper->getStylesList();
		$currentstyle = $groupHelper->getCurrentStyle($styleList, $this->_dianpu->group['styles'], $this->_dianpu->tempstyle);
		setDianpuStyle($this->_controller, $currentstyle['filename']);
		return $currentstyle;
	}
	
	function _getThemesTemplate() {
		$currentstyle = $this->_setDianpuStyle();
		$path = THEMES_VIEWER . 'default/';
		$filename = $currentstyle['filename'];
		if ($filename && is_dir(THEMES_VIEWER . $filename . '/')) $path = THEMES_VIEWER . $filename . '/';
		return THEMES_VIEWER . 'default/';
	}

}
?>