<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/dianpucontroller.php';
class productController extends DianpuController {
	
	var $_perpage = 20;
	
	function _before() {
		parent::_before();
		$this->_productHelper = DP::loadClass('producthelper', 'helper');
		$this->_viewer->baseName = BASEURL;
		$this->_viewer->baseUrl = BASEURL . '&c=' . $this->_controller;
		$this->_viewer->dianpuinfo = $this->_dianpu;
		
		list($productId) = $this->_gp(array('productid'));
		$pids = $this->getBrowse('product', $productId);
		$this->_viewer->browse = $this->_productHelper->getProductsByProductIds($pids);
		return true;
	}
	
	function run() {
		$this->_viewer->current['product'] = 'current';
		dianpuSeoSettings('read', '', '', $this->_dianpu->title);
	}
	
	function productlist() {
		list($page) = $this->_gp(array('page'));
		$page = ($page > 0) ? intval($page) : 1;
		list($total, $this->_viewer->products, $page) = $this->_productHelper->getProductsByDianpuIdWithShelf($this->_dianpu->dianpuid, $page, $this->_perpage);
		$commentHelper = DP::loadClass('commenthelper', 'helper');
		$url = $this->_viewer->baseUrl . '&a=productlist&id=' . $this->_dianpu->dianpuid . '&';
		$this->_viewer->pager = $commentHelper->NumOfPage($total, $page, ceil($total / $this->_perpage), $url, null, "productList");
		$this->_setLayoutFile('ajax');
		$this->_setLayoutType('ajax');
	}
	
	/**
	 * 商品详情页
	 */
	function detail() {
		list($productId) = $this->_gp(array('productid'));
		if ($productId < 1) {
			refreshto($this->_viewer->baseUrl, '请选择商品');
		}
		$this->_viewer->dianpu = $this->_dianpu;
		$this->_viewer->groupinfo = $this->_dianpu->group;
		$this->_viewer->productid = $productId;
		list($bool, $message, $this->_viewer->product) = $this->_productHelper->getProductWithShelf($productId);
		!$bool && Error::showError($message);
		if ($this->_viewer->product['photoid']) {
			$this->_viewer->photos = $this->_viewer->product['photos'];
		} else {
			$this->_viewer->photos = $this->_productHelper->getDefaultPhotos();
		}
		$this->_viewer->product['description'] = $this->_productHelper->_filterContent($this->_viewer->product['description']);
		$this->_viewer->current['product'] = 'current';
		$this->_viewer->dianpuid = $this->_dianpu->dianpuid;
		
		
		/* 更新点击率 */
		$hitsService = DP::loadClass('producthitsservice', 'service');
		$hitsService->updateProductHits($productId,$this->_viewer->product['objectid']);
		
		/* 获得评论权限 */
		$commentHelper = DP::loadClass('commenthelper', 'helper');//查看是否有评论的权限
		$this->_viewer->commentRight = $commentHelper->getRight($this->_dianpu->uid);
		
		dianpuSeoSettings('read', '', $this->_viewer->product['title'], $this->_dianpu->title);
	}
}