<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/managecontroller.php';
class pmanageController extends manageController {
	var $_perpage = 15;
	
	function _before() {
		parent::_before();
		$this->_productHelper = DP::loadClass('producthelper', 'helper');
		$this->_viewer->baseName = BASEURL;
		$this->_viewer->baseUrl = BASEURL . '&c='.$this->_controller;
		$this->_viewer->pmanage = 'current';
		return true;
	}
	
	function run() {
		list($page) = $this->_gp(array('page'));
		$page = ($page < 1) ? 1 : intval($page);
		list($total, $this->_viewer->products) = $this->_productHelper->getProductsByDianpuId($this->_dianpu->dianpuid, $page, $this->_perpage);
		$this->_viewer->pager = numofpage($total, $page, ceil($total / $this->_perpage), $this->_viewer->baseUrl . '&dianpuid=' . $this->_dianpu->dianpuid . '&');
	}
	
	function add() {
		list($step,$params['recommend'],$params['title'],$params['market_price'],$params['member_price']) = $this->_gp(array('step','recommend','title','market_price','member_price'));
		list($params['description']) = $this->_gp(array('atc_content'), false);
		if ($step == 2 && $this->_isPost()) {
			$params['objectid'] = $this->_dianpu->dianpuid;
			$params['shelf'] = 1;
		    if ($this->_productHelper->addProducts($params)) refreshto($this->_viewer->baseUrl.'&dianpuid='.$this->_viewer->dianpuid, '添加成功');
		}
		$this->_viewer->product['photoadd'] = 5;
		$this->_viewer->checked[0] = 'checked="checked"';
		Error::checkError(1);
	}
	
	function edit(){
		list($productId,$step) = $this->_gp(array('productid','step'));
		if($step == 2 && $this->_isPost()){
			list($params['recommend'],$params['title'],$params['market_price'],$params['member_price'],$params['cover']) = $this->_gp(array('recommend','title','market_price','member_price','cover'));
			list($params['description']) = $this->_gp(array('atc_content'), false);
			$params['objectid'] = $this->_dianpu->dianpuid;
			if ($this->_productHelper->editProducts($params,$productId,$this->_viewer->dianpuid))  refreshto($this->_viewer->baseUrl.'&a=edit&productid='.$productId.'&dianpuid='.$this->_viewer->dianpuid, '商品编辑成功！');
		}
		Error::checkError(1);
		$this->_viewer->product = $this->_productHelper->getProduct($productId);
		$recommend = ($this->_viewer->product['recommend']) ? 1 : 0;
		$this->_viewer->checked[$recommend] = 'checked="checked"';
		$this->_viewer->operatename = '商品编辑';
		$this->_viewer->operate = 'edit';
		$this->_setTemplate($this->_controller.'.add');
	}
	
	function deletephoto(){
		list($photoId,$productId) = $this->_gp(array('photoid','productid'));
		list($bool,$message) = $this->_productHelper->deletephoto($photoId,$this->_viewer->dianpuid);
		refreshto($this->_viewer->baseUrl.'&a=edit&productid='.$productId.'&dianpuid='.$this->_viewer->dianpuid,$message);
	}
	
	function search(){
		list($keyword,$shelf,$page) = $this->_gp(array('act_title','shelf','page'));
		$keyword = trim(strip_tags($keyword));
		$page = ($page < 1) ? 1 : intval($page);
		list($total, $this->_viewer->products) = $this->_productHelper->searchProductsByShelf($this->_dianpu->dianpuid, addslashes($keyword), $shelf, $page, $this->_perpage);
		$this->_viewer->pager = numofpage($total, $page, ceil($total / $this->_perpage), $this->_viewer->baseUrl . '&dianpuid=' . $this->_dianpu->dianpuid . '&a=search&act_title=' . urlencode(stripslashes($keyword)) . '&shelf=' . $shelf . '&');
		$this->_viewer->keyword = $keyword;
		$shelf = ($shelf == -1 ) ? 'all' : $shelf;
		$this->_viewer->checked[$shelf] = 'selected="selected"';
		$this->_setTemplate($this->_controller.'.run');
	}
	
	function delete() {
		list($productId) = $this->_gp(array('productid'));
		list($bool, $message) = $this->_productHelper->deleteProduct($productId,$this->_viewer->dianpuid);
		refreshto($this->_viewer->baseUrl.'&a=search&dianpuid='.$this->_viewer->dianpuid,$message);
		$this->_setLayoutFile('ajax');
		$this->_setLayoutType('ajax');
	}
	
	function operate() {
		list($step, $doing, $products) = $this->_gp(array('step','doing','products'));
		list($bool, $message) = $this->_productHelper->opereateProducts($products, $doing,$this->_viewer->dianpuid);
		refreshto($this->_viewer->baseUrl.'&dianpuid='.$this->_viewer->dianpuid,$message);
	}
	
	function shelf() {
		list($shelf,$productId) = $this->_gp(array('shelf','productid'));
		list($bool, $message) = $this->_productHelper->shelfProduct($shelf,$productId,$this->_viewer->dianpuid);
		refreshto($this->_viewer->baseUrl.'&dianpuid='.$this->_viewer->dianpuid,$message);
		$this->_setLayoutFile('ajax');
		$this->_setLayoutType('ajax');
	}

}