<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/publiccontroller.php';
class listController extends PublicController {
	
	var $_perpage = 10;
	
	function _before() {
		parent::_before();
		$this->_perpage = $this->_getGlobal('dianpu_listnum');
		$this->_viewer->baseName = BASEURL;
		$this->_viewer->baseUrl = BASEURL . '&c=' . $this->_controller;
		return true;
	}
	
	function run() {
		list($page, $step, $categoryid, $areaid, $orderby, $verify, $keyword) = $this->_gp(array('page', 'step', 
			'categoryid', 'areaid', 'orderby', 'verify', 'atc_title'));
		if (!$this->_isPost() && $verify) $verify = explode('|', $verify); //如果是翻页过来的将字符串拆分
		$categoryHelper = DP::loadClass('categorieshelper', 'helper');
		$areaHelper = DP::loadClass('areashelper', 'helper');
		list($parent, $children, $allCategories) = $categoryHelper->getParentAndChild();
		$areas = $areaHelper->getAreas();
		if ($categoryid > 0) {
			$parentId = (isset($parent[$categoryid])) ? $categoryid : $allCategories[$categoryid]['parentid'];
			$categoryid = (isset($parent[$categoryid])) ? '' : $categoryid;
			$categories = $children[$parentId];
			$parent = $parent[$parentId];
			$this->_viewer->showall = true;
		} else {
			$categories = $parent;
			$parent = array('name' => '全部', 'categoryid' => 0);
		}
		$keyword = trim(strip_tags($keyword));
		$orderby = ($orderby) ? $orderby : 1;
		list($this->_viewer->dianpus, $this->_viewer->pager) = $this->_dainpuHelper->searchForDianpu($areaid, $parentId, $categoryid, $verify, $orderby, $keyword, $this->_viewer->baseUrl, $page, $this->_perpage);
		$verify = (S::isArray($verify)) ? $verify : array();
		$this->_viewer->parent = $parent;
		$this->_viewer->categories = array_merge(array(array('name' => '全部', 'categoryid' => $parent['categoryid'])), (array) $categories);
		$this->_viewer->areas = array_merge(array(array('name' => '全部', 'areaid' => 0)), (array) $areas);
		$this->_viewer->categoryid = (intval($categoryid) == 0) ? intval($parentId) : intval($categoryid);
		$this->_viewer->areaid = intval($areaid);
		$this->_viewer->currentorderby[$orderby] = 's5';
		$this->_viewer->keyword = $keyword;
		$this->_viewer->orderby = $orderby;
		foreach ($verify as $v) {
			$this->_viewer->currentverify[$v] = 'checked="checked"';
		}
		$this->_viewer->recommendlevels = array(3 => 'C', 4 => 'B', 5 => 'A');
		$this->_viewer->dianpumap = pwJsonEncode($this->_viewer->dianpus);
		dianpuSeoSettings('read', '', '', $this->_dianpu->title);
		
		//设置推荐过期店铺
		$this->_overdueDianpu($this->_viewer->dianpus);
	}
	
	function _overdueDianpu($dianpus) {
		if (!$dianpus) return false;
		$timestamp = $this->_getGlobal('timestamp');
		$overDianpus = array();
		foreach ($dianpus as $key => $value) {
			if ($value['overtime'] && PwStrtoTime($value['overtime']) <= $timestamp) $overDianpus[] = $value['dianpuid'];
		}
		if (!$overDianpus) return false;
		$service = DP::loadClass('dianpuservice', 'service'); /* @var $service PW_Dianpuservice */
		$service->setOverdueDianpu($overDianpus);
	}
	
	function showmap() {
		list($dianpuMaps) = $this->_gp(array('maps'));
		$this->_viewer->mapkey = $this->_getGlobal('dianpu_mapkey');
		$this->_viewer->cityName = $this->_getGlobal('dianpu_mapcity');
		$this->_viewer->toolbarMap = 'hidden';
		$this->_viewer->scaleMap = 'hidden';
		$this->_viewer->overviewMap = 'hidden';
		$this->_viewer->maph = '300px';
		$this->_setViewPath(APP_VIEWER);
		$this->_setLayoutFile('map.layout');
		$this->_setLayoutType('pw');
	}
	
	function _buildMapData($data) {
		$_tmp = array();
		foreach ($data as $key => $value) {
			$_tmp[]['map_x'] = $value['map_x'];
			$_tmp[]['map_y'] = $value['map_x'];
			$_tmp[]['map_z'] = $value['map_x'];
			$_tmp[]['title'] = $value['title'];
		}
		return $_tmp;
	}

}