<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/dianpucontroller.php';

/**
 * 店铺详情页 Action Controller
 * @author yishuo
 * 2010-09-21
 */
class InfoController extends DianpuController {
	var $_perpage = 10;
	
	function _before() {
		parent::_before();
		$this->_viewer->baseUrl = BASEURL . '&c=' . $this->_controller;
		$this->_viewer->current['dianpu'] = 'current';
		return true;
	}
	
	/**
	 * 店铺详细信息页
	 */
	function run() {
		list($contentid) = $this->_gp(array('contentid'));
		if (!$this->_dianpu) Error::showError($this->_getErrorMessage(1));
		$dianpuService = DP::loadClass('dianpuservice', 'service'); /* @var $dianpuService PW_DianpuService */
		$this->_viewer->dianpuinfo = $this->_dianpu;
		$this->_viewer->dianpuid = $this->_dianpu->dianpuid;
		
		/* 店铺组信息 */
		$this->_viewer->groupinfo = $this->_dianpu->group;
		
		/* 店铺推荐商品 */
		$productHelper = DP::loadClass('producthelper', 'helper'); /* @var $productService PW_ProductsService */
		$products = $productHelper->getProductsByObjectIdWithRecommend($this->_dianpu->dianpuid, 1, 30);
		$this->_viewer->products = $products;
		$this->_viewer->proCount = count($products);
		
		/* 评论权限获取 */
		$commentHelper = DP::loadClass('commenthelper', 'helper');
		$this->_viewer->commentRight = $commentHelper->getRight($this->_dianpu->uid);
		
		/* 获得浏览记录 */
		$dids = $this->getBrowse('dianpu', $this->_dianpu->dianpuid);
		$this->_viewer->browse = $dianpuService->getDianpuListByIds($dids, true);
		
		/* 更新站点访问量 */
		$dianpuHitsService = DP::loadClass('dianpuhitsservice', 'service'); /* @var $dianpuHitsService pw_dianpuhitsservice */
		$dianpuHitsService->updateDianpuHits($this->_dianpu->dianpuid);
	}
	
	function content() {
		list($contentid) = $this->_gp(array('contentid'));
		if (!$this->_dianpu) Error::showError($this->_getErrorMessage(1));
		$dianpuService = DP::loadClass('dianpuservice', 'service'); 
		/* @var $dianpuService PW_DianpuService */
		$this->_viewer->dianpuinfo = $this->_dianpu;
		
		/* 评论权限获取 */
		$commentHelper = DP::loadClass('commenthelper', 'helper');
		$this->_viewer->commentRight = $commentHelper->getRight($this->_dianpu->uid);
		
		/* 店铺内容获取  */
		$this->_viewer->tabs = $this->_dianpu->getPageTitles();
		if (!$contentid) {
			$contentid = array_keys($this->_viewer->tabs);
			$contentid = $contentid[0];
		}
		$contents = $dianpuService->getDianpuContent($contentid);
		$this->_viewer->contents = $this->_filterContent($contents['contents']);
		$this->_viewer->currentTab[$contentid] = 'current';
		$this->_setLayoutFile('ajax');
		$this->_setLayoutType('ajax');
	}
	
	/**
	 * 店铺电话号码图片生成
	 */
	function getphone() {
		list($phonenumber, $color) = $this->_gp(array('pn', 'color'));
		if (!$phonenumber || $phonenumber == '-') $phonenumber = '0000-00000000';
		header('Content-type: image/png');
		$font = M_P . 'images/fonts/Arial.ttf';
		$im = imagecreatetruecolor(120, 14);
		$white = imagecolorallocate($im, 255, 255, 255);
		$fontColor = imagecolorallocate($im, 0, 0, 0);
		if ($color == 'red') {
			$fontColor = imagecolorallocate($im, 255, 0, 0);
		}
		imagefilledrectangle($im, 0, 0, 399, 29, $white);
		imagettftext($im, 11, 0, 0, 11, $fontColor, $font, $phonenumber);
		imagepng($im);
		imagedestroy($im);
		exit();
	}
	
	/**
	 * 评论列表
	 * ajax调用
	 */
	function commentlist() {
		$this->_viewer->groupinfo = $this->_dianpu->group;
		if (!$this->_viewer->groupinfo['configinfo']['comments']) {
			echo '该店铺所在的店铺组不提供评论功能!';
		} else {
			list($productId) = $this->_gp(array('productid'));
			list($page) = $this->_gp(array('page'));
			(!$page) && $page = 1;
			$commentHelper = DP::loadClass('commenthelper', 'helper');
			list($count, $page, $totalpage, $rootList, $childList) = $commentHelper->getFrontCommentList($this->_dianpu->dianpuid, $productId, $page, 8);
			$url = $this->_viewer->baseName . '&c=info&a=commentlist&id=' . $this->_dianpu->dianpuid . '&productid=' . $productId;
			$this->_viewer->backurl = $this->_viewer->baseUrl . '&page=' . $page;
			$this->_viewer->pager = PW_CommentHelper::NumOfPage($count, $page, $totalpage, "$url&", null, "commentAjax.getComment");
			$this->_viewer->right = $commentHelper->getRight($this->_dianpu->uid);
			$this->_viewer->rootList = $rootList;
			$this->_viewer->childList = $childList;
			$this->_viewer->page = $page;
			$this->_viewer->dianpuid = $this->_dianpu->dianpuid;
			$this->_viewer->productid = $productId;
			$this->_viewer->mode = $this->_getGlobal('m');
		}
		$this->_setLayoutFile('ajax');
		$this->_setLayoutType('ajax');
	}
	
	/**
	 * 回复评论
	 * 留言权限检查---包括店主  管理员   普通会员
	 * 检查用户是否已经登录
	 */
	function replycomment() {
		$temp = array();
		$temp['uid'] = $this->_getGlobal('winduid');
		list($temp['objectid']) = $this->_gp(array('id'));
		$_right = $this->_checkright($temp['uid'], $this->_dianpu->uid, $temp['objectid'], 'add', $this->_dianpu->group['configinfo']['comments']);
		if (S::isArray($_right)) {
			echo pwJsonEncode($_right);
		} else {
			$commentHelper = DP::loadClass('commenthelper', 'helper');
			list($page, $temp['typeid'], $temp['parentid'], $temp['rootid'], $temp['content'], $temp['title']) = $this->_gp(array(
				'page', 'productid', 'parentid', 'rootid', 'content', 'title'));
			$temp['username'] = $this->_getGlobal('windid');
			$temp['postdate'] = $this->_getGlobal('timestamp');
			($this->_dianpu->username == $temp['username'] && $temp['rootid']) ? $temp['isanswer'] = 1 : $temp['isanswer'] = 0;
			list($result['flag'], $result['message']) = $commentHelper->addComment($temp);
			($result['flag']) ? $result['flag'] = 'success' : $result['flag'] = 'error';
			$result['url'] = $this->_viewer->baseName . '&c=info&a=commentlist&page=' . $page . '&id=' . $temp['objectid'] . '&productid=' . $temp['typeid'];
			echo pwJsonEncode($result);
		}
		$this->_setLayoutFile('ajax');
		$this->_setLayoutType('ajax');
	}
	
	/**
	 * 删除评论
	 */
	function delcomment() {
		$_winduid = $this->_getGlobal('winduid');
		list($commentid, $dianpuid, $productid) = $this->_gp(array('commentid', 'id', 'productid'));
		$_right = $this->_checkright($_winduid, $this->_dianpu->uid, $dianpuid, 'del', $this->_dianpu->group['configinfo']['comments'], $commentid);
		if (S::isArray($_right)) {
			echo pwJsonEncode($_right);
		} else {
			$commentHelper = DP::loadClass('commenthelper', 'helper');
			list($page) = $this->_gp(array('page'));
			list($result['flag'], $result['message']) = $commentHelper->deleteComment($commentid, $dianpuid);
			($result['flag']) ? $result['flag'] = 'success' : $result['flag'] = 'error';
			$result['url'] = $this->_viewer->baseName . '&c=info&a=commentlist&page=' . $page . '&id=' . $dianpuid . '&productid=' . $productid;
			echo pwJsonEncode($result);
		}
		$this->_setLayoutFile('ajax');
		$this->_setLayoutType('ajax');
	}
	
	/**
	 * 判断权限
	 * @param $uid  当前登录的用户ID
	 * @param $dianpuUid  当前店铺的店主ID
	 * @param $dianpuid 店铺的ID是否有传入
	 * @param $commentid 是否有传入commentid  ----  对于  del的操作时必须的
	 * @param $step   判断是否是正确的操作来源
	 * @param $flag 权限的类型       'add' or 'del'
	 */
	function _checkright($uid, $dianpuUid, $dianpuid, $flag, $groupRight, $commentid = '') {
		list($step) = $this->_gp(array('step'));
		if (!$uid) return array('flag' => 'error', 'message' => '您还没有登录，请先登录！', 'login' => 'login.php'); //没有操作权限
		$commentHelper = DP::loadClass('commenthelper', 'helper');
		$right = $commentHelper->getRight($dianpuUid);
		if ($flag === 'add') {
			if ($step != 2 || !$dianpuid) return array('flag' => 'error', 'message' => '非法操作');
			if (!$right['reply'] && !$right['comment']) return array('flag' => 'error', 'message' => '没有操作权限'); //没有操作权限
			if (!$groupRight) return array('flag' => 'error', 'message' => '该店铺所在的店铺组不提供评论服务！'); 
		} elseif ($flag === 'del') {
			if ($step != 3 || !$dianpuid || !$commentid) return array('flag' => 'error', 'message' => '非法操作');
			if (!$right['del']) return array('flag' => 'error', 'message' => '没有操作权限');
			if (!$groupRight) return array('flag' => 'error', 'message' => '该店铺所在的店铺组不提供评论服务！'); 
		}
		return array();
	}
	/**
	 * 店铺内容过滤
	 * @param string $contents
	 * @return string
	 */
	function _filterContent($contents) {
		include_once R_P . 'require/bbscode.php';
		$contents = showface($contents);
		$contents = str_replace(array("\n", "\r\n"), '<br>', trim($contents, "\r\n \n \r"));
		$contents = convert($contents, $this->_getGlobal('db_windpost'));
		return $contents;
	}

}
?>