<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/managecontroller.php';
class cmanageController extends manageController {
	var $_commentHelper ;
	var $_perpage = 15;
	
	function _before() {
		parent::_before();
		$this->_commentHelper = DP::loadClass('commenthelper', 'helper');
		$this->_viewer->baseUrl = BASEURL . '&c=' . $this->_controller;
		$this->_viewer->baseName = BASEURL;
		$this->_viewer->cmanage = 'current';
		$this->_viewer->groupRight = $this->_dianpu->group['configinfo']['comments'];
		return true;
	}
	
	/**
	 * 默认执行的方法
	 * 
	 * 实现评论的搜索功能
	 */
	function run() {
		list($this->_viewer->commentRight, $this->_viewer->rightMessage) = $this->_commentHelper->checkRight($this->_dianpu->uid, $this->_viewer->groupRight);
		$arr = array();
		list($arr['state'], $v, $page) = $this->_gp(array('state', 'v', 'page'));
		if($v == "shangjiaC1"  && $this->_isPost()) {
			list($keyword, $type) = $this->_gp(array('act_title', 'type'));
			(!empty($keyword)) && ($type == 1) ? $arr['content'] = $keyword : $arr['username'] = $keyword;
		}else {
			list($arr['content'], $arr['username']) = $this->_gp(array('content','username'));
			$keyword = ($arr['content']) ? $arr['content'] : $arr['username'];
			($arr['content']) ? $type= 1 : $type = 2;
		}
		$page = (!$page) ? 1 : intval($page);
		$arr['objectid'] = $this->_dianpu->dianpuid;
		list($count, $arr['page'], $totalPage, $commentList) = $this->_commentHelper->getShangjiaCommentList($arr, $page, $this->_perpage);		
		$pageurl = $this->_commentHelper->getPageUrl($arr);
		$url = $this->_viewer->baseUrl . '&a=run&'. $pageurl . '&dianpuid=' . $this->_dianpu->dianpuid ;
		$this->_viewer->backurl = $this->_viewer->baseUrl . '&' . $pageurl . '&page=' . $arr['page'] . '&dianpuid=' . $this->_dianpu->dianpuid;
		$this->_viewer->search = $arr;
		$this->_viewer->pager = numofpage($count, $arr['page'], $totalPage, "$url&#x_comment_list");
		$this->_viewer->comments = $commentList;
		$this->_viewer->right = $this->_commentHelper->getRight($this->_dianpu->uid);
		$this->_viewer->keyword = $keyword;
		$this->_viewer->type[$type] = "checked='checked'";
		$this->_viewer->state[$arr['state']] = "selected='selected'";
		$this->_viewer->dianpuid = $this->_dianpu->dianpuid;
	}
	
	/**
	 * 删除评论
	 */
	function deleteComment() {
		list($id, $dianpuid) = $this->_gp(array('commentid', 'dianpuid'));
		if(!$id || !$dianpuid)  Error::showError('非法操作'); 
		list($_tmpFalg, $_tmpError) = $this->_commentHelper->checkRight($this->_dianpu->uid, $this->_viewer->groupRight, 'del');
		if(!$_tmpFalg)  Error::showError($_tmpError);
		$arr = array();
		list($arr['content'], $arr['username'], $arr['page'], $arr['state']) = $this->_gp(array('content','username' ,'page','state'));
		$pageurl = $this->_commentHelper->getPageUrl($arr);
		$refreshUrl = $this->_viewer->baseUrl . '&a=run&page=' . $arr['page'] . '&' . $pageurl . '&dianpuid=' . $dianpuid;
		if(empty($id))  refreshto($refreshUrl, "请选择需要删除的评论!");
		list($flag, $message) = $this->_commentHelper->deleteComment($id, $dianpuid);
		refreshto($refreshUrl, $message);
	}
	
	/**
	 * 删除多条评论
	 */
	function deleteComments() {
		list($_tmpFalg, $_tmpError) = $this->_commentHelper->checkRight($this->_dianpu->uid, $this->_viewer->groupRight, 'del');
		if(!$_tmpFalg)  Error::showError($_tmpError);
		list($ids, $dianpuid, $po) = $this->_gp(array('commentid', 'dianpuid', 'po'));
		if(!$ids || !$dianpuid)  Error::showError('非法操作');
	    if($po != 'shangjiaD1' || !$this->_isPost())  Error::showError('非法操作');
	    
		$arr = array();
		list($arr['content'], $arr['username'], $arr['page'], $arr['state']) = $this->_gp(array('content','username' ,'page','state'));
		$pageurl = $this->_commentHelper->getPageUrl($arr);//获得分页url
		$refreshUrl = $this->_viewer->baseUrl . '&a=run&page=' . $arr['page'] . '&' . $pageurl . '&dianpuid=' . $dianpuid;
		if(empty($ids))  refreshto($refreshUrl, "请选择需要删除的评论!");
		list($flag, $message) = $this->_commentHelper->deleteComments($ids, $dianpuid);
		refreshto($refreshUrl, $message);
	}
	
	/**
	 * 回复评论
	 * ajax
	 */
	function ajaxreply() {
		list($_tmpFalg, $_tmpError) = $this->_commentHelper->checkRight($this->_dianpu->uid, $this->_viewer->groupRight, 'reply');
		if(!$_tmpFalg)  Error::showError($_tmpError);
		list($parentid, $rootid, $p, $objectid, $typeid, $uid) = $this->_gp(array('parentid', 'rootid', 'p', 'objectid', 'typeid', 'uid'));
		if($p == 'step2' && $this->_isPost()) {
			$temp = array();
			list($temp['content'], $temp['title']) = $this->_gp(array('content', 'title'));
			$temp['parentid'] = $parentid;
			$temp['rootid'] = $rootid;
			$temp['objectid'] = $objectid;
			$temp['typeid'] = $typeid;
			$temp['username'] = $this->_getGlobal('windid');//用户名
			$temp['uid'] = $this->_getGlobal('winduid');//用户ID
			$temp['isanswer'] = 1;
			$temp['postdate'] = $this->_getGlobal('timestamp');
			$result = $this->_commentHelper->addComment($temp);
			$refreshUrl = $this->_viewer->baseUrl . '&a=run&dianpuid=' . $objectid;
			refreshto($refreshUrl, $result[1]);
		}
		if($p == 'step') {
			$userService = L::loadClass('userservice', 'user');
			$userInfo = $userService->get($uid, true, true);
			$this->_viewer->title = '回复(' . $userInfo['username'] . '):';
			$this->_viewer->parentid = $parentid;
			$this->_viewer->rootid = $rootid;
			$this->_viewer->objectid = $objectid;
			$this->_viewer->typeid  = $typeid;
			$this->_setLayoutType('ajax');
			$this->_setLayoutFile('ajax');
		}else {
			$refreshUrl = $this->_viewer->baseUrl . '&a=run';
			refreshto($refreshUrl, "非法操作");
		}		
	}
}
?>