<?php
!defined('P_W') && exit('Forbidden');
require_once MODE . '/base/publiccontroller.php';

class checkinController extends publicController {
	function _before() {
		parent::_before();
		$this->_viewer->baseurl = BASEURL . '&c='.$this->_controller;
		$this->_viewer->baseName = BASEURL;
		return true;
	}

	/**
	 * 显示商家入住的信息
	 */
	function run() {
		dianpuSeoSettings('read','','','商家入驻');
	}

	/**
	 * 商家入住填写页面
	 * 根据登录的用户名查询该用户是否已经有店铺开通
	 */
	function checkin() {
		if(!($_windid = $this->_getGlobal('windid'))) Error::showError("您还没有登录，请先登录！", "login.php");
		if(($_dianpu = $this->_dainpuHelper->getDianpuInfoByUser($_windid)) && !isGM($_windid)) {
			Error::showError((($_dianpu->state == 0) ? '您已经申请了一个店铺，正在等待管理员审核！' : '一个帐号只能开通一个店铺，您已经开通了一个店铺。'));
		}
		$toolsHelper = DP::loadClass('toolshelper','helper');
		$this->_viewer->parentCategorySelectHtml = $toolsHelper->createCategoryForAjax();
		$this->_viewer->areaSelectHtml = $toolsHelper->createAreaLink('',true);
		dianpuSeoSettings('','','','入驻信息填写');
	}

	/**
	 * 添加商家入住填写页面
	 */
	function addShangjiaCheckin() {
		$service = DP::loadClass('dianpuservice', 'service');
		if(($_dianpu = $service->getDianpuByUser($this->_getGlobal('windid')))) {
			Error::showError((($_dianpu->state == 0) ?  '您已经申请了一个店铺，正在等待管理员审核！' : '一个帐号只能开通一个店铺，您已经开通了一个店铺。'));
		}
		list($step) = $this->_gp(array('step'));
		if( $step != 'step2' || !$this->_isPost())  refreshto($this->_viewer->baseName . '&c=checkin', '非法操作');

		$params = array();
		list($params['title'], $params['areaid'], $params['categoryid'],$params['parentid'], $params['operator'], $params['operatorphone']) = $this->_gp(array('title', 'areaid', 'childid','categoryid', 'operator', 'operatorphone'));
		list($params['company'], $params['delegate'], $params['delegatephone'], $params['companyaddress'], $params['companyphone'], $params['companyfax'], $params['companyzipcode']) = $this->_gp(array('company', 'delegate', 'delegatephone', 'companyaddress', 'companyphone', 'companyfax', 'companyzipcode'));
		list($params['uid'],$params['username']) = array($this->_getGlobal('winduid'),$this->_getGlobal('windid'));
		$params['groupid'] = 1;//设置默认的店铺组
		if ($this->_dainpuHelper->addDianpu($params)) refreshto($this->_viewer->baseName , "店铺申请递交成功！");
		Error::checkError(1);
	}

	/**
	 * 下载商家入住填写信息表
	 */
	function export() {
		$this->_dainpuHelper->export();
		exit();
	}


	/**
	 * 店铺行业分类的子分类的ajax联动
	 */
	function categorychildlist() {
		list($parentid, $childid) = $this->_gp(array('parentid', 'childid'));
		$toolsHelper = DP::loadClass('toolshelper','helper');
		if ($parentid) {
			echo $toolsHelper->createCategoryForAjax($parentid, $childid, false);
		} else {
			echo '';
		}
		$this->_setLayoutFile('ajax');
		$this->_setLayoutType('ajax');
	}

}
?>
