<?php
/***
*
*@package binzcms
*@version $id:ModfrontPicClass.php, v 1.0
*@author 斌子
*@Tue Aug 31 04:52:07 GMT 2010
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModFrontPicClass
 * 前台图片显示
 * 
 */
class ModFrontPicClass extends BaseClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		parent::__construct($act);
	}
	/**
	 * mod_front_img_content
	 *
	 * 图片内容
	 * @access  public（权限）
	 * 
	 * @return  array
	 */
	public function mod_front_img_content() {
		$content_array			= array();
		$content_sql			= '';

		$content_sql			= "SELECT * FROM #binz#article AS a
									INNER JOIN #binz#article_body AS b ON a.article_id=b.body_id
									LEFT JOIN #binz#image AS i ON a.article_id=i.article_id
							 		WHERE a.article_id=".intval($_GET['article_id']);
		$content_array			= $this->binz_db->set_select_sql($content_sql);

		if(empty($content_array)) {
			return false;
		}

		return $content_array;
	}
	/**
	 * mod_front_image_comment_list
	 *
	 * 评论列表
	 * @access  public（权限）
	 *  @param   integer $binz_page		当前页数
	 *  @param   integer $page_num		每页记录数
	 * @return  array	评论列表数组
	 */
	public function mod_front_image_comment_list($binz_page,$page_num) {
		$comment_array			= array();
		$comment_sql			= "";
		$limit_sql				=  "LIMIT ".(intval($binz_page)-(intval($binz_page)>=1 ? 1 : 0))*$page_num.",$page_num";
		$where					= "WHERE c.article_id=".intval($_GET['article_id']);
		$comment_sql			= "SELECT c.*,m.* FROM #binz#article_comment AS c
									LEFT JOIN #binz#member AS m ON c.member_id=m.member_id
									$where
									 ORDER BY c.comment_id DESC ".$limit_sql;
		$comment_array['list']	= $this->binz_db->set_select_sql($comment_sql);
		$comment_array['count']	= $this->binz_db->set_select_sql("SELECT COUNT(c.comment_id) AS comment_num FROM #binz#article_comment AS c ".$where,0);

		return $comment_array;
	}
	/**
	 * mod_update_front_image_content
	 *
	 * 更新内容特定信息
	 * @access  public（权限）
	 * 
	 * @param array		$array		特定内容
	 * @return  array
	 */
	public function mod_update_front_image_content($array) {
		$this->binz_db->set_update_sql('#binz#article',$array,array('field'=>'article_id','value'=>intval($_GET['article_id'])));
	}
	/**
	 * mod_front_image_comment_save
	 *
	 * 评论保存操作
	 * @access  public（权限）
	 * @param   integer 参数
	 * @return  void	返回类型
	 */
	public function mod_front_image_comment_save() {
		if(OPEN_COMMENT == '1') {
			if($_SESSION['member_name'] == '') {
				return 2;		//登录后才可以评论
			}
		}
		if(COMMENT_CODE == '1') {
			/*验证码判断*/
			if(strtolower(trim($_POST['post_code'])) != $_SESSION['binz_code']) {
				return 4;		//验证码错误返回信息
			}
		}

		$comment_array			= array();

		$comment_array['comment_id']		= 'NULL';
		$comment_array['article_id']		= intval($_POST['article_id']);
		$comment_array['comment_body']		= htmlspecialchars(trim($_POST['comment']),ENT_QUOTES);
		$comment_array['comment_author']	= $_SESSION['member_name'] != '' ? $_SESSION['member_name'] : 'guest';
		$comment_array['member_id']			= $_SESSION['member_id'] != '' ? $_SESSION['member_id'] : 0;
		$comment_array['comment_time']		= time();
		$comment_array['comment_ip']		= $this->binz_common->get_true_ip();

		$not_allow_word			= explode('|',NOT_ALLOW_WORD);
		if(is_array($not_allow_word) and !empty($not_allow_word)) {
			$comment_array['comment_body']		= @str_replace($not_allow_word,'***',$comment_array['comment_body']);
		}

		$insert_state	= $this->binz_db->set_insert_sql_value('#binz#article_comment',$comment_array);
		if($insert_state) {
			return true;
		} else {
			return false;
		}

	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>