<?php
/***
*
*@package binzcms
*@version $id:ModFrontMemberClass.php, v 1.0
*@author 斌子
*@Tue Mar 03 20:44:19 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModFrontMemberClass
 * 会员操作类
 * 
 */
class ModFrontMemberClass extends BaseClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		parent::__construct($act);
	}
	/**
	 * mod_front_member_save
	 *
	 * 会员保存操作
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_front_member_save() {
		$insert_state					= false;
		$member_array					= array();
		
		/*用户名判断*/
		if(trim($_POST['member_name']) == '') {
			return 4;
		}
		/*电子邮件判断*/
		if(trim($_POST['member_email'])=='') {
			return 5;
		}
		/*重复电子邮件判断*/
		if(!$this->mod_front_check_email(trim($_POST['member_email']),trim($_POST['member_name']))) {
			return 6;
		}
		/*密码判断*/
		if((trim($_POST['member_passwd']) != trim($_POST['confirm_password'])) or trim($_POST['member_passwd']) == '' or trim($_POST['confirm_password']) == '') {
			return 2;		//密码为空，或是两次输入的密码不同
		}
		/*验证码判断*/
		if(REG_CODE == '1') {
			if(strtolower(trim($_POST['reg_code'])) != $_SESSION['binz_code']) {
				return 3;		//验证码错误返回信息
			}
		}
		$member_array['member_id']		= 'NULL';											//会员id
		$member_array['member_name']	= trim($_POST['member_name']);						//会员名称
		$member_array['member_passwd']	= substr(md5(trim($_POST['member_passwd'])),0,16);	//会员密码
		$member_array['member_email']	= trim($_POST['member_email']);						//会员email
		$member_array['member_sex']		= 1;												//会员性别
		$member_array['member_time']	= time();
		$member_array['login_time']		= $member_array['member_time'];
		$member_array['login_old_time']	= $member_array['member_time'];

		$insert_state = $this->binz_db->set_insert_sql_value('#binz#member',$member_array);
		if($insert_state) {
			$_SESSION['member_id']		= $this->binz_db->last_insert_id();		//得到会员id
			$_SESSION['member_name']	= $member_array['member_name'];			//会员名称
			$_SESSION['binz_code']		= '';									//清空验证码
			return true;
		} else {
			return false;
		}
	}
	/**
	 * mod_front_member_login
	 *
	 * 会员登录
	 * @access  public（权限）
	 * 
	 */
	public function mod_front_member_login() {
		/*用户名判断*/
		$member_info	= array();
		$member_sql		= "SELECT * FROM #binz#member
							WHERE member_name='".trim($_POST['username'])."'";
		$member_info	= $this->binz_db->set_select_sql($member_sql,0);

		if($member_info['member_name'] == '') {
			return 2;		//用户名错误返回信息
		}

		/*管理员密码判断*/
		if(substr(md5(trim($_POST['password'])),0,16) != $member_info['member_passwd']) {
			return 3;		//密码错误返回信息
		}
		if(LOGIN_CODE == '1') {
			/*验证码判断*/
			if(strtolower(trim($_POST['login_code'])) != $_SESSION['binz_code']) {
				return 4;		//验证码错误返回信息
			}
		}
		$this->binz_db->set_update_sql('#binz#member',array('login_time'=>time(),'login_old_time'=>$member_info['login_time']),array('field'=>'member_id','value'=>intval($member_info['member_id'])));
		/*用户验证完毕，进行session赋值*/
		$_SESSION['member_id']		= $member_info['member_id'];
		$_SESSION['member_name']	= $member_info['member_name'];
		$_SESSION['binz_code']		= '';

		return 1;
	}
	/**
	 * mod_front_check_email
	 *
	 * 检查是否已经存在此email
	 * @access  public（权限）
	 * 
	 */
	public function mod_front_check_email($email,$member_name) {
		$member_info	= array();
		$member_sql		= "SELECT * FROM #binz#member
							WHERE member_name!='".$member_name."' AND member_email='".trim($email)."'";
		$member_info	= $this->binz_db->set_select_sql($member_sql,0);
		if($member_info['member_name'] == '') {
			return true;		//没有重复的email
		} else {
			return false;		//有重复的email
		}
	}
	/**
	 * mod_front_member_out
	 *
	 * 会员退出
	 * @access  public（权限）
	 *
	 */
	public function mod_front_member_out() {

		$_SESSION['member_id']		= '';
		$_SESSION['member_name']	= '';

		return true;
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>