<?php
/***
*
*@package binzcms
*@version $id:ModFrontHomeClass.php, v 1.0
*@author 斌子
*@Mon Apr 13 01:16:24 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * ModFrontHomeClass
 * 会员中心应用类
 * 
 */
class ModFrontHomeClass extends BaseClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		parent::__construct($act);
	}
	/**
	 * mod_front_member_info
	 *
	 * 取得会员信息
	 * @access  public（权限）
	 * 
	 * @return  array	会员信息
	 */
	public function mod_front_member_info() {
		$member_info	= array();
		$member_sql		= '';

		$member_sql		= "SELECT * FROM #binz#member AS member
							WHERE member.member_id=".$_SESSION['member_id'];
		$member_info	= $this->binz_db->set_select_sql($member_sql,0);

		return $member_info;
	}
	/**
	 * mod_front_member_edit
	 *
	 * 会员信息修改保存
	 * @access  public（权限）
	 * 
	 * @return  bool
	 */
	public function mod_front_member_edit() {
		$edit_state				= false;
		$member_array			= array();

		$member_array['member_sex']		= intval($_POST['member_sex']);
		$member_array['member_qq']		= trim($_POST['member_qq']);
		$member_array['member_msn']		= trim($_POST['member_msn']);
		$member_array['member_email']	= trim($_POST['member_email']);

		$edit_state		= $this->binz_db->set_update_sql('#binz#member',$member_array,array('field'=>'member_id','value'=>$_SESSION['member_id']));
		return $edit_state;
	}
	/**
	 * mod_front_upload_img
	 *
	 * 会员头像上传
	 * @access  public（权限）
	 * @param   string	$path		头像路径
	 * @return  string	上传后的路径
	 */
	public function mod_front_upload_img($path) {
		$img_path		= '';
		$edit_state		= false;
		/*上传头像操作*/
		if($_FILES['usr_portrait']['name'] != '') {
			$upload_image				= $this->import_class('Image',ROOT_PATH.'/include');
			$upload_image->upload_dir	= $path;
			$img_path					= $upload_image->upload_image($_FILES['usr_portrait'],'n');
			/*生成缩微图头像*/
			$upload_image->create_thump(ROOT_PATH.$img_path,ROOT_PATH.'/'.$path);

			if($_POST['member_img'] != '') @unlink(ROOT_PATH.trim($_POST['member_img']));
		}
		/*已有头像*/
		if (trim($_POST['member_img']) != '' and $_FILES['usr_portrait']['name'] == '') {
			$img_path					= trim($_POST['member_img']);
		}

		$edit_state		= $this->binz_db->set_update_sql('#binz#member',array('member_img'=>$img_path),array('field'=>'member_id','value'=>$_SESSION['member_id']));
		return $edit_state;
	}
	/**
	 * mod_front_change_passwd
	 *
	 * 密码修改保存
	 * @access  public（权限）
	 * 
	 * @return  int
	 */
	public function mod_front_change_passwd() {
		$change_state		= false;
		$member_info		= array();

		if(trim($_POST['new_passwd']) != '') {
			if(trim($_POST['member_passwd']) != substr(md5(trim($_POST['old_passwd'])),0,16)) {
				return 3;		//旧密码输入不正确
			}

			if(trim($_POST['new_passwd']) != trim($_POST['con_passwd'])) {
				return 2; 			//密码为空，或确认密码和新密码不相同
			}
			$member_info['member_passwd']	= substr(md5(trim($_POST['new_passwd'])),0,16);	//管理员密码
		}

		$change_state	= $this->binz_db->set_update_sql('#binz#member',$member_info,array('field'=>'member_id','value'=>$_SESSION['member_id']));

		return $change_state;
	}
	/**
	 * mod_comments_num
	 *
	 * 评论总数
	 * @access  public（权限）
	 *
	 * @return  int
	 */
	public function mod_comments_num() {
		$sql	= "SELECT comment_id FROM #binz#article_comment
					WHERE member_id=".$_SESSION['member_id'];
		return $this->binz_db->get_total_row($sql);
	}
	/**
	 * mod_comments_list
	 *
	 * 评论列表
	 * @access  private（权限）
	 * @param   int		$num	评论显示条数，空为列表
	 * @return  
	 */
	public function mod_comments_list($num='') {
		$comment_sql		= '';
		$comment_array		= array();
		if($num != '') {
			$comment_sql	= "SELECT c.*,a.article_title,a.article_id FROM #binz#article_comment AS c
								INNER JOIN #binz#article AS a ON c.article_id=a.article_id
								WHERE c.member_id=".$_SESSION['member_id']."
								ORDER BY c.comment_id DESC LIMIT 0,".$num;
			$comment_array	= $this->binz_db->set_select_sql($comment_sql,1);
		}
		return $comment_array;
	}
	/**
	 * mod_front_comments_list
	 *
	 * 评论列表
	 * @access  public（权限）
	 * 
	 * @return  array
	 */
	public function mod_front_comments_list($binz_page,$page_num) {
		$comments_array			= array();
		$comments_sql			= '';
		$limit_sql				=  "LIMIT ".(intval($binz_page)-(intval($binz_page)>=1 ? 1 : 0))*$page_num.",$page_num";

		$comment_sql			= "SELECT c.*,a.article_title,a.article_id FROM #binz#article_comment AS c
								INNER JOIN #binz#article AS a ON c.article_id=a.article_id
								WHERE c.member_id=".$_SESSION['member_id']."
								ORDER BY c.comment_id DESC ".$limit_sql;
		$comments_array['list']	= $this->binz_db->set_select_sql($comment_sql);
		$comments_array['count']= $this->binz_db->set_select_sql("SELECT COUNT(comments_id) AS comments_num FROM #binz#article_comment WHERE c.member_id=".$_SESSION['member_id'],0);

		return $comments_array;
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>