<?php
if(!defined('BINZCMS')) {
	exit('Access Denied');
}

define('SOFT_NAME', 'Binzcms');
define('SOFT_VERSION', CMS_VERSION);
define('SOFT_RELEASE', VERSION_TIME);
define('INSTALL_LANG', 'SC_UTF8');

define('CONFIG', ROOT_PATH.'./config/config.ini.php');
define('DBCONFIG',ROOT_PATH.'./data/database.ini.php');

$sqlfile = ROOT_PATH.'./install/binzcms.sql';
$testsqlfile = ROOT_PATH.'./install/binztest.sql';
$lockfile = ROOT_PATH.'./data/install.lock';

define('CHARSET', 'utf-8');
define('DBCHARSET', 'utf8');

define('ORIG_TABLEPRE', 'binz_');

define('METHOD_UNDEFINED', 255);
define('ENV_CHECK_RIGHT', 0);
define('ERROR_CONFIG_VARS', 1);
define('SHORT_OPEN_TAG_INVALID', 2);
define('INSTALL_LOCKED', 3);
define('DATABASE_NONEXISTENCE', 4);
define('PHP_VERSION_TOO_LOW', 5);
define('MYSQL_VERSION_TOO_LOW', 6);
define('DBNAME_INVALID', 15);
define('DATABASE_ERRNO_2003', 16);
define('DATABASE_ERRNO_1044', 17);
define('DATABASE_ERRNO_1045', 18);
define('DATABASE_CONNECT_ERROR', 19);
define('TABLEPRE_INVALID', 20);
define('CONFIG_UNWRITEABLE', 21);
define('ADMIN_USERNAME_INVALID', 22);
define('ADMIN_EMAIL_INVALID', 25);
define('ADMIN_EXIST_PASSWORD_ERROR', 26);
define('ADMININFO_INVALID', 27);
define('LOCKFILE_NO_EXISTS', 28);
define('TABLEPRE_EXISTS', 29);
define('ERROR_UNKNOW_TYPE', 30);
define('ENV_CHECK_ERROR', 31);
define('UNDEFINE_FUNC', 32);
define('MISSING_PARAMETER', 33);
define('LOCK_FILE_NOT_TOUCH', 34);

$func_items = array('mysql_connect', 'fsockopen', 'gethostbyname', 'file_get_contents', 'xml_parser_create','file_put_contents');

$env_items = array
(
	'os' => array('c' => 'PHP_OS', 'r' => 'notset', 'b' => 'unix'),
	'php' => array('c' => 'PHP_VERSION', 'r' => '5.0', 'b' => '5.0'),
	'attachmentupload' => array('r' => 'notset', 'b' => '2M'),
	'gdversion' => array('r' => '1.0', 'b' => '2.0'),
	'diskspace' => array('r' => '10M', 'b' => 'notset'),
);

$dirfile_items = array
(
	'config' => array('type' => 'dir', 'path' => './config'),
	'cache' => array('type' => 'dir', 'path' => './cache'),
	'upload' => array('type' => 'dir', 'path' => './upload'),
	'data' => array('type' => 'dir', 'path' => './data'),
	'databack' => array('type' => 'dir', 'path' => './data/databack'),
	'session' => array('type' => 'dir', 'path' => './data/session')
);

$form_db_init_items = array
(
	'dbinfo' => array
	(
		'dbhost' => array('type' => 'text', 'required' => 1, 'reg' => '/^.*$/', 'value' => array('type' => 'string', 'var' => 'localhost')),
		'dbname' => array('type' => 'text', 'required' => 1, 'reg' => '/^.*$/', 'value' => array('type' => 'string', 'var' => 'binzcms')),
		'dbuser' => array('type' => 'text', 'required' => 0, 'reg' => '/^.*$/', 'value' => array('type' => 'string', 'var' => 'root')),
		'dbpw' => array('type' => 'password', 'required' => 0, 'reg' => '/^.*$/', 'value' => array('type' => 'string', 'var' => '')),
		'tablepre' => array('type' => 'text', 'required' => 0, 'reg' => '/^.*+/', 'value' => array('type' => 'string', 'var' => 'binz_')),
		'binztest' => array('type' => 'checkbox', 'required' => 0, 'reg' => '/^1$/', 'value' => array('type' => 'constant', 'var' => '1')),
	),
	'admininfo' => array
	(
		'binzcmsuser' => array('type' => 'text', 'required' => 1, 'reg' => '/^.*$/','value' => array('type' => 'string', 'var' => 'admin')),
		'binzcmspw' => array('type' => 'password', 'required' => 1, 'reg' => '/^.*$/'),
		'binzcmspw2' => array('type' => 'password', 'required' => 1, 'reg' => '/^.*$/'),
		'webmail' => array('type' => 'text', 'required' => 1, 'reg' => '/@/', 'value' => array('type' => 'string', 'var' => 'admin@admin.com')),
	),
	'webinfo' => array
	(
		'webname' => array('type' => 'text', 'required' => 1, 'reg' => '/^.*$/', 'value' => array('type' => 'string', 'var' => 'Binzcms内容管理系统')),
		'weburl' => array('type' => 'text', 'required' => 1, 'reg' => '/^https?:\/\//', 'value' => array('type' => 'var', 'var' => 'binzcms_url')),
	)
);

?>