<?php
/***
*
*@package binzcms
*@version $id:F_CommonClass.php, v 1.0
*@author 斌子
*@Tue Apr 14 22:26:00 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * F_CommonClass
 * 前台公用显示类
 * 
 */
class F_CommonClass {

	private $sql_class;
	private $tpl_class;
	private $com_class;

	public function __construct($sql_class,$tpl_class,$com_class) {
		if(SHOW_TYPE != 'front') return '';
		$this->sql_class	= $sql_class;
		$this->tpl_class	= $tpl_class;
		$this->com_class	= $com_class;
		$this->f_top_menu();
		$this->f_menu_url('class');
		$this->f_member_code();
		$this->f_footer_menu();
	}
	/**
	 * f_top_menu
	 *
	 * 前台头部显示
	 * @access  public（权限）
	 * 
	 */
	public function f_top_menu() {
		$top_menu_array	= array();
		$top_menu_sql	= '';

		$top_menu_sql	= "SELECT * FROM #binz#article_class AS article_class
							WHERE article_class.class_state=1 AND article_class.top_menu=1
							ORDER BY article_class.class_sort";
		$top_menu_array	= $this->sql_class->set_select_sql($top_menu_sql);

		$this->tpl_class->set_var('top_menu',$top_menu_array);

	}
	/**
	 * f_menu_url
	 *
	 * 分类导航
	 * @access  public（权限）
	 * @param   string	$type	导航类型
	 * @return  
	 */
	public function f_menu_url($type) {
		$array		= array();
		if($type == 'class') {
			$class_id	= intval($_GET['class_id']);
			$class_sql	= "SELECT class_name,class_top_id,class_id FROM #binz#article_class";
			$class_array= $this->sql_class->set_select_sql($class_sql);
			if(empty($class_array)) return '';
			$key_id		= 0;
			while (1) {
				foreach ($class_array AS $val)
				{
					if ($class_id == $val['class_id'])
					{
						$class_id = $val['class_top_id'];

						$array[$key_id]['class_id']   = $val['class_id'];
						$array[$key_id]['class_name'] = $val['class_name'];

						$key_id++;
						break;
					}
				}

				if ($key_id == 0 || $class_id == 0)
				{
					break;
				}
			}
			krsort($array);
			$this->tpl_class->set_var('class_menu',$array);
		}
	}
	/**
	 * f_member_code
	 *
	 * 前台验证码
	 * @access  public（权限）
	 * @return  code
	 */
	public function f_member_code() {
		/*会员登录的验证码*/
		$this->tpl_class->set_var('login_code',$this->com_class->create_binz_code(''));
	}
	/**
	 * f_footer_menu
	 *
	 * 前台底部导航
	 * @access  public（权限）
	 * @return  
	 */
	public function f_footer_menu() {
		$footer_array	= array();
		$footer_sql	= '';

		$footer_sql	= "SELECT * FROM #binz#sys_article AS article
							WHERE article.sys_article_state=1 and article.sys_article_class=2
							ORDER BY article.sys_article_sort";
		$footer_array= $this->sql_class->set_select_sql($footer_sql);

		$this->tpl_class->set_var('footer_array',$footer_array);
	}
}
?>