<?php
/***
*
*@package binzcms
*@version $id:SqlExtClass.php, v 1.0
*@author 斌子
*@Mon Jan 05 02:12:49 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * SqlExtClass
 * sql扩展
 * 
 */
include(ROOT_PATH."/include/SqlClass.php");
class SqlExtClass extends SqlClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($data_name='',$data_user='',$data_passwd='',$data_prefix='',$data_url='',$connect_type=false,$data_port='') {
		parent::__construct($data_name,$data_user,$data_passwd,$data_prefix,$data_url,$connect_type,$data_port);
	}
	/**
	 * set_insert_sql_value
	 *
	 * 将要插入数据表的值进行处理，值以数组形式传入函数
	 * @access  public（权限）
	 * @param 	string	$table		数据表名称
	 * @param   array	$array		要插入数据表的值
	 * @return  bool
	 */
	public function set_insert_sql_value($table,$array) {
		$insert_sql	= '';
		if(is_array($array) and !empty($array)) {
			$field		= ' (';
			$value		= ' (';
			foreach ($array as $key => $val) {
				$field	.= "`".$key."`,";
				$value	.= $val === 'NULL' ? "NULL," : "'".$val."',";
			}
			$field		= substr($field,0,-1).')';
			$value		= substr($value,0,-1).')';
			$insert_sql	= "INSERT INTO ".$table.$field." VALUES ".$value;
		}

		return $this->one_query($insert_sql);
	}
	/**
	 * set_update_sql
	 *
	 * sql更新语句处理
	 * @access  public（权限）
	 * @param   string	$table		数据表名称
	 * @param   array	$array		更新内容，数组形式显示，键名为字段名，键值为数据内容
	 * @param   array	$where_array匹配条件，键名为field是字段，简直value是匹配值
	 * @param   string	$other_str	补充的sql语句部分
	 * @return  bool
	 */
	public function set_update_sql($table,$array,$where_array,$other_str='') {
		$update_sql	= '';
		$where		= '';
		if(is_array($array) and !empty($array)) {
			$set_str	= ' SET ';
			foreach ($array as $key => $val) {
				$set_str	.= $key."=".(is_int($val) ? $val : "'".$val."'").",";
			}
			$set_str	= substr($set_str,0,-1);
			$where		= " WHERE ".(count($where_array)>0 ?($where_array['field']."=".(is_int($where_array['value']) ? $where_array['value'] : "'".$where_array['value']."'")) : '1=1');
			$update_sql	= "UPDATE ".$table.$set_str.$where.$other_str;
		}
		return $this->one_query($update_sql);
	}
	/**
	 * set_select_sql
	 *
	 * select语句
	 * @access  public（权限）
	 * @param   string	$db_sql			sql语句
	 * @param 	integer $return_type	返回类型0为返回单条信息的数组，1为多条
	 * @return  array	select结果信息	注：因为select的组合繁多，所以不具体写成处理方法，增加自由度
	 */
	public function set_select_sql($db_sql,$return_type=1) {
		$array_info	= array();
		$row		= array();

		if($return_type	== 1) {
			$result	= $this->sql_query($db_sql);
			while ($row = $this->sql_fetch_array($result)) {
				$array_info[]	= $row;
			}
		} else {
			$array_info	= $this->sql_one_fetch($db_sql);
		}
		return $array_info;
	}
	/**
	 * set_del_sql
	 *
	 * sql删除语句处理
	 * @access  public（权限）
	 * @param   string	$table		数据表名称
	 * @param   array	$array		删除条件，数组形式显示
	 * @param   string	$del_type	删除条件的连接类型，and或是or
	 * @param   string	$field_name	删除条件的字段名称
	 * @return  bool
	 */
	public function set_del_sql($table,$array,$del_type='',$field_name='') {
		$del_sql	= '';
		$where		= '';
		if(is_array($array) and !empty($array)) {
			$set_str	= '';
			if(count($array) == 1) {
				$set_str	.=  key($array)."=".(is_int(current($array)) ? current($array) : "'".current($array)."'");
			} elseif (count($array) > 1) {
				foreach ($array as $key => $val) {
					$set_str	.= ' '.($field_name == '' ? $key : $field_name)."=".(is_int($val) ? $val : "'".$val."'")." ".$del_type;
				}
			} else {
				$set_str	= '';
			}
			$set_str	= ($set_str != '' ? (count($array)>1 ? substr($set_str,0,-strlen($del_type)) : $set_str) : " 1=1 ");
		}
		$where		= " WHERE ".$set_str;
		$del_sql	= "DELETE FROM ".$table.$where;
		return $this->one_query($del_sql);
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>