<?php
/***
*
*@package binzcms
*@version $id:CharsetClass.php, v 1.0
*@author 斌子
*@Mon Sep 13 14:18:19 GMT 2010
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * CharsetClass
 * 字符集转换
 * 
 */
class CharsetClass {
	/**
	 * 转换字符编码
	 *
	 * @param string $content	转换内容
	 * @param string $charset	字符集
	 * @return array[]
	 */
	function change_charset($content,$charset='') {
		if($charset == 'utf-8' or $charset == '') {
			return $content;
		}
		if($charset == 'utf8_to_gbk' or $charset == 'utf8_to_gb2312' or $charset == 'gbk') {		//utf8转换为gbk
			return self::utf8_to_gb2312($content);
		}
		if($charset == 'gbk_to_utf8' or $charset == 'gb2312_to_utf8') {		//gbk转换为utf8
			return self::gb2312_to_utf8($content);
		}
		if ($charset == 'utf8_to_big5') {									//utf8转换为big5
			return self::utf8_to_big5($content);
		}
		if($charset == 'big5_to_utf8') {									//big转换为utf8
			return self::big5_to_utf8($content);
		}
		if($charset == 'gbk_to_big5' or $charset == 'gb2312_to_big5') {		//gbk转换为big5
			return self::gb2312_to_big5($content);
		}
		if($charset == 'big5_to_gbk' or $charset == 'big5_to_gb2312') {		//big转换为gbk
			return self::big5_to_gb2312($content);
		}
	}
	/**
	 * utf-8转gb2312
	 *
	 * @param string $content	转换内容
	 * @return string
	 */
	function utf8_to_gb2312( $content ) {
		if(function_exists('mb_convert_encoding')) {
			return mb_convert_encoding($content,'gb2312','utf-8');
		}
		$fp = fopen(ROOT_PATH.'/include/encode/utf8-gb.tab', 'r' );
		$len = strlen($content);
		$outstr = '';
		for( $i = $x = 0 ; $i < $len ; $i++ ) {
			$b1 = ord($content[$i]);
			if( $b1 < 0x80 ) {
				$outstr[$x++] = chr($b1);
			}
			elseif( $b1 >= 224 ) {
				$b1 -= 224;
				$b2 = ($i+1 >= $len) ? 0 : ord($content[$i+1]) - 128;
				$b3 = ($i+2 >= $len) ? 0 : ord($content[$i+2]) - 128;
				$i += 2;
				$uc = $b1 * 4096 + $b2 * 64 + $b3 ;
				fseek( $fp, $uc * 2 );
				$gb = fread( $fp, 2 );
				$outstr[$x++] = $gb[0];
				$outstr[$x++] = $gb[1];
			}
			elseif( $b1 >= 192 ) {
				printf( "[%02X%02X]", $b1, ord($content[$i+1]) );
				$b1 -= 192;
				$b2 = ($i+1>=$len) ? 0 : ord($content[$i+1]) - 128;
				$i++;
				$uc = $b1 * 64 + $b2 ;
				fseek( $fp, $uc * 2 );
				$gb = fread( $fp, 2 );
				$outstr[$x++] = $gb[0];
				$outstr[$x++] = $gb[1];
			}
		}
		fclose($fp);
		if( $content != '' ) {
			return join( '', $outstr);
		}
	}
	/**
	 * gb2312转utf-8
	 *
	 * @param string $content	转换内容
	 * @return string
	 */
	function gb2312_to_utf8( $content ) {
		if(function_exists('mb_convert_encoding')) {
			return mb_convert_encoding($content,'utf-8','gb2312');
		}
		$fp = fopen(ROOT_PATH.'/include/encode/gb-utf8.tab', 'r' );
		$len = strlen($content);
		$outstr = '';
		for( $i = $x = 0 ; $i < $len ; $i++ ) {
			$h = ord($content[$i]);
			if( $h > 160 ) {
				$l = ( $i+1 >= $len ) ? 32 : ord($content[$i+1]);
				fseek( $fp, ($h-161)*188+($l-161)*2 );
				$uni = fread( $fp, 2 );
				$codenum = ord($uni[0])*256 + ord($uni[1]);
				if( $codenum < 0x800 ) {
					$outstr[$x++] = chr( 192 + $codenum / 64 );
					$outstr[$x++] = chr( 128 + $codenum % 64 );
				}
				else {
					$outstr[$x++] = chr( 224 + $codenum / 4096 );
					$codenum %= 4096;
					$outstr[$x++] = chr( 128 + $codenum / 64 );
					$outstr[$x++] = chr( 128 + ($codenum % 64) );
				}
				$i++;
			}
			else
			$outstr[$x++] = $content[$i];
		}
		fclose($fp);
		if( $content != '' )
		return join( '', $outstr);
	}
	/**
	 * big5转gb
	 *
	 * @param string $content	转换内容
	 * @return string
	 */
	function big5_to_gb2312( $content ) {
		if(function_exists('mb_convert_encoding')) {
			return mb_convert_encoding($content,'gb2312','big5');
		}

		$fp = fopen(ROOT_PATH.'/include/encode/big5-gb.tab', 'r' );

		$len = strlen($content);
		for( $i = 0 ; $i < $len ; $i++ ) {
			$h = ord($content[$i]);
			if( $h >= 160 ) {
				$l = ($i+1 >= $len) ? 32 : ord($content[$i+1]);
				if( $h == 161 && $l == 64 )
				$gb = '  ';
				else {
					fseek( $fp, (($h-160)*255+$l-1)*3 );
					$gb = fread( $fp, 2 );
				}
				$content[$i] = $gb[0];
				$content[$i+1] = $gb[1];
				$i++;
			}
		}
		fclose($fp);
		return $content;
	}
	/**
	 * gb转bg
	 *
	 * @param string $content	转换内容
	 * @return string
	 */
	function gb2312_to_big5( $content ) {
		if(function_exists('mb_convert_encoding')) {
			return mb_convert_encoding($content,'big5','gb2312');
		}
		$fp = fopen(ROOT_PATH.'/include/encode/gb-big5.tab', 'r' );

		$len = strlen($content);
		for( $i = 0 ; $i < $len ; $i++ ) {
			$h = ord($content[$i]);
			if( $h > 160 && $h < 248 ) {
				$l = ($i+1 >= $len) ? 32 : ord($content[$i+1]);
				if( $l > 160 && $l < 255 ) {
					fseek( $fp, (($h-161)*94+$l-161)*3 );
					$bg = fread( $fp, 2 );
				}
				else
				$bg = '  ';
				$content[$i] = $bg[0];
				$content[$i+1] = $bg[1];
				$i++;
			}
		}
		fclose($fp);
		return $content;
	}
	/**
	 * big5转utf-8
	 *
	 * @param string $content	转换内容
	 * @return string
	 */
	function big5_to_utf8( $content ) {
		if(function_exists('mb_convert_encoding')) {
			return mb_convert_encoding($content,'gb2312','utf-8');
		}
		$fp = fopen(ROOT_PATH.'/include/encode/big5-utf8.tab', 'r' );
		$len = strlen($content);
		$outstr = '';
		for( $i = $x = 0 ; $i < $len ; $i++ ) {
			$h = ord($content[$i]);
			if( $h >= 160 ) {
				$l = ( $i+1 >= $len ) ? 32 : ord($content[$i+1]);
				if( $h == 161 && $l == 64 )
				$uni = '  ';
				else {
					fseek( $fp, ($h-160)*510+($l-1)*2 );
					$uni = fread( $fp, 2 );
				}
				$codenum = ord($uni[0])*256 + ord($uni[1]);
				if( $codenum < 0x800 ) {
					$outstr[$x++] = chr( 192 + $codenum / 64 );
					$outstr[$x++] = chr( 128 + $codenum % 64 );
				}
				else {
					$outstr[$x++] = chr( 224 + $codenum / 4096 );
					$codenum %= 4096;
					$outstr[$x++] = chr( 128 + $codenum / 64 );
					$outstr[$x++] = chr( 128 + ($codenum % 64) );
				}
				$i++;
			}
			else
			$outstr[$x++] = $content[$i];
		}
		fclose($fp);
		if( $content != '' )
		return join( '', $outstr);
	}
	/**
	 * utf-8转big5
	 *
	 * @param string $content	转换内容
	 * @return string
	 */
	function utf8_to_big5( $content ) {
		if(function_exists('mb_convert_encoding')) {
			return mb_convert_encoding($content,'big5','utf-8');
		}
		$fp = fopen(ROOT_PATH.'/include/encode/utf8-big5.tab', 'r' );
		$len = strlen($content);
		$outstr = '';
		for( $i = $x = 0 ; $i < $len ; $i++ ) {
			$b1 = ord($content[$i]);
			if( $b1 < 0x80 ) {
				$outstr[$x++] = chr($b1);
			}
			elseif( $b1 >= 224 ) {
				$b1 -= 224;
				$b2 = ord($content[$i+1]) - 128;
				$b3 = ord($content[$i+2]) - 128;
				$i += 2;
				$uc = $b1 * 4096 + $b2 * 64 + $b3 ;
				fseek( $fp, $uc * 2 );
				$bg = fread( $fp, 2 );
				$outstr[$x++] = $bg[0];
				$outstr[$x++] = $bg[1];
			}
			elseif( $b1 >= 192 ) {
				printf( "[%02X%02X]", $b1, ord($content[$i+1]) );
				$b1 -= 192;
				$b2 = ord($content[$i]) - 128;
				$i++;
				$uc = $b1 * 64 + $b2 ;
				fseek( $fp, $uc * 2 );
				$bg = fread( $fp, 2 );
				$outstr[$x++] = $bg[0];
				$outstr[$x++] = $bg[1];
			}
		}
		fclose($fp);
		if( $content != '' ) {
			return join( '', $outstr);
		}
	}
}
?>