<?php
/***
*
*@package binzcms
*@version $id:FrontSearchClass.php, v 1.0
*@author 斌子
*@Sat Sep 11 14:10:29 GMT 2010
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * FrontSearchClass
 * 前台搜索
 * 
 */
include(MOD_PATH."/ModFrontSearchClass.php");
class FrontSearchClass extends ModFrontSearchClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "base_back_index";
		}
		/*合法action*/
		$this->allow_action	= array(
		'base_back_index',			//返回首页
		'front_all_search',			//全部搜索
		'front_article_search',		//文章搜索
		'front_image_search'		//图片搜索
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "base_back_index";
		}
		/*载入语言包*/
		$this->import_language('FrontArticle,FrontImage,FrontCommon');
		
		$this->$act();
	}
	/**
	 * front_article_search
	 *
	 * 文章搜索
	 * @access  private（权限）
	 * 
	 */
	private function front_article_search() {
		$article_list_array		= array();
		$perpage				= 20;			//每页记录数
		$article_new_list		= array();
		$article_hot_list		= array();

		/*文章列表*/
		$article_list_array		= $this->mod_front_search_article_list($_GET['binz_page'],$perpage);
		/*如果该分类不存在的话那么返回首页*/
		if($article_list_array == false) {
			$this->base_back_index();
		}
		$this->binz_tpl->set_var('article_array',$article_list_array['list']);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->set_page(array('total'=>$article_list_array['count']['article_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));

		/*最新文章列表（本分类及分类子集）*/
		$article_new_list	= $this->mod_front_article_type('article_id',6);
		$this->binz_tpl->set_var('article_new_list',$article_new_list);
		/*最热文章列表（本分类及分子子集）*/
		$article_hot_list	= $this->mod_front_article_type('article_click',6);
		$this->binz_tpl->set_var('article_hot_list',$article_hot_list);

		$this->binz_tpl->set_tag('search_article_list');
	}
	/**
	 * front_image_search
	 *
	 * 图片搜索
	 * @access  private（权限）
	 * 
	 */
	private function front_image_search() {
		$article_list_array		= array();
		$perpage				= 12;			//每页记录数
		$article_new_list		= array();
		$article_hot_list		= array();

		/*文章列表*/
		$article_list_array		= $this->mod_front_search_article_list($_GET['binz_page'],$perpage,'image');
		/*如果该分类不存在的话那么返回首页*/
		if($article_list_array == false) {
			$this->base_back_index();
		}
		$this->binz_tpl->set_var('article_array',$article_list_array['list']);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->set_page(array('total'=>$article_list_array['count']['article_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));

		/*最新文章列表（本分类及分类子集）*/
		$article_new_list	= $this->mod_front_article_type('article_id',6,'image');
		$this->binz_tpl->set_var('article_new_list',$article_new_list);
		/*最热文章列表（本分类及分子子集）*/
		$article_hot_list	= $this->mod_front_article_type('article_click',6,'image');
		$this->binz_tpl->set_var('article_hot_list',$article_hot_list);
		$this->binz_tpl->set_tag('search_pic_list');
	}
	/**
	 * front_all_search
	 *
	 * 全部搜索
	 * @access  private（权限）
	 * 
	 */
	private function front_all_search() {
		$article_list_array		= array();
		$perpage				= 20;			//每页记录数
		$article_new_list		= array();
		$article_hot_list		= array();

		/*文章列表*/
		$article_list_array		= $this->mod_front_search_article_list($_GET['binz_page'],$perpage,'all');
		/*如果该分类不存在的话那么返回首页*/
		if($article_list_array == false) {
			$this->base_back_index();
		}
		$this->binz_tpl->set_var('article_array',$article_list_array['list']);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->set_page(array('total'=>$article_list_array['count']['article_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));

		/*最新文章列表（本分类及分类子集）*/
		$article_new_list	= $this->mod_front_article_type('article_id',6,'all');
		$this->binz_tpl->set_var('article_new_list',$article_new_list);
		/*最热文章列表（本分类及分子子集）*/
		$article_hot_list	= $this->mod_front_article_type('article_click',6,'all');
		$this->binz_tpl->set_var('article_hot_list',$article_hot_list);

		$this->binz_tpl->set_tag('search_article_list');
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>