<?php
/***
*
*@package binzcms
*@version $id:FrontRssClass.php, v 1.0
*@author 斌子
*@Sun Sep 12 15:03:02 GMT 2010
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * FrontRssClass
 * rss输出
 * 
 */
include(MOD_PATH."/ModFrontRssClass.php");
class FrontRssClass extends ModFrontRssClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "base_back_index";
		}
		/*合法action*/
		$this->allow_action	= array(
		'base_back_index',			//返回首页
		'front_rss'					//rss输出
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "base_back_index";
		}

		$this->$act();
	}
	/**
	 * front_rss
	 *
	 * rss输出
	 * @access  private（权限）
	 * 
	 */
	private function front_rss() {
		header('Content-Type: application/xml; charset=utf-8');
		header('Cache-Control: no-cache, must-revalidate');
		header('Expires: Fri, 14 Mar 1980 20:53:00 GMT');
		header('Last-Modified: ' . date('r'));
		header('Pragma: no-cache');
		
		include(ROOT_PATH.'/include/RssClass.php');
		$rss_class = new RSSBuilder('utf-8','',htmlspecialchars(WEB_NAME),htmlspecialchars(WEB_DESCRIPTION));
		$rss_class->addDCdata('', 'http://www.binzcms.com', date('r'));

		$article_array		= $this->mod_front_article_rss(20);
		$url_array			= array('article'	=>'index.php?ctl=article&amp;act=front_article_content&amp;article_id=',
									'image'		=>'index.php?ctl=pic&amp;act=front_pic_content&amp;article_id=');
		if($article_array != '') {
			foreach ($article_array as $val) {
				$about		= '';
				$title		= htmlspecialchars($val['article_title']);
				$art_url	= $url_array[$val['class_type_tag']].$val['article_id']."&amp;from=rss";
				$art_desc	= htmlspecialchars($val['article_description']);
				$art_class	= htmlspecialchars($val['class_name']);
				$art_date	= $val['article_time'];
				$rss_class->addItem($about, $title,$art_url,$art_desc,$art_class,$art_date);
			}
		}
		
		$rss_class->outputRSS('2.00');
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>