<?php
/***
*
*@package binzcms
*@version $id:FrontOtherClass.php, v 1.0
*@author 斌子
*@Thu Mar 05 00:05:32 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * FrontOtherClass
 * 前台其他非重要显示控制类
 * 
 */
include(MOD_PATH."/ModFrontOtherClass.php");
class FrontOtherClass extends ModFrontOtherClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "base_back_index";
		}
		/*合法action*/
		$this->allow_action	= array(
		'base_back_index',			//返回首页
		'poll_view',				//投票显示
		'notice_show',				//网站公告显示
		'footer'					//底部导航显示
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state) {
			$act	= "base_back_index";
		}

		/*载入语言包*/
		$this->import_language('FrontOther,FrontCommon');
		
		$this->$act();
	}
	/**
	 * poll_view
	 *
	 * 投票显示
	 * @access  private（权限）
	 * 
	 */
	private function poll_view() {
		/*最新文章，最热文章*/
		$article_class	= $this->import_class('ModFrontIndex',MOD_PATH,'mod');
		$this->binz_tpl->set_var('new_art',$article_class->mod_front_new_article(6));
		$this->binz_tpl->set_var('hot_art',$article_class->mod_front_hot_article(6));

		if($_POST['vote_type'] != '') {//投票操作
			if(is_array($_POST['cms_vote'])) {
				foreach ($_POST['cms_vote'] as $v) {
					if(intval($v) != 0) {
						$this->mod_front_vote_add(intval($v));
					}
				}
			} else {
				if(intval($_POST['cms_vote']) != 0) {
					$this->mod_front_vote_add(intval($_POST['cms_vote']));
				}
			}
		}

		if(intval($_GET['vote_id']) != 0) {	//投票显示
			$vote_array		= $this->mod_front_vote_view();

			$this->binz_tpl->set_var('vote_array',$vote_array);
			$this->binz_tpl->set_var('option_array',unserialize($vote_array['vote_body']));
		}

		$this->binz_tpl->set_tag('poll');
	}
	/**
	 * notice_show
	 *
	 * 网站公告显示
	 * @access  private（权限）
	 * 
	 */
	private function notice_show() {
		$notice_info	= array();

		$notice_info	= $this->mod_front_system_article_view(1);
		$this->binz_tpl->set_var('article_info',$notice_info);
		/*最新和最热文章*/
		self::show_article();

		$this->binz_tpl->set_tag('aboutus');
	}
	/**
	 * footer
	 *
	 * 底部导航内容显示
	 * @access  private（权限）
	 * 
	 */
	private function footer() {
		$footer_info	= array();

		$footer_info	= $this->mod_front_system_article_view(2);
		$this->binz_tpl->set_var('article_info',$footer_info);
		/*最新和最热文章*/
		self::show_article();

		$this->binz_tpl->set_tag('aboutus');
	}
	/**
	 * show_article
	 *
	 * 显示最新文章和最热文章
	 * @access  private（权限）
	 * 
	 */
	private function show_article() {
		/*最新文章列表*/
		$article_new_list	= $this->mod_front_article_type('article_id',6);
		$this->binz_tpl->set_var('article_new_list',$article_new_list);
		/*最热文章列表*/
		$article_hot_list	= $this->mod_front_article_type('article_click',6);
		$this->binz_tpl->set_var('article_hot_list',$article_hot_list);
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>