<?php
/***
*
*@package binzcms
*@version $id:FrontHomeClass.php, v 1.0
*@author 斌子
*@Mon Apr 13 01:14:55 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * FrontHomeClass
 * 会员中心控制类
 * 
 */
include(MOD_PATH."/ModFrontHomeClass.php");
class FrontHomeClass extends ModFrontHomeClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct($act) {
		/*获取方法*/
		if(empty($act)) {
			$act	= "base_back_index";
		}
		/*合法action*/
		$this->allow_action	= array(
		'base_back_index',			//返回首页
		'front_home',				//会员中心
		'front_member_edit',		//会员修改
		'front_member_img',			//头像上传
		'front_member_edit_save',	//会员资料保存
		'front_change_pw',			//修改密码
		'front_change_pw_save',		//修改密码保存
		'front_comments'			//会员评论
		);

		parent::__construct($act);

		/*非法action，$act从新赋值*/
		if(!$this->action_state or $_SESSION['member_id'] == '') {
			$act	= "base_back_index";
		}
		/*载入语言包*/
		$this->import_language('FrontHome,FrontCommon');

		$this->$act();
	}
	/**
	 * front_home
	 *
	 * 会员中心首页
	 * @access  private（权限）
	 * 
	 */
	private function front_home() {
		$member_info	= array();

		/*会员信息*/
		$member_info	= $this->mod_front_member_info();
		$sex_array		= array(1=>$this->binz_tpl->var_all['home_member_edit_sex_1'],2=>$this->binz_tpl->var_all['home_member_edit_sex_2'],3=>$this->binz_tpl->var_all['home_member_edit_sex_3']);
		$member_info['member_sex'] = $sex_array[$member_info['member_sex']];
		$this->binz_tpl->set_var('member_info',$member_info);

		/*评论总数*/
		$comments_num	= $this->mod_comments_num();
		$this->binz_tpl->set_var('comments_num',$comments_num);

		/*最近评论*/
		$new_comments	= $this->mod_comments_list(5);
		$this->binz_tpl->set_var('new_comments',$new_comments);

		/*左侧边栏标记*/
		$this->binz_tpl->set_var('home_type','home');
		/*载入模板*/
		$this->binz_tpl->set_tag('member_home');
	}
	/**
	 * front_member_edit
	 *
	 * 会员资料修改
	 * @access  private（权限）
	 * 
	 */
	private function front_member_edit() {
		$member_info	= array();

		$member_info	= $this->mod_front_member_info();
		$this->binz_tpl->set_var('member_info',$member_info);

		$this->binz_tpl->set_var('select_sex',$this->binz_common->html_select('member_sex',array(1=>$this->binz_tpl->var_all['home_member_edit_sex_1'],2=>$this->binz_tpl->var_all['home_member_edit_sex_2'],3=>$this->binz_tpl->var_all['home_member_edit_sex_3']),array(),$member_info['member_sex']));
		/*左侧边栏标记*/
		$this->binz_tpl->set_var('home_type','edit');

		$this->binz_tpl->set_tag('member_edit');
	}
	/**
	 * front_member_edit_save
	 *
	 * 会员资料保存
	 * @access  private（权限）
	 * 
	 */	
	private function front_member_edit_save() {
		$member_class	= $this->import_class('ModFrontMember',ROOT_PATH.'/model','mod');
		if(!$member_class->mod_front_check_email($_POST['member_email'],$_SESSION['member_name'])) {
			$this->binz_common->front_msg($this->binz_tpl->var_all['home_member_email_no'],0,$link,$this->binz_tpl,true,2);
		}
		$edit_state		= false;
		$edit_state		= $this->mod_front_member_edit();
		if($edit_state) {
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['home_member_edit_ok'],0,$link,$this->binz_tpl,true,2);
		} else {
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['home_member_edit_false'],0,$link,$this->binz_tpl,true,2);
		}
	}
	/**
	 * front_member_img
	 *
	 * 头像上传操作
	 * @access  private（权限）
	 * 
	 */
	private function front_member_img() {
		$upload_path	= 'upload/member';			//头像上传地址

		/*上传头像图片*/
		$image_insert		= $this->mod_front_upload_img($upload_path);
		if($image_insert) {
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['home_member_edit_top_ok'],0,$link,$this->binz_tpl,true,2);
		} else {
			/*跳转页面*/
			$this->binz_common->front_msg($this->binz_tpl->var_all['home_member_edit_top_false'],0,$link,$this->binz_tpl,true,2);
		}
	}
	/**
	 * front_change_pw
	 *
	 * 会员密码修改
	 * @access  private（权限）
	 * 
	 */
	private function front_change_pw() {
		$member_info	= array();
		$member_info	= $this->mod_front_member_info();
		$this->binz_tpl->set_var('old_passwd',$member_info['member_passwd']);
		/*左侧边栏标记*/
		$this->binz_tpl->set_var('home_type','passwd');

		$this->binz_tpl->set_tag('member_change_pw');
	}
	/**
	 * front_change_pw_save
	 *
	 * 会员密码修改操作
	 * @access  private（权限）
	 * 
	 */
	private function front_change_pw_save() {
		$change_state	= false;
		$message		= '';

		$change_state	= $this->mod_front_change_passwd();
		if(intval($change_state) == 3) {	//原密码输入有误
			$this->binz_common->front_msg($this->binz_tpl->var_all['home_member_pw_old_false'],0,$link,$this->binz_tpl,true,2);
			exit();
		}
		if (intval($change_state) == 2) {	//密码为空，或是两次输入的密码不同
			$this->binz_common->front_msg($this->binz_tpl->var_all['home_member_pw_empty'],0,$link,$this->binz_tpl,true,2);
			exit();
		}
		if($change_state) {
			$message	= $this->binz_tpl->var_all['home_member_pw_edit_ok'];//'密码修改成功！';
		} else {
			$message	= $this->binz_tpl->var_all['home_member_pw_edit_no'];//'密码修改失败！';
		}
		$this->binz_common->front_msg($message,0,$link,$this->binz_tpl,true,2);
	}
	/**
	 * front_comments
	 *
	 * 会员评论
	 * @access  private（权限）
	 * 
	 */
	private function front_comments() {
		$comments_list_array	= array();
		$perpage				= 10;			//每页记录数

		/*评论列表*/
		$comments_list_array	= $this->mod_front_comments_list($_GET['binz_page'],$perpage);
		if($comments_list_array == false) {
			$this->base_back_index();
		}
		$this->binz_tpl->set_var('comments_array',$comments_list_array['list']);
		/*分页*/
		$page_class		= $this->import_class('Page',ROOT_PATH.'/include');
		$page_class->set_page(array('total'=>$article_list_array['count']['comments_num'],'perpage'=>$perpage));
		$this->binz_tpl->set_var('show_page',$page_class->show(1));
		/*左侧边栏标记*/
		$this->binz_tpl->set_var('home_type','comments');
		/*载入模板*/
		$this->binz_tpl->set_tag('member_comments');
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>