<?php
/***
*
*@package binzcms
*@version $id:FrontCodeClass.php, v 1.0
*@author 斌子
*@Tue Jan 06 00:47:00 CST 2009
*@copyright (c) 2009-2010 binzcms
*
*/
if(!defined("BINZCMS")) {
	die("hacking");
}
/**
 *
 * FrontCodeClass
 * 验证码类
 * 
 */
class FrontCodeClass {
	/**
	 * __construct
	 *
	 * 构造函数
	 * @access  public（权限）
	 */
	public function __construct() {
		$this->create_code();
	}
	/**
	 * create_code
	 *
	 * 生成验证码
	 * @access  public（权限）
	 */
	public function create_code() {

		$range_string	= $this->create_range();

		if(function_exists('imagecreate')) {
			$code_image	= imagecreate(50,20);
			imagecolorallocate($code_image,255,255,255);

			/*画干扰点*/
			for ($i=0; $i<20; $i++) {
				$randColor = imagecolorallocate($code_image, rand(0, 255), rand(0, 255), rand(0, 255));
				imagesetpixel($code_image, rand(0, 52), rand(0, 20), $randColor);
			}

			/*画边框*/
			$bordercolor = imagecolorallocate($code_image, 100,100,100);
			imagerectangle($code_image, 0, 0, 49, 19, $bordercolor);

			/*输出文字*/
			$fontColor = imagecolorallocate($code_image, 48,61,50);
			for($i=0;$i<strlen($range_string);$i++)	{
				$bc = mt_rand(0,1);
				imagestring($code_image, 5, $i*10+6, mt_rand(2,4), $range_string[$i], $fontColor);
			}
			header("Pragma:no-cache\r\n");
			header("Cache-Control:no-cache\r\n");
			header("Expires:0\r\n");
			header("content-type:image/png\r\n");

			imagepng($code_image);
			imagedestroy($code_image);
		} else {

		}
	}
	/**
	 * create_range
	 *
	 * 产生随机4位数
	 * @access  private（权限）
	 */
	private function create_range() {
		$range_number	= '';
		$str_array		= range('A','Z');
		for ($i=1;$i<=4;$i++) {
			$range_number	.= $str_array[rand(0,25)];
		}
		$_SESSION['binz_code']	= strtolower($range_number);
		return $range_number;
	}
	/**
	 * __destruct
	 *
	 * 析构函数
	 * @access  public（权限）
	 */
	public function __destruct() {

	}
}
?>